/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.html;

import com.mathworks.html.CloneableUrl;
import com.mathworks.html.EncodingUtils;
import com.mathworks.html.Url;
import com.mathworks.html.UrlBuilder;
import com.mathworks.html.UrlVisitor;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public class CustomProtocolUrl
extends CloneableUrl<CustomProtocolUrl> {
    private final String fProtocol;
    private final String fSlashes;
    private final String fCommand;

    public CustomProtocolUrl(String string, String string2) {
        this(string, string2, Collections.emptyMap(), null);
    }

    public CustomProtocolUrl(String string, String string2, Map<String, List<String>> map, String string3) {
        this(string, "//", string2, map, string3);
    }

    CustomProtocolUrl(String string, String string2, String string3) {
        this(string, string2, string3, Collections.emptyMap(), null);
    }

    CustomProtocolUrl(String string, String string2, String string3, Map<String, List<String>> map, String string4) {
        super(map, string4);
        this.fProtocol = string;
        this.fSlashes = string2;
        this.fCommand = string3;
    }

    public String getCommand() {
        return this.fCommand;
    }

    @Override
    public Url.UrlType getType() {
        return Url.UrlType.CUSTOM_PROTOCOL;
    }

    @Override
    public String getProtocol() {
        return this.fProtocol;
    }

    @Override
    public String getBaseUrl() {
        return String.format("%s:%s%s", this.fProtocol, this.fSlashes, EncodingUtils.encodeBaseUrl(this.fCommand, true));
    }

    @Override
    public void accept(UrlVisitor urlVisitor) {
        urlVisitor.visitCustomProtocolUrl(this);
    }

    @Override
    protected CloneableUrl<CustomProtocolUrl> append(String ... stringArray) {
        StringBuilder stringBuilder = new StringBuilder(this.fCommand);
        for (String string : stringArray) {
            stringBuilder.append(string);
        }
        return new CustomProtocolUrl(this.fProtocol, this.fSlashes, stringBuilder.toString(), this.getParameters(), this.getTarget());
    }

    @Override
    protected CustomProtocolUrl createModifiedCopy(Map<String, List<String>> map, String string) {
        return new CustomProtocolUrl(this.fProtocol, this.fSlashes, this.fCommand, map, string);
    }

    @Override
    public UrlBuilder<CustomProtocolUrl> toUrlBuilder() {
        return new UrlBuilder<CustomProtocolUrl>(this);
    }

    @Override
    protected Object[] getBaseUrlComparisonItems() {
        return new Object[]{this.fCommand};
    }
}

