/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.html;

import com.mathworks.html.BrowserRequest;
import com.mathworks.html.CustomProtocolUrl;
import com.mathworks.html.FileUrl;
import com.mathworks.html.RequestHandler;
import com.mathworks.html.Url;
import com.mathworks.html.UrlTransformer;
import com.mathworks.html.WebUrl;
import java.awt.Desktop;
import java.io.File;
import java.util.HashSet;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class FileExtensionHandler
implements RequestHandler {
    private static final Pattern EXTENSION_PATTERN = Pattern.compile("\\.(\\w+)$");
    private final ExtensionDetector fExtensionDetector;

    public FileExtensionHandler(String ... stringArray) {
        this.fExtensionDetector = new ExtensionDetector(stringArray);
    }

    @Override
    public boolean handleRequest(BrowserRequest browserRequest) {
        Url url = browserRequest.getUrl();
        if (url.getType() == Url.UrlType.FILE || url.getType() == Url.UrlType.WEB) {
            return (Boolean)this.fExtensionDetector.transformUrl(url);
        }
        return false;
    }

    private static class ExtensionDetector
    extends UrlTransformer<Boolean> {
        private final Set<String> iExtensions = new HashSet<String>();

        private ExtensionDetector(String ... stringArray) {
            for (String string : stringArray) {
                if (string.charAt(0) == '.') {
                    string = string.substring(1);
                }
                this.iExtensions.add(string);
            }
        }

        @Override
        protected Boolean transformWebUrl(WebUrl webUrl) {
            String string = webUrl.getBaseUrl();
            if (this.hasMatchingExtension(string)) {
                try {
                    Desktop.getDesktop().browse(webUrl.toURL().toURI());
                }
                catch (Exception exception) {
                    // empty catch block
                }
                return true;
            }
            return false;
        }

        @Override
        protected Boolean transformFileUrl(FileUrl fileUrl) {
            File file = fileUrl.getFile();
            String string = file.getName();
            if (this.hasMatchingExtension(string)) {
                try {
                    Desktop.getDesktop().open(file);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                return true;
            }
            return false;
        }

        @Override
        protected Boolean transformCustomProtocolUrl(CustomProtocolUrl customProtocolUrl) {
            return false;
        }

        private boolean hasMatchingExtension(String string) {
            Matcher matcher = EXTENSION_PATTERN.matcher(string);
            if (matcher.find()) {
                String string2 = matcher.group(1);
                return this.iExtensions.contains(string2);
            }
            return false;
        }
    }
}

