/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.html;

import com.mathworks.html.FindInPageHandler;
import com.mathworks.html.FindOption;
import com.mathworks.html.HtmlComponent;
import com.mathworks.html.HtmlDataListener;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.EnumSet;
import java.util.ResourceBundle;
import java.util.Set;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.JToolBar;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class FindPanel {
    private static final Color FIND_FAILED_BG_COLOR = new Color(204, 102, 102);
    private final HtmlComponent fHtmlComponent;
    private final JComponent fPanel;
    private final JTextField fTextField;
    private final Set<FindOption> fFindOptions = EnumSet.noneOf(FindOption.class);

    public FindPanel(HtmlComponent htmlComponent, FindInPageHandler findInPageHandler) {
        this(htmlComponent, findInPageHandler, ResourceBundle.getBundle("com.mathworks.html.resources.RES_HtmlPanel"));
    }

    public FindPanel(HtmlComponent htmlComponent, FindInPageHandler findInPageHandler, ResourceBundle resourceBundle) {
        this.fHtmlComponent = htmlComponent;
        this.fTextField = this.buildTextField();
        JToolBar jToolBar = new JToolBar();
        jToolBar.setLayout(new BoxLayout(jToolBar, 0));
        jToolBar.setFloatable(false);
        jToolBar.add(Box.createHorizontalStrut(2));
        jToolBar.add(FindPanel.buildCloseButton(findInPageHandler));
        jToolBar.add(Box.createHorizontalStrut(2));
        jToolBar.add(FindPanel.buildFindLabel(resourceBundle));
        jToolBar.add(this.fTextField);
        jToolBar.add(Box.createHorizontalStrut(2));
        JPanel jPanel = new JPanel();
        jPanel.setOpaque(false);
        JButton jButton = FindPanel.buildNavButton(resourceBundle.getString("find.label.next"), new NextActionListener());
        jPanel.add(jButton);
        JButton jButton2 = FindPanel.buildNavButton(resourceBundle.getString("find.label.previous"), new PreviousActionListener());
        jPanel.add(jButton2);
        jToolBar.add(jPanel);
        jToolBar.add(Box.createHorizontalStrut(7));
        String string = resourceBundle.getString("find.label.match_case");
        JCheckBox jCheckBox = this.buildFindOptionCheckBox(FindOption.MATCH_CASE, string);
        jToolBar.add(jCheckBox);
        jToolBar.add(Box.createHorizontalStrut(5));
        this.fPanel = jToolBar;
    }

    private static Component buildCloseButton(final FindInPageHandler findInPageHandler) {
        JButton jButton = new JButton(new ImageIcon(FindPanel.class.getResource("resources/closebox.gif")));
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                findInPageHandler.closeFindInPage();
            }
        });
        jButton.setOpaque(false);
        jButton.setBorder(new EmptyBorder(3, 3, 3, 3));
        jButton.setBorderPainted(false);
        jButton.setRolloverEnabled(true);
        jButton.setMargin(new Insets(2, 2, 2, 2));
        return jButton;
    }

    private static Component buildFindLabel(ResourceBundle resourceBundle) {
        JLabel jLabel = new JLabel(resourceBundle.getString("find.label.find"));
        jLabel.setBorder(new EmptyBorder(0, 3, 0, 3));
        return jLabel;
    }

    private JTextField buildTextField() {
        JTextField jTextField = new JTextField();
        jTextField.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                FindPanel.this.findNext();
            }
        });
        jTextField.getDocument().addDocumentListener(new ResetTextFieldListener());
        jTextField.setMargin(new Insets(3, 2, 3, 2));
        Dimension dimension = jTextField.getPreferredSize();
        jTextField.setMinimumSize(new Dimension(100, dimension.height));
        jTextField.setPreferredSize(new Dimension(100, dimension.height));
        jTextField.setMaximumSize(new Dimension(Integer.MAX_VALUE, dimension.height));
        return jTextField;
    }

    private static JButton buildNavButton(String string, ActionListener actionListener) {
        JButton jButton = new JButton(string);
        jButton.addActionListener(actionListener);
        jButton.setOpaque(false);
        return jButton;
    }

    private JCheckBox buildFindOptionCheckBox(final FindOption findOption, String string) {
        JCheckBox jCheckBox = new JCheckBox(string);
        jCheckBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                int n = itemEvent.getStateChange();
                if (n == 1) {
                    FindPanel.this.fFindOptions.add(findOption);
                } else if (n == 2) {
                    FindPanel.this.fFindOptions.remove((Object)findOption);
                }
            }
        });
        jCheckBox.setOpaque(false);
        return jCheckBox;
    }

    private void findNext() {
        this.fFindOptions.remove((Object)FindOption.SEARCH_BACKWARDS);
        this.doFind();
    }

    private void findPrevious() {
        this.fFindOptions.add(FindOption.SEARCH_BACKWARDS);
        this.doFind();
    }

    private void doFind() {
        this.fHtmlComponent.findInPage(this.fTextField.getText(), this.fFindOptions, new HtmlDataListener<Boolean>(){

            @Override
            public void dataRetrieved(Boolean bl) {
                if (bl.booleanValue()) {
                    FindPanel.this.resetTextFieldColors();
                } else {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            FindPanel.this.fTextField.setBackground(FIND_FAILED_BG_COLOR);
                            FindPanel.this.fTextField.setForeground(Color.WHITE);
                        }
                    });
                }
            }
        });
    }

    private void resetTextFieldColors() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                FindPanel.this.fTextField.setBackground(Color.WHITE);
                FindPanel.this.fTextField.setForeground(Color.BLACK);
            }
        });
    }

    public Component getComponent() {
        return this.fPanel;
    }

    public void requestFocusInTextField() {
        this.fTextField.requestFocusInWindow();
    }

    private class PreviousActionListener
    implements ActionListener {
        private PreviousActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            FindPanel.this.findPrevious();
        }
    }

    private class NextActionListener
    implements ActionListener {
        private NextActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            FindPanel.this.findNext();
        }
    }

    private class ResetTextFieldListener
    implements DocumentListener {
        private ResetTextFieldListener() {
        }

        @Override
        public void insertUpdate(DocumentEvent documentEvent) {
            FindPanel.this.resetTextFieldColors();
        }

        @Override
        public void removeUpdate(DocumentEvent documentEvent) {
            FindPanel.this.resetTextFieldColors();
        }

        @Override
        public void changedUpdate(DocumentEvent documentEvent) {
            FindPanel.this.resetTextFieldColors();
        }
    }
}

