/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.html;

import com.mathworks.html.HtmlActionGroup;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import javax.swing.Action;

public class HtmlActionGroups {
    private final Collection<HtmlActionGroup> fActionGroups = new LinkedList<HtmlActionGroup>();

    public HtmlActionGroups() {
        this(null);
    }

    public HtmlActionGroups(Collection<HtmlActionGroup> collection) {
        if (collection != null) {
            this.fActionGroups.addAll(collection);
        }
    }

    public Collection<HtmlActionGroup> getAllGroups() {
        return Collections.unmodifiableCollection(this.fActionGroups);
    }

    public Collection<String> getGroupNames() {
        LinkedList<String> linkedList = new LinkedList<String>();
        for (HtmlActionGroup htmlActionGroup : this.fActionGroups) {
            linkedList.add(htmlActionGroup.getName());
        }
        return linkedList;
    }

    public Collection<Action> getAllActions() {
        LinkedList<Action> linkedList = new LinkedList<Action>();
        for (HtmlActionGroup htmlActionGroup : this.fActionGroups) {
            Collection<Action> collection = htmlActionGroup.getAllActions().values();
            linkedList.addAll(collection);
        }
        return linkedList;
    }

    public HtmlActionGroup getCustomActionGroup(String string) {
        for (HtmlActionGroup htmlActionGroup : this.fActionGroups) {
            if (!htmlActionGroup.getName().equalsIgnoreCase(string)) continue;
            return htmlActionGroup;
        }
        return null;
    }

    public void addCustomActionGroup(HtmlActionGroup htmlActionGroup) {
        if (htmlActionGroup != null) {
            this.fActionGroups.add(htmlActionGroup);
        }
    }

    public void addAllCustomActionGroups(HtmlActionGroups htmlActionGroups) {
        if (htmlActionGroups == null) {
            return;
        }
        this.fActionGroups.addAll(htmlActionGroups.getAllGroups());
    }
}

