/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.html;

import com.mathworks.html.ProxyAuthenticationFailureHandler;
import com.mathworks.html.ProxyCredentials;
import java.util.HashSet;
import java.util.Set;

public class ProxySettings {
    private static final Set<ProxySettingsListener> LISTENERS = new HashSet<ProxySettingsListener>();
    private static ProxyAuthenticationFailureHandler sFailureHandler = null;
    private static ProxySettings sCurrentSettings = null;
    private final String fHost;
    private final int fPort;
    private final ProxyCredentials fCredentials;

    private ProxySettings(String string, int n, ProxyCredentials proxyCredentials) {
        this.fHost = string;
        this.fPort = n;
        this.fCredentials = proxyCredentials;
    }

    public static void addProxyListener(ProxySettingsListener proxySettingsListener) {
        LISTENERS.add(proxySettingsListener);
    }

    public static synchronized void clearProxySettings() {
        sCurrentSettings = null;
        ProxySettings.notifyListeners(null);
    }

    public static synchronized void configureProxy(String string, int n, String string2, String string3) {
        if (string2 == null || string2.trim().isEmpty()) {
            ProxySettings.configureProxy(string, n, null);
        } else {
            ProxySettings.configureProxy(string, n, new ProxyCredentials(string2, string3));
        }
    }

    public static synchronized void configureProxy(String string, int n, ProxyCredentials proxyCredentials) {
        ProxySettings proxySettings;
        sCurrentSettings = proxySettings = new ProxySettings(string, n, proxyCredentials);
        ProxySettings.notifyListeners(proxySettings);
    }

    private static void notifyListeners(final ProxySettings proxySettings) {
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                for (ProxySettingsListener proxySettingsListener : LISTENERS) {
                    proxySettingsListener.proxySettingsChanged(proxySettings);
                }
            }
        };
        new Thread(runnable).start();
    }

    public static synchronized ProxySettings getCurrentSettings() {
        return sCurrentSettings;
    }

    public String getHost() {
        return this.fHost;
    }

    public int getPort() {
        return this.fPort;
    }

    public ProxyCredentials getCredentials() {
        return this.fCredentials;
    }

    public static void setAuthenticationFailureHandler(ProxyAuthenticationFailureHandler proxyAuthenticationFailureHandler) {
        sFailureHandler = proxyAuthenticationFailureHandler;
    }

    public static ProxyAuthenticationFailureHandler getAuthenticationFailureHandler() {
        return sFailureHandler;
    }

    public static interface ProxySettingsListener {
        public void proxySettingsChanged(ProxySettings var1);
    }
}

