/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.html;

import com.mathworks.html.CustomProtocolUrl;
import com.mathworks.html.FileUrl;
import com.mathworks.html.Url;
import com.mathworks.html.UrlBuilder;
import com.mathworks.html.UrlTransformer;
import com.mathworks.html.WebUrl;

class UrlBuilderFactory {
    private UrlBuilderFactory() {
    }

    static <T extends Url> UrlBuilder<T> toUrlBuilder(T t) {
        UrlBuilder urlBuilder = (UrlBuilder)new UrlBuilderTransformer().transformUrl(t);
        return urlBuilder;
    }

    private static class UrlBuilderTransformer
    extends UrlTransformer<UrlBuilder<? extends Url>> {
        private UrlBuilderTransformer() {
        }

        @Override
        protected UrlBuilder<WebUrl> transformWebUrl(WebUrl webUrl) {
            return webUrl.toUrlBuilder();
        }

        @Override
        protected UrlBuilder<FileUrl> transformFileUrl(FileUrl fileUrl) {
            return fileUrl.toUrlBuilder();
        }

        @Override
        protected UrlBuilder<CustomProtocolUrl> transformCustomProtocolUrl(CustomProtocolUrl customProtocolUrl) {
            return customProtocolUrl.toUrlBuilder();
        }
    }
}

