/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.html;

import com.mathworks.html.CloneableUrl;
import com.mathworks.html.CustomProtocolUrl;
import com.mathworks.html.EncodingUtils;
import com.mathworks.html.FileUrl;
import com.mathworks.html.Url;
import com.mathworks.html.UrlBuilder;
import com.mathworks.html.UrlPartParser;
import com.mathworks.html.WebUrl;
import java.io.File;
import java.io.FileFilter;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

class UrlParser {
    private static final Pattern ENTITY_PATTERN = Pattern.compile("&#(x?)(\\d+);");
    private static final Pattern URL_PARTS_PATTERN = Pattern.compile("\\A([a-zA-Z0-9:]{2,}):(/*)(.*)\\Z");
    private static final Pattern CUSTOM_PROTOCOL_PARAM_AND_TARGET_PATTERN = Pattern.compile("(?<=^[\\w.]+)[?#].*");
    private static final Pattern INFER_FILE_PATTERN = Pattern.compile("^/|[a-zA-Z]:[\\\\/]|\\\\\\\\");
    private static final Pattern INFER_HTTP_PATTERN = Pattern.compile("^[^/]+\\.[a-zA-Z]{2,}(/|$)");
    private static final Pattern INFER_LOCALHOST_PATTERN = Pattern.compile("^localhost(:\\d+)?(/|$)");
    private static FileFilter sExistenceRules = new DefaultFileExistenceRules();

    private UrlParser() {
    }

    static Url parse(URL uRL) {
        String string = uRL.getProtocol();
        if (string.equals("file")) {
            return new FileUrl(uRL);
        }
        if (WebUrl.WEB_URL_PROTOCOLS.contains(string)) {
            return new WebUrl(uRL);
        }
        throw new IllegalArgumentException("Cannot map URL " + uRL + " to a Url object.");
    }

    static Url parse(String string) throws MalformedURLException {
        return UrlParser.parseToUrlBuilder(string).toUrl();
    }

    static UrlBuilder<? extends Url> parseToUrlBuilder(String string) throws MalformedURLException {
        if (string == null) {
            throw new MalformedURLException("URL may not be null");
        }
        String string2 = UrlParser.resolveCharacterEntities(string);
        UrlBuilder<? extends Url> urlBuilder = UrlParser.createUrlBuilder(string2);
        return urlBuilder == null ? UrlParser.handleUrlWithoutProtocol(string) : urlBuilder;
    }

    private static UrlBuilder<? extends Url> createUrlBuilder(String string) throws MalformedURLException {
        Matcher matcher;
        if (INFER_LOCALHOST_PATTERN.matcher(string).find()) {
            string = "http://" + string;
        }
        if ((matcher = URL_PARTS_PATTERN.matcher(string)).find()) {
            String string2 = matcher.group(1);
            String string3 = matcher.group(2);
            String string4 = matcher.group(3);
            UrlPartParser<? extends Url> urlPartParser = UrlParser.getUrlPartParser(string2, string3);
            Url url = urlPartParser.parseUrlParts(string4);
            return url.toUrlBuilder();
        }
        return null;
    }

    private static UrlPartParser<? extends Url> getUrlPartParser(String string, String string2) {
        if (string.equals("file")) {
            return new FileUrlParser();
        }
        if (WebUrl.WEB_URL_PROTOCOLS.contains(string)) {
            return new WebUrlParser(string, string2);
        }
        return new CustomProtocolUrlParser(string, string2);
    }

    private static UrlBuilder<? extends Url> handleUrlWithoutProtocol(String string) throws MalformedURLException {
        File file = UrlParser.checkForFile(string);
        if (file != null) {
            return UrlBuilder.fromFile(file);
        }
        UrlBuilderParser urlBuilderParser = new UrlBuilderParser();
        return (UrlBuilder)urlBuilderParser.parseUrlParts(string);
    }

    private static String resolveCharacterEntities(String string) {
        Matcher matcher = ENTITY_PATTERN.matcher(string);
        StringBuffer stringBuffer = new StringBuffer();
        while (matcher.find()) {
            String string2 = matcher.group(2);
            int n = matcher.group(1).equals("x") ? 16 : 10;
            char c = (char)Integer.parseInt(string2, n);
            matcher.appendReplacement(stringBuffer, String.valueOf(c));
        }
        matcher.appendTail(stringBuffer);
        return stringBuffer.toString();
    }

    static CloneableUrl<? extends Url> parseBaseUrl(String string) throws MalformedURLException {
        File file = UrlParser.checkForFile(string);
        if (file != null) {
            return new FileUrl(file);
        }
        return UrlParser.inferUrlType(string);
    }

    private static File checkForFile(String string) {
        File file;
        String string2;
        String string3 = string2 = EncodingUtils.needsDecoding(string) ? EncodingUtils.decodeUrl(string) : string;
        if (File.separatorChar == '/') {
            string2 = string2.replace('\\', '/');
        }
        return UrlParser.fileExists(file = new File(string2)) ? file : null;
    }

    private static boolean fileExists(File file) {
        return sExistenceRules.accept(file);
    }

    private static CloneableUrl<? extends Url> inferUrlType(String string) throws MalformedURLException {
        if (INFER_FILE_PATTERN.matcher(string).find()) {
            return new FileUrl(new File(string));
        }
        if (INFER_HTTP_PATTERN.matcher(string).find()) {
            URL uRL = new URL("http://" + string);
            return new WebUrl(uRL);
        }
        throw new MalformedURLException("Could not convert " + string + " to a Url object");
    }

    static void addParameter(Map<String, List<String>> map, String string, String ... stringArray) {
        UrlParser.addParameter(map, string, Arrays.asList(stringArray));
    }

    static void addParameter(Map<String, List<String>> map, String string, List<String> list) {
        List<String> list2 = map.get(string);
        if (list2 == null) {
            list2 = new LinkedList<String>();
            map.put(string, list2);
        }
        list2.addAll(list);
    }

    static void addParameters(Map<String, List<String>> map, Map<String, List<String>> map2) {
        for (Map.Entry<String, List<String>> entry : map2.entrySet()) {
            UrlParser.addParameter(map, entry.getKey(), entry.getValue());
        }
    }

    private static void setFileExistenceRules(FileFilter fileFilter) {
        sExistenceRules = fileFilter == null ? new DefaultFileExistenceRules() : fileFilter;
    }

    private static class DefaultFileExistenceRules
    implements FileFilter {
        private DefaultFileExistenceRules() {
        }

        @Override
        public boolean accept(File file) {
            return file.exists();
        }
    }

    private static class UrlBuilderParser
    extends UrlPartParser<UrlBuilder<? extends Url>> {
        private UrlBuilderParser() {
        }

        @Override
        protected UrlBuilder<? extends Url> buildUrl(String string, Map<String, List<String>> map, String string2) throws MalformedURLException {
            CloneableUrl<? extends Url> cloneableUrl = UrlParser.parseBaseUrl(string);
            UrlBuilder<? extends Url> urlBuilder = cloneableUrl.toUrlBuilder();
            urlBuilder.setParameters(map);
            urlBuilder.setTarget(string2);
            return urlBuilder;
        }
    }

    private static class CustomProtocolUrlParser
    extends UrlPartParser<CustomProtocolUrl> {
        private final String iProtocol;
        private final String iSlashes;

        private CustomProtocolUrlParser(String string, String string2) {
            super(CUSTOM_PROTOCOL_PARAM_AND_TARGET_PATTERN);
            this.iProtocol = string;
            this.iSlashes = string2;
        }

        @Override
        protected CustomProtocolUrl buildUrl(String string, Map<String, List<String>> map, String string2) {
            String string3 = EncodingUtils.decodeBaseUrl(string);
            return new CustomProtocolUrl(this.iProtocol, this.iSlashes, string3, map, string2);
        }
    }

    private static class FileUrlParser
    extends UrlPartParser<FileUrl> {
        private FileUrlParser() {
        }

        @Override
        protected FileUrl buildUrl(String string, Map<String, List<String>> map, String string2) {
            String string3 = string.replaceFirst("^localhost", "");
            return new FileUrl(FileUrlParser.toFile(string3), map, string2);
        }

        private static File toFile(String string) {
            String string2 = string;
            if (File.separator.equals("\\")) {
                File file = new File("//" + EncodingUtils.decodeBaseUrl(string2));
                if (UrlParser.fileExists(file)) {
                    return file;
                }
            } else if (!string.startsWith("about:")) {
                string2 = "/" + string2;
            }
            return new File(EncodingUtils.decodeBaseUrl(string2));
        }
    }

    private static class WebUrlParser
    extends UrlPartParser<WebUrl> {
        private final String iProtocol;
        private final String iSlashes;

        private WebUrlParser(String string, String string2) {
            this.iProtocol = string;
            this.iSlashes = string2;
        }

        @Override
        protected WebUrl buildUrl(String string, Map<String, List<String>> map, String string2) throws MalformedURLException {
            if (string.trim().isEmpty()) {
                throw new MalformedURLException("Url must specify a location.");
            }
            return new WebUrl(new URL(this.iProtocol + ':' + this.iSlashes + string), map, string2);
        }
    }
}

