/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.html.jxbrowser;

import com.mathworks.html.BrowserListeners;
import com.mathworks.html.HtmlPanelSupport;
import com.mathworks.html.HtmlPanelSupportFactory;
import com.mathworks.html.jxbrowser.JxBrowserPanel;
import com.teamdev.jxbrowser.Browser;
import java.awt.Component;
import javax.swing.SwingUtilities;

public class JxBrowserFactory
implements HtmlPanelSupportFactory {
    private final Browser fBrowser;
    private Component fBrowserComponent;
    private HtmlPanelSupportFactory.ComponentCreatedListener fCreatedListener;

    public JxBrowserFactory() {
        this(null);
    }

    JxBrowserFactory(Browser browser) {
        this.fBrowser = browser;
    }

    @Override
    public HtmlPanelSupport buildSupport(BrowserListeners browserListeners) {
        final JxBrowserPanel jxBrowserPanel = this.createJxBrowserPanel(browserListeners);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                JxBrowserFactory.this.setBrowserComponent(jxBrowserPanel.getComponent());
            }
        });
        return jxBrowserPanel;
    }

    private JxBrowserPanel createJxBrowserPanel(BrowserListeners browserListeners) {
        if (this.fBrowser == null) {
            return JxBrowserPanel.createJxBrowserPanel(browserListeners);
        }
        return JxBrowserPanel.createJxBrowserPanel(this.fBrowser, browserListeners);
    }

    private synchronized void setBrowserComponent(Component component) {
        if (this.fCreatedListener != null) {
            this.fCreatedListener.panelCreated(component);
            this.fCreatedListener = null;
        } else {
            this.fBrowserComponent = component;
        }
    }

    @Override
    public synchronized void doWhenPanelCreated(HtmlPanelSupportFactory.ComponentCreatedListener componentCreatedListener) {
        if (this.fBrowserComponent == null) {
            this.fCreatedListener = componentCreatedListener;
        } else {
            componentCreatedListener.panelCreated(this.fBrowserComponent);
            this.fBrowserComponent = null;
        }
    }
}

