/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.html.jxbrowser;

import com.mathworks.html.ProxyCredentials;
import com.mathworks.html.ProxySettings;
import com.teamdev.jxbrowser.BrowserServices;
import com.teamdev.jxbrowser.BrowserType;
import com.teamdev.jxbrowser.proxy.ProxyConfig;
import com.teamdev.jxbrowser.proxy.ProxyServer;
import com.teamdev.jxbrowser.proxy.ServerType;

public class JxBrowserProxyBridge {
    private JxBrowserProxyBridge() {
    }

    static void init(final BrowserType browserType) {
        ProxySettings proxySettings = ProxySettings.getCurrentSettings();
        JxBrowserProxyBridge.updateProxySettings(proxySettings, browserType);
        ProxySettings.addProxyListener(new ProxySettings.ProxySettingsListener(){

            @Override
            public void proxySettingsChanged(ProxySettings proxySettings) {
                JxBrowserProxyBridge.updateProxySettings(proxySettings, browserType);
            }
        });
    }

    private static void updateProxySettings(ProxySettings proxySettings, BrowserType browserType) {
        ProxyConfig proxyConfig = BrowserServices.getInstance().getProxyConfig();
        if (proxySettings == null) {
            if (JxBrowserProxyBridge.useAutoDetect(browserType)) {
                proxyConfig.setAutoDetectForNetwork(true);
            }
        } else {
            ProxyServer proxyServer = JxBrowserProxyBridge.createProxyServer(proxySettings);
            for (ServerType serverType : ServerType.values()) {
                proxyConfig.setProxy(serverType, proxyServer);
            }
        }
    }

    private static boolean useAutoDetect(BrowserType browserType) {
        return !browserType.equals(BrowserType.IE);
    }

    private static ProxyServer createProxyServer(ProxySettings proxySettings) {
        ProxyCredentials proxyCredentials = proxySettings.getCredentials();
        if (proxyCredentials != null) {
            return new ProxyServer(proxySettings.getHost(), proxySettings.getPort(), proxyCredentials.getUsername(), proxyCredentials.getPassword());
        }
        return new ProxyServer(proxySettings.getHost(), proxySettings.getPort());
    }
}

