/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.help.helpui;

import com.mathworks.help.helpui.ComponentHelper;
import com.mathworks.help.helpui.HelpBrowserUtils;
import com.mathworks.html.HtmlActions;
import com.mathworks.html.StandardHtmlActionId;
import java.awt.Container;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Map;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JToolBar;
import javax.swing.SwingUtilities;

public class HelpBrowserToolBar {
    private final JToolBar fToolbar;
    private final ComponentHelper fComponentHelper;

    public HelpBrowserToolBar(HtmlActions htmlActions, ComponentHelper componentHelper) {
        this(htmlActions.getBasicActions(), componentHelper, null);
    }

    public HelpBrowserToolBar(Map<StandardHtmlActionId, ? extends Action> map, ComponentHelper componentHelper, Collection<? extends JButton> collection) {
        assert (SwingUtilities.isEventDispatchThread()) : "HelpBrowserToolBar must be created on the EDT.";
        this.fComponentHelper = componentHelper;
        this.fToolbar = this.createToolbar();
        this.fToolbar.setName("HelpBrowserToolBar");
        this.fToolbar.getAccessibleContext().setAccessibleName("HelpBrowserToolBar");
        this.fToolbar.setBorder(BorderFactory.createEtchedBorder());
        this.fToolbar.setFloatable(false);
        this.addStandardActions(this.fToolbar, map);
        if (collection != null) {
            this.addButtons(this.fToolbar, collection);
        }
    }

    private void addStandardActions(Container container, Map<StandardHtmlActionId, ? extends Action> map) {
        LinkedHashSet<JButton> linkedHashSet = new LinkedHashSet<JButton>();
        for (StandardHtmlActionId standardHtmlActionId : StandardHtmlActionId.values()) {
            Action action = map.get(standardHtmlActionId);
            if (action == null) continue;
            JButton jButton = this.getActionButton(standardHtmlActionId, action);
            linkedHashSet.add(jButton);
        }
        if (!linkedHashSet.isEmpty()) {
            this.addButtons(container, linkedHashSet);
        }
    }

    private void addButtons(Container container, Collection<? extends JButton> collection) {
        for (JButton jButton : collection) {
            if (jButton == null) continue;
            container.add(jButton);
            jButton.setBorderPainted(false);
        }
    }

    private JButton getActionButton(StandardHtmlActionId standardHtmlActionId, Action action) {
        JButton jButton = null;
        switch (standardHtmlActionId) {
            case COPY: {
                String string = HelpBrowserUtils.getString("helpbrowser.toolbar.button.copy.alttext");
                Icon icon = this.getIcon(standardHtmlActionId, string);
                jButton = this.createActionButton(icon, "CopyButton", action, HelpBrowserUtils.getString("helpbrowser.toolbar.button.copy.tooltiptext"), string);
                break;
            }
            case FIND: {
                String string = HelpBrowserUtils.getString("helpbrowser.toolbar.button.find.alttext");
                Icon icon = this.getIcon(standardHtmlActionId, string);
                jButton = this.createActionButton(icon, "FindButton", action, HelpBrowserUtils.getString("helpbrowser.toolbar.button.find.tooltiptext"), string);
                break;
            }
            case GO_BACK: {
                String string = HelpBrowserUtils.getString("helpbrowser.toolbar.button.back.alttext");
                Icon icon = this.getIcon(standardHtmlActionId, string);
                jButton = this.createActionButton(icon, "BackButton", action, HelpBrowserUtils.getString("helpbrowser.toolbar.button.back.tooltiptext"), string);
                break;
            }
            case GO_FORWARD: {
                String string = HelpBrowserUtils.getString("helpbrowser.toolbar.button.forward.alttext");
                Icon icon = this.getIcon(standardHtmlActionId, string);
                jButton = this.createActionButton(icon, "ForwardButton", action, HelpBrowserUtils.getString("helpbrowser.toolbar.button.forward.tooltiptext"), string);
                break;
            }
            case HOME: {
                break;
            }
            case PRINT: {
                String string = HelpBrowserUtils.getString("helpbrowser.toolbar.button.print.alttext");
                Icon icon = this.getIcon(standardHtmlActionId, string);
                jButton = this.createActionButton(icon, "PrintButton", action, HelpBrowserUtils.getString("helpbrowser.toolbar.button.print.tooltiptext"), string);
                break;
            }
            case RELOAD: {
                String string = HelpBrowserUtils.getString("helpbrowser.toolbar.button.refresh.alttext");
                Icon icon = this.getIcon(standardHtmlActionId, string);
                jButton = this.createActionButton(icon, "RefreshButton", action, HelpBrowserUtils.getString("helpbrowser.toolbar.button.refresh.tooltiptext"), string);
                break;
            }
            case SAVE_AS: {
                break;
            }
            case VIEW_SOURCE: {
                String string = HelpBrowserUtils.getString("helpbrowser.toolbar.button.pagesource.alttext");
                Icon icon = this.getIcon(standardHtmlActionId, string);
                jButton = this.createActionButton(icon, "PageSourceButton", action, HelpBrowserUtils.getString("helpbrowser.toolbar.button.pagesource.tooltiptext"), string);
            }
        }
        return jButton;
    }

    private JButton createActionButton(Icon icon, String string, Action action, String string2, String string3) {
        JButton jButton = this.createButton(action);
        jButton.setName(string);
        jButton.getAccessibleContext().setAccessibleName(string);
        jButton.setToolTipText(string2);
        if (icon != null) {
            jButton.setIcon(icon);
        } else {
            jButton.setText(string3);
        }
        return jButton;
    }

    protected JComponent getComponent() {
        return this.fToolbar;
    }

    private JToolBar createToolbar() {
        return this.fComponentHelper.createToolbar();
    }

    private JButton createButton(Action action) {
        return this.fComponentHelper.createButton(action);
    }

    private Icon getIcon(StandardHtmlActionId standardHtmlActionId, String string) {
        return this.fComponentHelper.getIcon(standardHtmlActionId, string);
    }
}

