/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.help.helpui.search.index;

import com.mathworks.helpsearch.DocumentationSearchField;
import com.mathworks.helpsearch.index.DocumentTracker;
import com.mathworks.helpsearch.index.IndexerObserver;
import java.io.PrintStream;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;

public class LoggingIndexObserver
implements IndexerObserver<DocumentationSearchField> {
    private final PrintStream fPrintStream;
    private final DateFormat fTimestampFormat = new SimpleDateFormat("yyyy MM dd HH:mm:ss.SSS");
    private int iIndexed = 0;
    private int iUnindexed = 0;

    public LoggingIndexObserver() {
        this(System.out);
    }

    public LoggingIndexObserver(PrintStream printStream) {
        this.fPrintStream = printStream;
    }

    public void indexingStarted() {
        this.fPrintStream.println("*** Indexing started at " + this.fTimestampFormat.format(new Date()));
    }

    public void startDocument(DocumentTracker<DocumentationSearchField> documentTracker) {
    }

    public void parsedDocument(DocumentTracker<DocumentationSearchField> documentTracker) {
    }

    public void createdIndexDocument(DocumentTracker<DocumentationSearchField> documentTracker) {
    }

    public void endDocument(DocumentTracker<DocumentationSearchField> documentTracker) {
        boolean bl;
        boolean bl2 = bl = !documentTracker.getIndexDocuments().isEmpty();
        if (bl) {
            ++this.iIndexed;
        } else {
            ++this.iUnindexed;
        }
        this.fPrintStream.println("\t" + documentTracker.getDocumentationDocument().getRelativePath() + " indexed? " + String.valueOf(bl));
    }

    public void indexingFinished() {
        this.fPrintStream.println("*** Indexing finished at " + this.fTimestampFormat.format(new Date()));
        this.fPrintStream.println("Indexed " + this.iIndexed + " documents");
        this.fPrintStream.println("Omitted " + this.iUnindexed + " documents");
    }
}

