/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.help.helpui.suggestions;

import com.mathworks.help.helpui.DocRoot;
import com.mathworks.help.helpui.HelpBrowserUtils;
import com.mathworks.help.helpui.json.JsonEntity;
import com.mathworks.help.helpui.json.JsonObject;
import com.mathworks.help.helpui.suggestions.SuggestionUtils;
import com.mathworks.helpsearch.InformationType;
import com.mathworks.helpsearch.suggestion.PageSuggestion;
import com.mathworks.html.FileUrl;
import com.mathworks.search.SearchResults;
import com.mathworks.search.SearchSuggestions;
import java.util.LinkedHashMap;
import java.util.Map;

public class FullSuggestionJsonEntity
extends JsonEntity {
    private final String fText;
    private final Map<InformationType, SearchResults<PageSuggestion>> fPageSuggestions = new LinkedHashMap<InformationType, SearchResults<PageSuggestion>>();
    private final SearchSuggestions fWordSuggestions;
    private final DocRoot<FileUrl> fDocUrlBuilder;

    public FullSuggestionJsonEntity(String string, DocRoot<FileUrl> docRoot, Map<InformationType, SearchResults<PageSuggestion>> map, SearchSuggestions searchSuggestions) {
        this.fText = string;
        this.fDocUrlBuilder = docRoot;
        if (map != null) {
            this.fPageSuggestions.putAll(map);
        }
        this.fWordSuggestions = searchSuggestions;
    }

    @Override
    public String getJsonString() {
        return this.getJsonObject().getJsonString();
    }

    public JsonObject getJsonObject() {
        JsonObject jsonObject;
        JsonObject jsonObject2 = new JsonObject();
        jsonObject2.addStringProperty("searchText", this.fText);
        JsonObject jsonObject3 = this.getPageSuggestionsObject();
        if (!jsonObject3.isEmpty()) {
            jsonObject2.addJsonProperty("pages", jsonObject3);
        }
        if (!(jsonObject = this.getWordSuggestionObject()).isEmpty()) {
            jsonObject2.addJsonProperty("words", this.getWordSuggestionObject());
        }
        return jsonObject2;
    }

    public JsonObject getWordSuggestionObject() {
        JsonObject jsonObject = new JsonObject();
        if (this.fWordSuggestions == null || this.fWordSuggestions.getTotal() == 0) {
            return jsonObject;
        }
        int n = this.fWordSuggestions.getSuggestions().size();
        int n2 = this.fWordSuggestions.getTotal() - n;
        int n3 = n2 > 0 ? n : -1;
        jsonObject.addIntProperty("more", n2);
        jsonObject.addIntProperty("next", n3);
        jsonObject.addJsonProperty("wordlist", SuggestionUtils.createWordSuggestionArray(this.fWordSuggestions.getSuggestions()));
        return jsonObject;
    }

    public JsonObject getPageSuggestionsObject() {
        JsonObject jsonObject = new JsonObject();
        for (Map.Entry<InformationType, SearchResults<PageSuggestion>> entry : this.fPageSuggestions.entrySet()) {
            if (entry.getValue().getFullResultCount() <= 0) continue;
            String string = entry.getKey().getFacetId();
            jsonObject.addJsonProperty(string, this.getPageSuggestionsObject(entry.getKey()));
        }
        return jsonObject;
    }

    public JsonObject getPageSuggestionsObject(InformationType informationType) {
        SearchResults<PageSuggestion> searchResults = this.fPageSuggestions.get(informationType);
        int n = searchResults.getNumIncluded();
        int n2 = searchResults.getFullResultCount() - n;
        int n3 = n2 > 0 ? n : -1;
        JsonObject jsonObject = new JsonObject();
        jsonObject.addStringProperty("header", this.getHeader(informationType));
        jsonObject.addStringProperty("type", informationType.getFacetId());
        jsonObject.addIntProperty("more", n2);
        jsonObject.addIntProperty("next", n3);
        jsonObject.addJsonProperty("suggestions", SuggestionUtils.createPageSuggestionArray(this.fDocUrlBuilder, informationType, searchResults));
        return jsonObject;
    }

    public String getHeader(InformationType informationType) {
        return HelpBrowserUtils.getString(informationType.getLabelKey());
    }
}

