/*
 * Decompiled with CFR 0.152.
 */
package com.intel.bluetooth;

import com.intel.bluetooth.UtilsJavaSE;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Vector;
import javax.bluetooth.DataElement;
import javax.bluetooth.ServiceRecord;
import javax.bluetooth.UUID;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class BlueZServiceRecordXML {
    private static final Map<String, Integer> integerXMLtypes = new HashMap<String, Integer>();
    private static final Map<Integer, String> allXMLtypes = new HashMap<Integer, String>();

    BlueZServiceRecordXML() {
    }

    private static String toHexStringSigned(long l) {
        if (l >= 0L) {
            return "0x" + Long.toHexString(l);
        }
        return "-0x" + Long.toHexString(-l);
    }

    private static void appendUUID(StringBuffer buf, UUID uuid) {
        String str = uuid.toString().toUpperCase();
        int shortIdx = str.indexOf("00001000800000805F9B34FB");
        if (shortIdx != -1 && shortIdx + "00001000800000805F9B34FB".length() == str.length()) {
            buf.append("0x").append(str.substring(0, shortIdx));
        } else {
            buf.append(str.substring(0, 8)).append('-').append(str.substring(8, 12)).append('-');
            buf.append(str.substring(12, 16)).append('-').append(str.substring(16, 20)).append('-').append(str.substring(20));
        }
    }

    static void appendDataElement(StringBuffer buf, DataElement d) {
        int valueType = d.getDataType();
        String type = allXMLtypes.get(valueType);
        buf.append("<").append(type);
        switch (valueType) {
            case 8: 
            case 9: 
            case 10: {
                buf.append(" value=\"0x").append(Long.toHexString(d.getLong())).append("\">");
                break;
            }
            case 16: 
            case 17: 
            case 18: 
            case 19: {
                buf.append(" value=\"").append(BlueZServiceRecordXML.toHexStringSigned(d.getLong())).append("\">");
                break;
            }
            case 40: {
                buf.append(" value=\"").append(d.getBoolean() ? "true" : "false").append("\">");
                break;
            }
            case 32: 
            case 64: {
                buf.append(" value=\"").append(d.getValue()).append("\">");
                break;
            }
            case 24: {
                buf.append(" value=\"");
                BlueZServiceRecordXML.appendUUID(buf, (UUID)d.getValue());
                buf.append("\">");
                break;
            }
            case 11: {
                byte[] b8 = (byte[])d.getValue();
                buf.append(" value=\"0x");
                for (int i = 0; i < b8.length; ++i) {
                    buf.append(Integer.toHexString(b8[i] >> 4 & 0xF));
                    buf.append(Integer.toHexString(b8[i] & 0xF));
                }
                buf.append("\">");
                break;
            }
            case 12: 
            case 20: {
                byte[] b16 = (byte[])d.getValue();
                buf.append(" value=\"");
                for (int i = b16.length - 1; i >= 0; --i) {
                    buf.append(Integer.toHexString(b16[i] >> 4 & 0xF));
                    buf.append(Integer.toHexString(b16[i] & 0xF));
                }
                buf.append("\">");
                break;
            }
            case 48: 
            case 56: {
                buf.append(">\n");
                Enumeration en = (Enumeration)d.getValue();
                while (en.hasMoreElements()) {
                    BlueZServiceRecordXML.appendDataElement(buf, (DataElement)en.nextElement());
                }
                break;
            }
            case 0: {
                buf.append(">\n");
                break;
            }
            default: {
                throw new IllegalArgumentException("DataElement type " + valueType);
            }
        }
        buf.append("</").append(type).append(">\n");
    }

    public static String exportXMLRecord(ServiceRecord serviceRecord) {
        StringBuffer b = new StringBuffer();
        b.append("<?xml version=\"1.0\" encoding=\"UTF-8\" ?>\n");
        b.append("<record>\n");
        int[] ids = serviceRecord.getAttributeIDs();
        Vector<Integer> sorted = new Vector<Integer>();
        for (int i = 0; i < ids.length; ++i) {
            sorted.addElement(new Integer(ids[i]));
        }
        Collections.sort(sorted);
        for (Integer id : sorted) {
            b.append("<attribute id=\"0x").append(Long.toHexString(id.intValue())).append("\" >\n");
            BlueZServiceRecordXML.appendDataElement(b, serviceRecord.getAttributeValue(id.intValue()));
            b.append("</attribute>\n");
        }
        b.append("</record>");
        return b.toString();
    }

    public static Map<Integer, DataElement> parsXMLRecord(String xml) throws IOException {
        try {
            DocumentBuilder builder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            Document doc = builder.parse(new InputSource(new ByteArrayInputStream(xml.getBytes())));
            Element root = doc.getDocumentElement();
            if (!"record".equals(root.getTagName())) {
                throw new IOException("SDP xml record expected, got " + root.getTagName());
            }
            HashMap<Integer, DataElement> elements = new HashMap<Integer, DataElement>();
            NodeList nodes = root.getElementsByTagName("attribute");
            block3: for (int i = 0; i < nodes.getLength(); ++i) {
                Node node = nodes.item(i);
                Node idNode = node.getAttributes().getNamedItem("id");
                int id = BlueZServiceRecordXML.parsInt(idNode.getNodeValue());
                NodeList children = node.getChildNodes();
                for (int j = 0; children != null && j < children.getLength(); ++j) {
                    Node child = children.item(j);
                    if (child.getNodeType() != 1) continue;
                    elements.put(id, BlueZServiceRecordXML.parsDataElement(child));
                    continue block3;
                }
            }
            return elements;
        }
        catch (ParserConfigurationException e) {
            throw (IOException)UtilsJavaSE.initCause((Throwable)new IOException(e.getMessage()), (Throwable)e);
        }
        catch (SAXException e) {
            throw (IOException)UtilsJavaSE.initCause((Throwable)new IOException(e.getMessage()), (Throwable)e);
        }
    }

    private static int parsInt(String value) {
        if (value.startsWith("0x")) {
            return Integer.valueOf(value.substring(2), 16);
        }
        return Integer.valueOf(value);
    }

    private static long parsLong(String value) {
        if (value.startsWith("0x")) {
            return Long.valueOf(value.substring(2), 16);
        }
        if (value.startsWith("-0x")) {
            return -Long.valueOf(value.substring(3), 16).longValue();
        }
        return Long.valueOf(value);
    }

    private static long getLongValue(Node node) throws IOException {
        Node valueNode = node.getAttributes().getNamedItem("value");
        if (valueNode == null) {
            throw new IOException("value attribute expected in " + node.getNodeName());
        }
        return BlueZServiceRecordXML.parsLong(valueNode.getNodeValue());
    }

    private static boolean getBoolValue(Node node) throws IOException {
        Node valueNode = node.getAttributes().getNamedItem("value");
        if (valueNode == null) {
            throw new IOException("value attribute expected in " + node.getNodeName());
        }
        return "true".equals(valueNode.getNodeValue());
    }

    private static UUID getUUIDValue(Node node) throws IOException {
        Node valueNode = node.getAttributes().getNamedItem("value");
        if (valueNode == null) {
            throw new IOException("value attribute expected in " + node.getNodeName());
        }
        String value = valueNode.getNodeValue();
        if (value.length() == 32) {
            return new UUID(value.replace("-", ""), false);
        }
        if (value.startsWith("0x")) {
            return new UUID(Long.valueOf(value.substring(2), 16).longValue());
        }
        String value2 = value.replace("-", "");
        if (value2.length() == 32) {
            return new UUID(value2, false);
        }
        throw new IOException("Unknown UUID format " + value);
    }

    private static byte[] getByteArrayValue(Node node, int length) throws IOException {
        Node valueNode = node.getAttributes().getNamedItem("value");
        if (valueNode == null) {
            throw new IOException("value attribute expected in " + node.getNodeName());
        }
        String value = valueNode.getNodeValue();
        if (length != value.length() / 2) {
            throw new IOException("value attribute invalid length " + value.length());
        }
        byte[] result = new byte[length];
        for (int i = 0; i < length; ++i) {
            result[length - 1 - i] = (byte)(Integer.parseInt(value.substring(i * 2, i * 2 + 2), 16) & 0xFF);
        }
        return result;
    }

    private static byte[] getByteArrayUINT8(Node node, int length) throws IOException {
        Node valueNode = node.getAttributes().getNamedItem("value");
        if (valueNode == null) {
            throw new IOException("value attribute expected in " + node.getNodeName());
        }
        String value = valueNode.getNodeValue();
        int radix = 10;
        if (value.startsWith("0x")) {
            value = value.substring(2);
            radix = 16;
        }
        if (length != value.length() / 2) {
            throw new IOException("value attribute invalid length " + value.length());
        }
        byte[] result = new byte[length];
        for (int i = 0; i < length; ++i) {
            result[i] = (byte)(Integer.parseInt(value.substring(i * 2, i * 2 + 2), radix) & 0xFF);
        }
        return result;
    }

    private static String getTextValue(Node node) throws IOException {
        Node valueNode = node.getAttributes().getNamedItem("value");
        if (valueNode == null) {
            throw new IOException("value attribute expected in " + node.getNodeName());
        }
        Node encodingNode = node.getAttributes().getNamedItem("encoding");
        if (encodingNode == null) {
            return valueNode.getNodeValue();
        }
        if ("hex".equals(encodingNode.getNodeValue())) {
            StringBuffer b = new StringBuffer();
            String value = valueNode.getNodeValue();
            for (int i = 0; i < value.length() / 2; ++i) {
                b.append((char)Integer.parseInt(value.substring(i * 2, i * 2 + 2), 16));
            }
            return b.toString();
        }
        throw new IOException("Unknown text encoding " + encodingNode.getNodeValue());
    }

    private static DataElement parsDataElement(Node node) throws IOException {
        String name = node.getNodeName();
        Integer intValueType = integerXMLtypes.get(name);
        if (intValueType != null) {
            return new DataElement(intValueType.intValue(), BlueZServiceRecordXML.getLongValue(node));
        }
        if ("sequence".equals(name)) {
            DataElement seq = new DataElement(48);
            NodeList children = node.getChildNodes();
            for (int j = 0; children != null && j < children.getLength(); ++j) {
                Node child = children.item(j);
                if (child.getNodeType() != 1) continue;
                seq.addElement(BlueZServiceRecordXML.parsDataElement(child));
            }
            return seq;
        }
        if ("alternate".equals(name)) {
            DataElement seq = new DataElement(56);
            NodeList children = node.getChildNodes();
            for (int j = 0; children != null && j < children.getLength(); ++j) {
                Node child = children.item(j);
                if (child.getNodeType() != 1) continue;
                seq.addElement(BlueZServiceRecordXML.parsDataElement(child));
            }
            return seq;
        }
        if ("uuid".equals(name)) {
            return new DataElement(24, (Object)BlueZServiceRecordXML.getUUIDValue(node));
        }
        if ("text".equals(name)) {
            return new DataElement(32, (Object)BlueZServiceRecordXML.getTextValue(node));
        }
        if ("url".equals(name)) {
            return new DataElement(64, (Object)BlueZServiceRecordXML.getTextValue(node));
        }
        if ("nil".equals(name)) {
            return new DataElement(0);
        }
        if ("boolean".equals(name)) {
            return new DataElement(BlueZServiceRecordXML.getBoolValue(node));
        }
        if ("uint64".equals(name)) {
            return new DataElement(11, (Object)BlueZServiceRecordXML.getByteArrayUINT8(node, 8));
        }
        if ("int128".equals(name)) {
            return new DataElement(20, (Object)BlueZServiceRecordXML.getByteArrayValue(node, 16));
        }
        if ("uint128".equals(name)) {
            return new DataElement(12, (Object)BlueZServiceRecordXML.getByteArrayValue(node, 16));
        }
        throw new IOException("Unrecognized DataElement " + name);
    }

    static {
        integerXMLtypes.put("uint8", 8);
        integerXMLtypes.put("uint16", 9);
        integerXMLtypes.put("uint32", 10);
        integerXMLtypes.put("int8", 16);
        integerXMLtypes.put("int16", 17);
        integerXMLtypes.put("int32", 18);
        integerXMLtypes.put("int64", 19);
        allXMLtypes.put(8, "uint8");
        allXMLtypes.put(9, "uint16");
        allXMLtypes.put(10, "uint32");
        allXMLtypes.put(11, "uint64");
        allXMLtypes.put(12, "uint128");
        allXMLtypes.put(16, "int8");
        allXMLtypes.put(17, "int16");
        allXMLtypes.put(18, "int32");
        allXMLtypes.put(19, "int64");
        allXMLtypes.put(20, "int128");
        allXMLtypes.put(40, "boolean");
        allXMLtypes.put(24, "uuid");
        allXMLtypes.put(32, "text");
        allXMLtypes.put(64, "url");
        allXMLtypes.put(0, "nil");
        allXMLtypes.put(56, "alternate");
        allXMLtypes.put(48, "sequence");
    }
}

