/*
 * Decompiled with CFR 0.152.
 */
package sun.security.x509;

import java.io.IOException;
import sun.security.util.DerInputStream;
import sun.security.util.DerOutputStream;
import sun.security.util.DerValue;
import sun.security.util.ObjectIdentifier;
import sun.security.x509.GeneralName;

public final class AccessDescription {
    private int myhash = -1;
    private ObjectIdentifier accessMethod;
    private GeneralName accessLocation;
    public static final ObjectIdentifier Ad_OCSP_Id = ObjectIdentifier.newInternal(new int[]{1, 3, 6, 1, 5, 5, 7, 48, 1});
    public static final ObjectIdentifier Ad_CAISSUERS_Id = ObjectIdentifier.newInternal(new int[]{1, 3, 6, 1, 5, 5, 7, 48, 2});
    public static final ObjectIdentifier Ad_TIMESTAMPING_Id = ObjectIdentifier.newInternal(new int[]{1, 3, 6, 1, 5, 5, 7, 48, 3});
    public static final ObjectIdentifier Ad_CAREPOSITORY_Id = ObjectIdentifier.newInternal(new int[]{1, 3, 6, 1, 5, 5, 7, 48, 5});

    public AccessDescription(ObjectIdentifier objectIdentifier, GeneralName generalName) {
        this.accessMethod = objectIdentifier;
        this.accessLocation = generalName;
    }

    public AccessDescription(DerValue derValue) throws IOException {
        DerInputStream derInputStream = derValue.getData();
        this.accessMethod = derInputStream.getOID();
        this.accessLocation = new GeneralName(derInputStream.getDerValue());
    }

    public ObjectIdentifier getAccessMethod() {
        return this.accessMethod;
    }

    public GeneralName getAccessLocation() {
        return this.accessLocation;
    }

    public void encode(DerOutputStream derOutputStream) throws IOException {
        DerOutputStream derOutputStream2 = new DerOutputStream();
        derOutputStream2.putOID(this.accessMethod);
        this.accessLocation.encode(derOutputStream2);
        derOutputStream.write((byte)48, derOutputStream2);
    }

    public int hashCode() {
        if (this.myhash == -1) {
            this.myhash = this.accessMethod.hashCode() + this.accessLocation.hashCode();
        }
        return this.myhash;
    }

    public boolean equals(Object object) {
        if (object == null || !(object instanceof AccessDescription)) {
            return false;
        }
        AccessDescription accessDescription = (AccessDescription)object;
        if (this == accessDescription) {
            return true;
        }
        return this.accessMethod.equals(accessDescription.getAccessMethod()) && this.accessLocation.equals(accessDescription.getAccessLocation());
    }

    public String toString() {
        String string = null;
        string = this.accessMethod.equals(Ad_CAISSUERS_Id) ? "caIssuers" : (this.accessMethod.equals(Ad_CAREPOSITORY_Id) ? "caRepository" : (this.accessMethod.equals(Ad_TIMESTAMPING_Id) ? "timeStamping" : (this.accessMethod.equals(Ad_OCSP_Id) ? "ocsp" : this.accessMethod.toString())));
        return "\n   accessMethod: " + string + "\n   accessLocation: " + this.accessLocation.toString() + "\n";
    }
}

