/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.services.editordataservice;

import com.mathworks.peermodel.PeerNode;
import com.mathworks.peermodel.events.Event;
import com.mathworks.peermodel.events.Observer;
import com.mathworks.services.editordataservice.Document;
import com.mathworks.services.editordataservice.EditorFeature;
import com.mathworks.services.editordataservice.EditorNodeUtilities;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public final class EditorNode {
    private static boolean sLoggingErrors;
    private final PeerNode fNode;
    private final Document fDocument;
    private final List<EditorFeature> fActiveFeatures = new ArrayList<EditorFeature>();
    private final Map<String, List<String>> fFeaturesLibrary;
    private static final String INTERNAL_REQUEST_ID = "internalRequestId";

    public EditorNode(PeerNode peerNode, Map<String, List<String>> map) {
        this.fNode = peerNode;
        this.fFeaturesLibrary = map;
        this.fDocument = new Document(EditorNodeUtilities.getUniqueIdFromNode(peerNode));
        this.addDocumentChangedListener();
        this.addFeatureRegisterListener();
    }

    void registerRequestFeatureHandler(final String string, final EditorFeature.FeatureResponse featureResponse) {
        this.fNode.addPeerEventListener(string, new Observer(){

            public void handle(Event event) {
                String string3 = string + ".RESPONSE";
                try {
                    String string2 = this.getInternalRequestIdFromMessage(event);
                    Map<String, Object> map = this.getRequestDataFromMessage(event);
                    Map<String, Object> map2 = featureResponse.handle(map);
                    map2.put(EditorNode.INTERNAL_REQUEST_ID, string2);
                    EditorNode.this.fNode.dispatchPeerEvent(string3, EditorNode.this.fNode, map2);
                }
                catch (Exception exception) {
                    HashMap<String, String> hashMap = new HashMap<String, String>();
                    hashMap.put("error", exception.toString());
                    EditorNode.this.fNode.dispatchPeerEvent(string3, EditorNode.this.fNode, hashMap);
                }
            }

            private String getInternalRequestIdFromMessage(Event event) {
                return (String)event.getData().get(EditorNode.INTERNAL_REQUEST_ID);
            }

            private Map<String, Object> getRequestDataFromMessage(Event event) {
                return (Map)event.getData().get("requestData");
            }
        });
    }

    private void addFeatureRegisterListener() {
        this.fNode.addPeerEventListener("registerFeature", new Observer(){

            public void handle(Event event) {
                if (EditorNodeUtilities.isFeatureRegisterEvent(event) && !EditorNode.this.hasFeature(EditorNodeUtilities.getFeatureIdFromEvent(event))) {
                    EditorNode.this.attachFeature(EditorNodeUtilities.getFeatureIdFromEvent(event));
                }
            }
        });
    }

    private void addDocumentChangedListener() {
        this.fNode.addPeerEventListener("documentChanged", new Observer(){

            public void handle(Event event) {
                if (EditorNodeUtilities.isDocumentChanged(event)) {
                    EditorNode.this.updateText(EditorNodeUtilities.getDocumentTextFromEvent(event));
                }
            }
        });
    }

    private void attachFeature(String string) {
        block2: for (String string2 : this.fFeaturesLibrary.keySet()) {
            List<String> list;
            if (!string2.equals(string) || (list = this.fFeaturesLibrary.get(string)) == null) continue;
            for (String string3 : list) {
                try {
                    EditorFeature editorFeature = EditorNodeUtilities.constructEditorFeatureInstance(this, string3);
                    if (editorFeature == null) continue;
                    this.addFeature(editorFeature);
                    continue block2;
                }
                catch (Exception exception) {
                    if (!EditorNode.shouldLogAddFeatureError()) continue;
                    exception.printStackTrace();
                }
            }
        }
    }

    private static boolean shouldLogAddFeatureError() {
        return sLoggingErrors;
    }

    public static void setAddFeatureExceptionLogging(boolean bl) {
        sLoggingErrors = bl;
    }

    void updateFeatureData(String string, Map map) {
        this.fNode.setProperty(string, (Object)map);
    }

    private boolean hasFeature(String string) {
        boolean bl = false;
        for (EditorFeature editorFeature : this.fActiveFeatures) {
            if (!string.equals(editorFeature.getFeatureId())) continue;
            bl = true;
            break;
        }
        return bl;
    }

    private void addFeature(EditorFeature editorFeature) {
        this.fActiveFeatures.add(editorFeature);
        editorFeature.documentChanged(this.fDocument);
    }

    private synchronized void updateText(String string) {
        this.fDocument.replaceText(string);
        for (EditorFeature editorFeature : this.fActiveFeatures) {
            try {
                editorFeature.documentChanged(this.fDocument);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    public void dispose() {
        for (EditorFeature editorFeature : this.fActiveFeatures) {
            editorFeature.dispose();
        }
    }
}

