/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.services.lmgr;

import com.mathworks.services.lmgr.ExitMatlabRunnable;
import com.mathworks.services.lmgr.HBManager;
import com.mathworks.services.lmgr.HBThread;
import com.mathworks.services.lmgr.HeartbeatListener;
import com.mathworks.services.lmgr.InternalHeartbeatListener;
import com.mathworks.services.lmgr.LmgrHBActions;
import com.mathworks.services.lmgr.MathWorksLicenseServerClientFactory;
import com.mathworks.services.lmgr.events.HeartbeatEvent;
import com.mathworks.services.lmgr.events.HeartbeatFailedEvent;
import com.mathworks.webservices.mls.MathWorksLicenseServerClient;
import com.mathworks.webservices.mls.model.HeartbeatStatus;
import com.mathworks.webservices.mls.model.SessionHeartbeatResponse;
import java.util.ArrayList;
import java.util.Collection;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;

public final class HBManagerImpl
implements HBManager {
    private static final long DEFAULT_HB_INTERVAL_IN_MINS = 6L;
    private static final long TIME_TO_WAIT_FOR_HEARTBEAT_LISTENERS_IN_SECS = 5L;
    private static HBManagerImpl sInstance = null;
    private final ScheduledExecutorService fExecutorService;
    private final MathWorksLicenseServerClient webClient;
    private final MyHeartbeatListener myHeartbeatListener;
    private final LmgrHBActions nativeMethodProvider;
    private String sessionID = null;

    private static native void nativeHBReceived();

    private static native int nativeHBMissed();

    private static native void nativeSetHBIntervalMins(int var0);

    private static native void nativeSetMaxMissedHB(int var0);

    private HBManagerImpl(MathWorksLicenseServerClient mathWorksLicenseServerClient, ScheduledExecutorService scheduledExecutorService, Runnable runnable, LmgrHBActions lmgrHBActions) {
        this.webClient = mathWorksLicenseServerClient;
        this.fExecutorService = scheduledExecutorService;
        this.myHeartbeatListener = new MyHeartbeatListener(runnable);
        this.nativeMethodProvider = lmgrHBActions;
    }

    public static synchronized HBManagerImpl getInstance() {
        if (sInstance == null) {
            sInstance = new HBManagerImpl(MathWorksLicenseServerClientFactory.createClient(), Executors.newSingleThreadScheduledExecutor(), new ExitMatlabRunnable(), new NativeHBActions());
        }
        return sInstance;
    }

    public static HBManagerImpl createTestInstance(MathWorksLicenseServerClient mathWorksLicenseServerClient, ScheduledExecutorService scheduledExecutorService, Runnable runnable, LmgrHBActions lmgrHBActions) {
        return new HBManagerImpl(mathWorksLicenseServerClient, scheduledExecutorService, runnable, lmgrHBActions);
    }

    @Override
    public synchronized void startHBThread(String string, int n) {
        if (this.sessionID != null) {
            throw new IllegalStateException("startHBThread can only be called once.");
        }
        if (this.fExecutorService.isShutdown()) {
            throw new IllegalStateException("startHBThread cannot be called after killHBThread.");
        }
        this.sessionID = string;
        this.scheduleHBThread(n);
    }

    private HBThread createHeartbeatThread() {
        return new HBThread(this.myHeartbeatListener, this.sessionID, this.webClient);
    }

    private synchronized void scheduleHBThread(long l) {
        HBThread hBThread = this.createHeartbeatThread();
        this.fExecutorService.schedule(hBThread, l, TimeUnit.MINUTES);
    }

    @Override
    public synchronized void killHBThread() {
        this.myHeartbeatListener.shutdownListenerService();
        this.fExecutorService.shutdownNow();
    }

    @Override
    public synchronized void addHeartbeatListener(HeartbeatListener heartbeatListener) {
        this.myHeartbeatListener.addHeartbeatListener(heartbeatListener);
    }

    @Override
    public synchronized void removeHeartbeatListener(HeartbeatListener heartbeatListener) {
        this.myHeartbeatListener.removeHeartbeatListener(heartbeatListener);
    }

    private static class NativeHBActions
    implements LmgrHBActions {
        NativeHBActions() {
            try {
                System.loadLibrary("nativelmgr");
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }

        @Override
        public void hbAcknowledged() {
            try {
                HBManagerImpl.nativeHBReceived();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }

        @Override
        public int hbMissed() {
            int n = 0;
            try {
                n = HBManagerImpl.nativeHBMissed();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            return n;
        }

        @Override
        public void setHeartBeatIntervalInMin(int n) {
            try {
                HBManagerImpl.nativeSetHBIntervalMins(n);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }

        @Override
        public void setMaxMissedHB(int n) {
            try {
                HBManagerImpl.nativeSetMaxMissedHB(n);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    private final class MyHeartbeatListener
    implements InternalHeartbeatListener {
        private static final String SHUTDOWN = "SHUTDOWN";
        private static final int MISSEDHB_SHOULD_KILL = -1;
        private final Collection<HeartbeatListener> heartbeatListeners = new ArrayList<HeartbeatListener>();
        private final Runnable exitMatlabRunnable;
        private long hbIntervalInMins = 6L;
        private final ExecutorService executorService;

        MyHeartbeatListener(Runnable runnable) {
            this.exitMatlabRunnable = runnable;
            this.executorService = Executors.newSingleThreadExecutor();
        }

        @Override
        public void heartbeatAcknowledged(SessionHeartbeatResponse sessionHeartbeatResponse) {
            HeartbeatStatus heartbeatStatus = sessionHeartbeatResponse.getStatus();
            String string = heartbeatStatus.getCode();
            HBManagerImpl.this.nativeMethodProvider.hbAcknowledged();
            this.sendEventToListeners(new HeartbeatEvent("Heartbeat acknowledged: " + heartbeatStatus.getMessage()));
            if (SHUTDOWN.equalsIgnoreCase(string)) {
                this.exit(new HeartbeatFailedEvent("Online license server error caused MATLAB worker to shut down. " + heartbeatStatus.getMessage()));
            } else {
                int n = sessionHeartbeatResponse.getHeartBeatInterval();
                this.hbIntervalInMins = n;
                HBManagerImpl.this.nativeMethodProvider.setHeartBeatIntervalInMin(n);
                int n2 = sessionHeartbeatResponse.getMaxMissedHeartbeats();
                HBManagerImpl.this.nativeMethodProvider.setMaxMissedHB(n2);
                HBManagerImpl.this.scheduleHBThread(this.hbIntervalInMins);
            }
        }

        private void sendEventToListeners(final HeartbeatEvent heartbeatEvent) {
            ArrayList<1> arrayList = new ArrayList<1>();
            for (final HeartbeatListener heartbeatListener : this.heartbeatListeners) {
                arrayList.add(new Callable<Object>(){

                    @Override
                    public Object call() throws Exception {
                        heartbeatListener.heartbeatEvent(heartbeatEvent);
                        return null;
                    }
                });
            }
            try {
                this.executorService.invokeAll(arrayList, 5L, TimeUnit.SECONDS);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }

        @Override
        public void heartbeatMissed(Throwable throwable) {
            int n = HBManagerImpl.this.nativeMethodProvider.hbMissed();
            this.sendEventToListeners(new HeartbeatEvent("Heartbeat missed: " + throwable.getMessage()));
            if (n == -1) {
                this.exit(new HeartbeatFailedEvent("MATLAB worker lost its connection to the online license server."));
            } else {
                HBManagerImpl.this.scheduleHBThread(this.hbIntervalInMins);
            }
        }

        void addHeartbeatListener(HeartbeatListener heartbeatListener) {
            this.heartbeatListeners.add(heartbeatListener);
        }

        void exit(final HeartbeatFailedEvent heartbeatFailedEvent) {
            ArrayList<2> arrayList = new ArrayList<2>();
            for (final HeartbeatListener heartbeatListener : this.heartbeatListeners) {
                arrayList.add(new Callable<Object>(){

                    @Override
                    public Object call() throws Exception {
                        heartbeatListener.heartbeatFailed(heartbeatFailedEvent);
                        return null;
                    }
                });
            }
            try {
                this.executorService.invokeAll(arrayList, 5L, TimeUnit.SECONDS);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            HBManagerImpl.this.killHBThread();
            this.exitMatlabRunnable.run();
        }

        public void shutdownListenerService() {
            this.executorService.shutdownNow();
        }

        public void removeHeartbeatListener(HeartbeatListener heartbeatListener) {
            this.heartbeatListeners.remove(heartbeatListener);
        }
    }
}

