/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.shared.controllib.desktop;

import com.mathworks.jmi.Callback;
import com.mathworks.mlservices.MatlabDesktopServices;
import com.mathworks.mlwidgets.actionbrowser.TearOffCloser;
import com.mathworks.mlwidgets.actionbrowser.TearOffDialog;
import com.mathworks.mwswing.MJPanel;
import com.mathworks.mwswing.WindowUtils;
import com.mathworks.widgets.desk.DTClientEvent;
import com.mathworks.widgets.desk.DTClientListener;
import java.awt.Frame;
import java.awt.Point;
import java.awt.Window;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.SwingUtilities;

public class TearOffDialogWrapper {
    private Dialog fDialog = null;
    private TearOffCloser fDialogCloser = new DialogCloser();
    private final Callback fCloseEventCallback = new Callback();

    public TearOffDialogWrapper() {
        this(TearOffDialogWrapper.getDefaultHostWindow(), (JComponent)new MJPanel(), (JComponent)new MJPanel());
    }

    public TearOffDialogWrapper(JComponent jComponent) {
        this(TearOffDialogWrapper.getDefaultHostWindow(), jComponent, (JComponent)new MJPanel());
    }

    public TearOffDialogWrapper(JComponent jComponent, JComponent jComponent2) {
        this(TearOffDialogWrapper.getDefaultHostWindow(), jComponent, jComponent2);
    }

    public TearOffDialogWrapper(Window window, JComponent jComponent, JComponent jComponent2) {
        this.fDialog = window instanceof Frame ? new Dialog((Frame)window, jComponent, jComponent2) : new Dialog((Dialog)((Object)window), jComponent, jComponent2);
        this.fDialog.setCloser(this.fDialogCloser);
        this.addCloseEventListener();
    }

    public TearOffDialog getWrappedComponent() {
        return this.fDialog;
    }

    public static Window getDefaultHostWindow() {
        Window[] windowArray;
        for (Window window : windowArray = Window.getWindows()) {
            if (!window.isActive() || !(window instanceof TearOffDialog)) continue;
            return window;
        }
        return TearOffDialog.getDefaultHostFrame();
    }

    public String getName() {
        return this.fDialog.getName();
    }

    public void setName(String string) {
        this.fDialog.setName(string);
    }

    public String getTitle() {
        return this.fDialog.getTitle();
    }

    public void setTitle(String string) {
        this.fDialog.setTitle(string);
    }

    public boolean isEnabled() {
        return this.fDialog.isEnabled();
    }

    public void setEnabled(boolean bl) {
        this.fDialog.setEnabled(bl);
    }

    public void open() {
        this.fDialog.open();
    }

    public void close() {
        this.fDialog.close();
    }

    public boolean isVisible() {
        return this.fDialog.isVisible();
    }

    public boolean isFloating() {
        return this.fDialog.isFloating();
    }

    public void setFloating(boolean bl) {
        if (bl) {
            this.fDialog.makeFloating();
        } else {
            this.fDialog.makeTransient();
        }
    }

    public void setContentPanel(JComponent jComponent) {
        this.fDialog.setContentPanel(jComponent);
    }

    public void setScopePanel(JComponent jComponent) {
        this.fDialog.setScopePanel(jComponent);
    }

    public Callback getCloseEventCallback() {
        return this.fCloseEventCallback;
    }

    public static void showPopup(JComponent jComponent, TearOffDialog tearOffDialog, String string) {
        Point point = new Point();
        SwingUtilities.convertPointToScreen(point, jComponent);
        if (string.equalsIgnoreCase("NORTH")) {
            point.y -= tearOffDialog.getSize().height;
        } else if (string.equalsIgnoreCase("WEST")) {
            point.x -= tearOffDialog.getSize().width;
        } else if (string.equalsIgnoreCase("EAST")) {
            point.x += jComponent.getVisibleRect().width;
        } else {
            point.y += jComponent.getVisibleRect().height;
        }
        tearOffDialog.setLocation(point);
        WindowUtils.ensureOnScreen((Window)tearOffDialog);
        tearOffDialog.open();
    }

    private void addCloseEventListener() {
        this.fDialog.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentHidden(ComponentEvent componentEvent) {
                TearOffDialogWrapper.this.fCloseEventCallback.postCallback();
            }
        });
    }

    private static class DialogCloser
    extends WindowAdapter
    implements DTClientListener,
    TearOffCloser {
        private TearOffDialog fTearOff = null;

        private DialogCloser() {
        }

        public void install(TearOffDialog tearOffDialog) {
            if (this.fTearOff == null) {
                this.fTearOff = tearOffDialog;
                MatlabDesktopServices.getDesktop().addClientListener((DTClientListener)this);
                tearOffDialog.addWindowListener((WindowListener)this);
            }
        }

        public void uninstall(TearOffDialog tearOffDialog) {
            if (this.fTearOff != null) {
                MatlabDesktopServices.getDesktop().removeClientListener((DTClientListener)this);
                tearOffDialog.removeWindowListener((WindowListener)this);
                this.fTearOff = null;
            }
        }

        public void clientActivating(DTClientEvent dTClientEvent) {
        }

        public void clientClosed(DTClientEvent dTClientEvent) {
        }

        public void clientClosing(DTClientEvent dTClientEvent) {
        }

        public void clientDeactivated(DTClientEvent dTClientEvent) {
        }

        public void clientDocked(DTClientEvent dTClientEvent) {
        }

        public void clientDocking(DTClientEvent dTClientEvent) {
        }

        public void clientOpened(DTClientEvent dTClientEvent) {
        }

        public void clientRelocated(DTClientEvent dTClientEvent) {
        }

        public void clientUndocked(DTClientEvent dTClientEvent) {
        }

        public void clientUndocking(DTClientEvent dTClientEvent) {
        }

        public void clientActivated(DTClientEvent dTClientEvent) {
            this.closeTearOff();
        }

        public void clientResized(DTClientEvent dTClientEvent) {
            this.closeTearOff();
        }

        @Override
        public void windowActivated(WindowEvent windowEvent) {
        }

        @Override
        public void windowDeactivated(WindowEvent windowEvent) {
            Window window = windowEvent.getOppositeWindow();
            if (window == null || window instanceof TearOffDialog || window instanceof JDialog || !window.isVisible() || window.isShowing()) {
                // empty if block
            }
        }

        private void closeTearOff() {
            if (this.fTearOff != null && !this.fTearOff.isFloating() && this.fTearOff.isVisible()) {
                this.fTearOff.close();
            }
        }
    }

    public class Dialog
    extends TearOffDialog {
        private static final long serialVersionUID = 1L;

        public Dialog(Frame frame, JComponent jComponent, JComponent jComponent2) {
            super(frame, jComponent, jComponent2);
        }

        public Dialog(Dialog dialog, JComponent jComponent, JComponent jComponent2) {
            super((java.awt.Dialog)((Object)dialog), jComponent, jComponent2);
        }

        public void dispose() {
        }

        public void cleanup() {
            super.dispose();
        }
    }
}

