/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.peermodel.impl;

import com.mathworks.peermodel.PeerModelManager;
import com.mathworks.peermodel.PeerModelManagerSyncable;
import com.mathworks.peermodel.PeerNode;
import com.mathworks.peermodel.PeerNodeVisitor;
import com.mathworks.peermodel.events.Event;
import com.mathworks.peermodel.events.Observer;
import com.mathworks.peermodel.events.PeerModelListener;
import com.mathworks.peermodel.impl.EventImpl;
import com.mathworks.peermodel.impl.ObservableImpl;
import com.mathworks.peermodel.impl.PeerNodeImpl;
import com.mathworks.peermodel.impl.RootPeerNodeImpl;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

public class PeerModelManagerImpl
implements PeerModelManagerSyncable {
    private static final int NO_INDEX = Integer.MAX_VALUE;
    private RootPeerNodeImpl root = null;
    volatile boolean syncEnabled = false;
    private final ObservableImpl observable = new ObservableImpl();

    public synchronized PeerNode setRoot(String type) {
        return this.setRoot(type, null);
    }

    public synchronized PeerNode setRoot(String type, Object originator) {
        return this.setRoot(type, null, null);
    }

    public synchronized PeerNode setRoot(String type, Map<String, Object> properties) {
        return this.setRoot(null, type, properties, null);
    }

    public synchronized PeerNode setRoot(String type, Map<String, Object> properties, Object originator) {
        return this.setRoot(null, type, properties, originator);
    }

    public PeerNode setRoot(String id, String type, Map<String, Object> properties, Object originator) {
        if (this.root != null) {
            throw new UnsupportedOperationException("Root property has already been set.Please use destroy() to destroy the node.");
        }
        this.root = new RootPeerNodeImpl(id, type, properties);
        this.root.setManager(this);
        this.dispatchRootSetEvent((PeerNode)this.root, originator);
        return this.root;
    }

    private void dispatchRootSetEvent(PeerNode root, Object originator) {
        this.dispatchEvent("rootSet", originator, root, new HashMap<String, Object>());
    }

    public synchronized boolean hasRoot() {
        return this.root != null;
    }

    public PeerNode getRoot() {
        return this.root;
    }

    public synchronized void move(PeerNode nodeToMove, PeerNode newParent) {
        this.move(nodeToMove, newParent, Integer.MAX_VALUE, null);
    }

    public synchronized void move(PeerNode nodeToMove, PeerNode newParent, Object originator) {
        this.move(nodeToMove, newParent, Integer.MAX_VALUE, originator);
    }

    public synchronized void move(PeerNode nodeToMove, PeerNode newParent, int index) {
        this.move(nodeToMove, newParent, index, null);
    }

    public synchronized void move(PeerNode nodeToMove, PeerNode newParent, int index, Object originator) {
        if (!this.checkSameNamespace(nodeToMove, newParent)) {
            throw new UnsupportedOperationException("Cannot move between namespaces");
        }
        if (newParent == nodeToMove || nodeToMove.hasDescendant(newParent.getId())) {
            throw new IllegalArgumentException("Cannot move a node to be a child or descendant of itself");
        }
        PeerNode oldParent = nodeToMove.getParent();
        int oldIndex = oldParent.getChildIndex(nodeToMove);
        int newIndex = nodeToMove.getParent() == newParent ? Math.max(0, Math.min(index, newParent.getNumberOfChildren() - 1)) : Math.max(0, Math.min(index, newParent.getNumberOfChildren()));
        this.dispatchChildMovingEvent(nodeToMove, oldParent, newParent, oldIndex, newIndex, originator);
        ((PeerNodeImpl)oldParent).removeChild(nodeToMove);
        ((PeerNodeImpl)newParent).addChildNoEvent(nodeToMove, index);
        this.dispatchChildMovedEvent(nodeToMove, oldParent, newParent, oldIndex, newIndex, originator);
    }

    private void dispatchChildMovingEvent(PeerNode node, PeerNode oldParent, PeerNode newParent, int oldIndex, int newIndex, Object originator) {
        HashMap<String, Object> data = new HashMap<String, Object>();
        data.put("oldParent", oldParent);
        data.put("newParent", newParent);
        data.put("oldIndex", oldIndex);
        data.put("newIndex", newIndex);
        this.dispatchEvent("childMoving", originator, node, data);
    }

    private void dispatchChildMovedEvent(PeerNode node, PeerNode oldParent, PeerNode newParent, int oldIndex, int newIndex, Object originator) {
        HashMap<String, Object> data = new HashMap<String, Object>();
        data.put("oldParent", oldParent);
        data.put("newParent", newParent);
        data.put("oldIndex", oldIndex);
        data.put("newIndex", newIndex);
        this.dispatchEvent("childMoved", originator, node, data);
    }

    private boolean checkSameNamespace(PeerNode node1, PeerNode node2) {
        PeerNode root2;
        PeerNode root1 = ((PeerNodeImpl)node1).getRoot();
        return root1 == (root2 = ((PeerNodeImpl)node2).getRoot());
    }

    public synchronized void setSyncEnabled(boolean enabled) {
        this.setSyncEnabled(enabled, null);
    }

    public synchronized void setSyncEnabled(boolean enabled, Object originator) {
        if (this.syncEnabled != enabled) {
            this.syncEnabled = enabled;
            HashMap<String, Object> data = new HashMap<String, Object>();
            data.put("syncEnabled", this.syncEnabled);
            this.dispatchEvent(new EventImpl("syncChanged", originator, (PeerModelManager)this, data));
        }
    }

    public boolean isSyncEnabled() {
        return this.syncEnabled;
    }

    public boolean hasById(String id) {
        return this.hasRoot() && (this.root.getId().equals(id) || this.root.hasDescendant(id));
    }

    public PeerNode getById(String id) {
        if (this.hasRoot()) {
            if (this.root.getId().equals(id)) {
                return this.root;
            }
            return this.root.getDescendant(id);
        }
        throw new IllegalArgumentException("No root node exists");
    }

    public synchronized Collection<PeerNode> getByType(final String type) {
        final ArrayList<PeerNode> nodes = new ArrayList<PeerNode>();
        if (this.hasRoot()) {
            this.getRoot().accept(new PeerNodeVisitor(){

                public void visit(PeerNode node) {
                    if (node.getType().equals(type)) {
                        nodes.add(node);
                    }
                }
            });
        }
        return nodes;
    }

    public Collection<PeerNode> getByType(PeerNode node, final String type) {
        final ArrayList<PeerNode> nodes = new ArrayList<PeerNode>();
        node.accept(new PeerNodeVisitor(){

            public void visit(PeerNode node) {
                if (node.getType().equals(type)) {
                    nodes.add(node);
                }
            }
        });
        return nodes;
    }

    public Collection<PeerNode> getByProperty(final String key, final Object value) {
        final ArrayList<PeerNode> nodes = new ArrayList<PeerNode>();
        if (this.hasRoot()) {
            this.getRoot().accept(new PeerNodeVisitor(){

                public void visit(PeerNode node) {
                    if (node.hasProperty(key) && node.getProperty(key).equals(value)) {
                        nodes.add(node);
                    }
                }
            });
        }
        return nodes;
    }

    public Collection<PeerNode> getByProperty(PeerNode node, final String key, final Object value) {
        final ArrayList<PeerNode> nodes = new ArrayList<PeerNode>();
        node.accept(new PeerNodeVisitor(){

            public void visit(PeerNode node) {
                if (node.hasProperty(key) && node.getProperty(key).equals(value)) {
                    nodes.add(node);
                }
            }
        });
        return nodes;
    }

    public void addPeerModelListener(PeerModelListener listener) {
        this.observable.addPeerModelListener(listener);
    }

    public void removePeerModelListener(PeerModelListener listener) {
        this.observable.removePeerModelListener(listener);
    }

    public void addEventListener(String type, Observer observer) {
        this.observable.addEventListener(type, observer);
    }

    public void addSyncEventListener(String type, Observer observer) {
        this.observable.addSyncEventListener(type, observer);
    }

    public void removeEventListener(String type, Observer observer) {
        this.observable.removeEventListener(type, observer);
    }

    public void removeSyncEventListener(String type, Observer observer) {
        this.observable.removeSyncEventListener(type, observer);
    }

    public boolean hasEventListener(String type, Observer observer) {
        return this.observable.hasEventListener(type, observer);
    }

    public void dispatchEvent(String type, PeerNode target, Map<String, Object> data) {
        this.observable.dispatchEvent(type, target, data);
    }

    public void dispatchEvent(String type, Object originator, PeerNode target, Map<String, Object> data) {
        this.observable.dispatchEvent(type, originator, target, data);
    }

    public void dispatchEvent(Event event) {
        this.observable.dispatchEvent(event);
    }

    public void addPeerEventListener(String type, Observer observer) {
        this.observable.addPeerEventListener(type, observer);
    }

    public void removePeerEventListener(String type, Observer observer) {
        this.observable.removePeerEventListener(type, observer);
    }

    public boolean hasPeerEventListener(String type, Observer observer) {
        return this.observable.hasPeerEventListener(type, observer);
    }

    public void dispatchPeerEvent(String type, PeerNode target, Map<String, Object> data) {
        this.observable.dispatchPeerEvent(type, target, data);
    }

    public void dispatchPeerEvent(String type, Object originator, PeerNode target, Map<String, Object> data) {
        this.observable.dispatchPeerEvent(type, originator, target, data);
    }

    synchronized void unsetRoot() {
        this.root = null;
    }
}

