/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.instrument;

import com.mathworks.jmi.types.MLArrayRef;
import com.mathworks.toolbox.instrument.Instrument;
import com.mathworks.toolbox.testmeas.util.TMException;

public final class ASCIITableConverter {
    public static final int NUL = 0;
    public static final int SOH = 1;
    public static final int STX = 2;
    public static final int ETX = 3;
    public static final int EOT = 4;
    public static final int ENQ = 5;
    public static final int ACK = 6;
    public static final int BEL = 7;
    public static final int BS = 8;
    public static final int HT = 9;
    public static final int LF = 10;
    public static final int VT = 11;
    public static final int FF = 12;
    public static final int CR = 13;
    public static final int SO = 14;
    public static final int SI = 15;
    public static final int DLE = 16;
    public static final int DC1 = 17;
    public static final int DC2 = 18;
    public static final int DC3 = 19;
    public static final int DC4 = 20;
    public static final int NAK = 21;
    public static final int SYN = 22;
    public static final int ETB = 23;
    public static final int CAN = 24;
    public static final int EM = 25;
    public static final int SUB = 26;
    public static final int ESC = 27;
    public static final int FS = 28;
    public static final int GS = 29;
    public static final int RS = 30;
    public static final int US = 31;
    public static final int DEL = 127;
    public static final int CRLF = 256;
    public static final int LFCR = 257;
    private static boolean isCRLF = false;
    private static final String CELL_ERROR = "The Terminator cell array must be a 1-by-2 array. The first element is the read" + Instrument.LINESEP + "terminator and the second element is the write terminator.";
    private static final String TERM_ERROR = "Terminator must be an integer between 0 and 127, the ASCII equivalent, 'CR/LF' or 'LF/CR'.";
    private static final String TERM_VISA_ERROR = "Terminator must be an integer between 0 and 127 or the ASCII equivalent.";
    private static final String EOS_ERROR = "EOSCharCode must be an integer between 0 and 255 or the ASCII equivalent.";

    public static final int[] convertTerminatorObjectToInt(MLArrayRef mLArrayRef, boolean bl) throws TMException {
        int[] nArray = new int[2];
        if (mLArrayRef.getType() == 1) {
            if (mLArrayRef.getM() != 1) {
                throw new TMException(CELL_ERROR);
            }
            if (mLArrayRef.getN() != 2) {
                throw new TMException(CELL_ERROR);
            }
            Object[] objectArray = (Object[])mLArrayRef.getData();
            nArray[0] = ASCIITableConverter.getTerminatorInt(objectArray[0], bl);
            nArray[1] = ASCIITableConverter.getTerminatorInt(objectArray[1], bl);
        } else if (mLArrayRef.getType() == 4) {
            nArray[0] = ASCIITableConverter.getTerminatorInt(mLArrayRef.getData(), bl);
            nArray[1] = nArray[0];
        } else if (mLArrayRef.getType() == 6) {
            nArray[0] = ASCIITableConverter.getTerminatorInt(mLArrayRef.getData(), bl);
            nArray[1] = nArray[0];
        } else {
            ASCIITableConverter.throwTerminatorException(bl);
        }
        return nArray;
    }

    private static final void throwTerminatorException(boolean bl) throws TMException {
        if (bl) {
            throw new TMException(TERM_ERROR);
        }
        throw new TMException(TERM_VISA_ERROR);
    }

    protected static final int getTerminatorInt(Object object, boolean bl) throws TMException {
        double[] dArray;
        if (object == null || object.equals("")) {
            return -1;
        }
        if (object instanceof double[] && (dArray = (double[])object).length == 0) {
            return -1;
        }
        int n = ASCIITableConverter.convertObjectToInt(object, bl);
        if (!ASCIITableConverter.verifySetRange(n, 0, 127) && !isCRLF) {
            ASCIITableConverter.throwTerminatorException(bl);
        }
        return n;
    }

    public static final int convertEOSObjectToInt(Object object) throws TMException {
        if (object != null && object.toString().equals("NaN")) {
            throw new TMException(EOS_ERROR);
        }
        int n = 0;
        try {
            n = ASCIITableConverter.convertObjectToInt(object, false);
        }
        catch (TMException tMException) {
            throw new TMException(EOS_ERROR);
        }
        if (!ASCIITableConverter.verifySetRange(n, 0, 255)) {
            throw new TMException(EOS_ERROR);
        }
        return n;
    }

    private static final int convertObjectToInt(Object object, boolean bl) throws TMException {
        int n = -1;
        isCRLF = false;
        if (object instanceof String) {
            n = ASCIITableConverter.convertStringToInt((String)object, bl);
        } else if (object instanceof Integer) {
            n = (Integer)object;
        } else if (object instanceof Character) {
            n = ((Character)object).charValue();
        } else if (object instanceof Double) {
            double d = (Double)object;
            if (d != (double)(n = ((Double)object).intValue())) {
                throw new TMException("Value must be an integer value.");
            }
        } else if (object instanceof double[]) {
            double[] dArray = (double[])object;
            if (dArray.length != 1) {
                ASCIITableConverter.throwTerminatorException(bl);
            } else if (new Double(dArray[0]).toString().equals("NaN")) {
                ASCIITableConverter.throwTerminatorException(bl);
            } else {
                if (dArray[0] != (double)((int)dArray[0])) {
                    ASCIITableConverter.throwTerminatorException(bl);
                }
                n = (int)dArray[0];
            }
        }
        return n;
    }

    public static final int convertStringToInt(String string, boolean bl) {
        String string2 = string;
        string = string.toUpperCase();
        if (bl) {
            if (string.equals("CR/LF")) {
                isCRLF = true;
                return 256;
            }
            if (string.equals("LF/CR")) {
                isCRLF = true;
                return 257;
            }
        }
        if (string.length() == 1) {
            return string2.charAt(0);
        }
        if (string.equals("NUL")) {
            return 0;
        }
        if (string.equals("SOH")) {
            return 1;
        }
        if (string.equals("STX")) {
            return 2;
        }
        if (string.equals("ETX")) {
            return 3;
        }
        if (string.equals("EOT")) {
            return 4;
        }
        if (string.equals("ENQ")) {
            return 5;
        }
        if (string.equals("ACK")) {
            return 6;
        }
        if (string.equals("BEL")) {
            return 7;
        }
        if (string.equals("BS")) {
            return 8;
        }
        if (string.equals("HT")) {
            return 9;
        }
        if (string.equals("LF")) {
            return 10;
        }
        if (string.equals("VT")) {
            return 11;
        }
        if (string.equals("FF")) {
            return 12;
        }
        if (string.equals("CR")) {
            return 13;
        }
        if (string.equals("SO")) {
            return 14;
        }
        if (string.equals("SI")) {
            return 15;
        }
        if (string.equals("DLE")) {
            return 16;
        }
        if (string.equals("DC1")) {
            return 17;
        }
        if (string.equals("DC2")) {
            return 18;
        }
        if (string.equals("DC3")) {
            return 19;
        }
        if (string.equals("DC4")) {
            return 20;
        }
        if (string.equals("NAK")) {
            return 21;
        }
        if (string.equals("SYN")) {
            return 22;
        }
        if (string.equals("ETB")) {
            return 23;
        }
        if (string.equals("CAN")) {
            return 24;
        }
        if (string.equals("EM")) {
            return 25;
        }
        if (string.equals("SUB")) {
            return 26;
        }
        if (string.equals("ESC")) {
            return 27;
        }
        if (string.equals("FS")) {
            return 28;
        }
        if (string.equals("GS")) {
            return 29;
        }
        if (string.equals("RS")) {
            return 30;
        }
        if (string.equals("US")) {
            return 31;
        }
        if (string.equals("DEL")) {
            return 127;
        }
        return -1;
    }

    protected static final boolean verifySetRange(int n, int n2, int n3) {
        return n <= n3 && n >= n2;
    }
}

