/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.instrument;

import com.mathworks.toolbox.instrument.NetworkDataLink;
import com.mathworks.toolbox.testmeas.util.TMException;
import com.mathworks.util.event.GlobalEventListener;
import com.mathworks.util.event.GlobalEventManager;
import java.net.DatagramPacket;
import java.net.DatagramSocket;

public class EchoUDP
extends Thread {
    public static EchoUDP echoUDP = null;
    private static final int DEFAULT_PORT = 9090;
    private static final int MAX_READ_SIZE = 65535;
    private DatagramSocket socketUDP = null;
    private int portNumber = 9090;
    private boolean serverRunning = true;
    private byte[] readBuffer = null;
    private DatagramPacket udpPacket = null;
    private static boolean isMatlabExiting;

    public EchoUDP() throws TMException {
        this(9090);
    }

    public EchoUDP(int n) throws TMException {
        try {
            GlobalEventManager.addListener((String)"shutdown", (GlobalEventListener)new GlobalEventListener(){

                public void actionPerformed(String string) {
                    try {
                        EchoUDP.this.shutDownServer();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            });
            this.portNumber = n;
            this.openSocket();
            this.start();
        }
        catch (Exception exception) {
            this.closeSocket();
            throw new TMException("An error occurred while creating echo server on port: " + this.portNumber + ".");
        }
    }

    public void openSocket() throws Exception {
        this.readBuffer = new byte[65535];
        this.udpPacket = new DatagramPacket(this.readBuffer, this.readBuffer.length);
        this.socketUDP = new DatagramSocket(this.portNumber);
        this.socketUDP.setSoTimeout(0);
        this.socketUDP.setSendBufferSize(NetworkDataLink.OSBUFFERSIZE);
        this.socketUDP.setReceiveBufferSize(NetworkDataLink.OSBUFFERSIZE);
        echoUDP = this;
    }

    @Override
    public void run() {
        Object var1_1 = null;
        while (this.serverRunning) {
            if (this.socketUDP == null) {
                try {
                    this.openSocket();
                }
                catch (Exception exception) {
                    System.err.println("Packet error: " + exception.getMessage());
                    this.closeSocket();
                }
            }
            try {
                this.socketUDP.receive(this.udpPacket);
                if (!this.serverRunning) continue;
                this.socketUDP.send(this.udpPacket);
            }
            catch (Exception exception) {
                this.closeSocket();
            }
        }
    }

    private void closeSocket() {
        try {
            this.socketUDP.close();
            this.socketUDP = null;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void shutDownServer() throws TMException {
        this.serverRunning = false;
        echoUDP = null;
        this.closeSocket();
    }

    public static EchoUDP getEchoServer() {
        return echoUDP;
    }

    public int getPort() {
        return this.portNumber;
    }
}

