/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.instrument;

import com.mathworks.jmi.types.MLArrayRef;
import com.mathworks.toolbox.instrument.ICProp;
import com.mathworks.toolbox.instrument.Network;
import com.mathworks.toolbox.instrument.Poller;
import com.mathworks.toolbox.instrument.events.ICEvent;
import com.mathworks.toolbox.instrument.util.DefaultICProp;
import com.mathworks.toolbox.instrument.util.Displays;
import com.mathworks.toolbox.testmeas.util.TMException;
import com.mathworks.util.Timer;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.net.ConnectException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.Calendar;
import java.util.Vector;

public class UDP
extends Network
implements ActionListener {
    private static final int PACKET_MAX_SIZE = 8192;
    private static final int MAX_DATAGRAM_PACKET_SIZE = 65535;
    public static final int DEFAULT_PACKET_SIZE = 512;
    public static final int DEFAULT_UDP_RPORT = 9090;
    protected static final int ETHERNET_UDP_SIZE = 1426;
    private String datagramAddress = "";
    private Integer datagramPort = null;
    private int inputDatagramPacketSize = 0;
    private int outputDatagramPacketSize = 0;
    private MLArrayRef datagramReceivedFcn = ACTION;
    private boolean datagramTerminateMode = true;
    private DatagramSocket socketUDP = null;
    private DatagramPacket packetReceive = null;
    private InetAddress networkAddress = null;
    private byte[] bufferReceive = null;
    private String datagramAddressRead = "";
    private Integer datagramPortRead = null;
    private boolean oldDatagramTerminateMode = false;
    private int okToPollReadCount = -1;
    private int maxOkToPollReadCount = 3;
    protected static final Object[] DPSize = new Object[]{new Double(1.0), new Double(65535.0)};
    static ICProp[] objectICProps = new ICProp[]{new ICProp("ByteOrder", "string", "enum", byteOVals, "bigEndian", "never", 0, 0), new ICProp("BytesAvailableFcnMode", "string", "enum", dModeVals, "terminator", "whileOpen", 0, 0), new ICProp("InputDatagramPacketSize", "double", "bounded", DPSize, new Integer(512), "whileOpen", 1, 0), new ICProp("OutputDatagramPacketSize", "double", "bounded", DPSize, new Integer(512), "whileOpen", 1, 0), new ICProp("DatagramAddress", "string", "none", "", "", "always", 1, 0), new ICProp("DatagramPort", "double", "bounded", RPortVals, null, "always", 1, 0), new ICProp("DatagramReceivedFcn", "callback", "callback", "", "", "never", 1, 0), new ICProp("DatagramTerminateMode", "string", "enum", boolVals, "on", "never", 1, 0), new ICProp("LocalHost", "string", "none", "", "", "whileOpen", 1, 0), new ICProp("LocalPort", "double", "bounded", RPortVals, null, "whileOpen", 1, 0), new ICProp("LocalPortMode", "string", "enum", PModeVals, "auto", "whileOpen", 1, 0), new ICProp("ReadAsyncMode", "string", "enum", AsyncVals, "continuous", "never", 1, 0), new ICProp("RemoteHost", "string", "none", "", "", "never", 1, 0), new ICProp("RemotePort", "double", "bounded", RPortVals, new Integer(9090), "never", 1, 0), new ICProp("Terminator", "ASCII Value", "ASCII Value", AsciiVals, "LF", "never", 1, 0), new ICProp("Type", "string", "none", "", "udp", "always", 0, 0)};

    public UDP() throws TMException {
        this.deleteInstrumentObject(this);
    }

    public UDP(String string, int n) throws TMException {
        if (!IS_TOOLBOX_INSTALLED) {
            UDP.displayError("The Instrument Control Toolbox license check failed when trying to execute: 'udp'.");
        }
        if (!this.verifySetRange(n, 1, 65535)) {
            this.deleteInstrumentObject(this);
            throw new TMException("RemotePort must range between 1 and 65535.");
        }
        this.remotePort = n;
        this.remoteHost = string == null || string.length() == 0 ? "127.0.0.1" : string;
        this.type = "udp";
        this.name = "UDP-" + this.remoteHost;
        this.displayName = "udp";
        this.objectProps = DefaultICProp.addObjectProps(objectICProps);
        this.byteOrder = 1;
    }

    @Override
    public Object[] getNonDefaultPVPairs() {
        Vector<Comparable<?>> vector = this.getPVPairs();
        this.addPVPair(vector, "DatagramTerminateMode", this.bool2OnOff(this.datagramTerminateMode));
        this.addPVPair(vector, "LocalHost", this.localHost);
        this.addPVPair(vector, "LocalPortMode", LPORT_MODE[this.localPortMode]);
        this.addPVPair(vector, "ReadAsyncMode", RA_MODES[this.readAsyncMode]);
        if (this.localPort != 0) {
            vector.addElement((Comparable<?>)((Object)"LocalPort"));
            vector.addElement(new Integer(this.localPort));
        }
        if (this.bytesAvailableFcnMode == 1) {
            vector.addElement((Comparable<?>)((Object)"BytesAvailableFcnMode"));
            vector.addElement((Comparable<?>)((Object)"byte"));
        }
        if (this.terminator != 10) {
            vector.addElement((Comparable<?>)((Object)"Terminator"));
            vector.addElement(new Integer(this.terminator));
        }
        Object[] objectArray = new Object[vector.size()];
        for (int i = 0; i < vector.size(); ++i) {
            objectArray[i] = vector.elementAt(i);
        }
        return objectArray;
    }

    public void setDatagramAddress(String string) throws TMException {
        UDP.displayError(this.createReadOnlyPropertyError("DatagramAddress"));
    }

    public String getDatagramAddress() {
        DatagramPacketInfo datagramPacketInfo = (DatagramPacketInfo)this.inputBuffer.getNextUserData();
        this.datagramAddress = datagramPacketInfo == null ? "" : datagramPacketInfo.getAddress();
        return this.datagramAddress;
    }

    public void setDatagramPort(Object object) throws TMException {
        UDP.displayError(this.createReadOnlyPropertyError("DatagramPort"));
    }

    public Integer getDatagramPort() {
        DatagramPacketInfo datagramPacketInfo = (DatagramPacketInfo)this.inputBuffer.getNextUserData();
        this.datagramPort = datagramPacketInfo == null ? null : new Integer(datagramPacketInfo.getPort());
        return this.datagramPort;
    }

    private int retrievePacketSize(int n) {
        if (n == 0) {
            return this.inputBufferSize > 8192 ? 8192 : this.inputBufferSize;
        }
        return n;
    }

    public int getInputDatagramPacketSize() {
        return this.retrievePacketSize(this.inputDatagramPacketSize);
    }

    public void setInputDatagramPacketSize(int n) throws TMException {
        if (this.status == 1) {
            UDP.displayError("InputDatagramPacketSize cannot be set while OBJ is open.");
        }
        if (!this.verifySetRange(n, 1, 65535)) {
            UDP.displayError("InputDatagramPacketSize must range between 1 and 65535.");
        }
        this.inputDatagramPacketSize = n;
        this.bufferReceive = new byte[this.inputDatagramPacketSize];
        this.postPropertyChangedEvent("InputDatagramPacketSize", this.inputDatagramPacketSize);
    }

    public int getOutputDatagramPacketSize() {
        return this.retrievePacketSize(this.outputDatagramPacketSize);
    }

    public void setOutputDatagramPacketSize(int n) throws TMException {
        if (this.status == 1) {
            UDP.displayError("OutputDatagramPacketSize cannot be set while OBJ is open.");
        }
        if (!this.verifySetRange(n, 1, 65535)) {
            UDP.displayError("OutputDatagramPacketSize must range between 1 and 65535.");
        }
        this.outputDatagramPacketSize = n;
        this.postPropertyChangedEvent("OutputDatagramPacketSize", this.outputDatagramPacketSize);
    }

    public final void setDatagramReceivedFcn(MLArrayRef mLArrayRef) throws TMException {
        MLArrayRef mLArrayRef2 = this.verifyActionValue("DatagramReceivedFcn", 8, mLArrayRef);
        if (this.datagramReceivedFcn != ACTION) {
            this.datagramReceivedFcn.dispose();
        }
        this.datagramReceivedFcn = mLArrayRef2;
        this.disabledCallbacks[8] = 0;
        this.postPropertyChangedEvent("DatagramReceivedFcn", this.datagramReceivedFcn);
    }

    public final MLArrayRef getDatagramReceivedFcn() {
        return this.datagramReceivedFcn;
    }

    public void setDatagramTerminateMode(boolean bl) {
        this.datagramTerminateMode = bl;
        this.postPropertyChangedEvent("DatagramTerminateMode", this.bool2OnOff(this.datagramTerminateMode));
    }

    public boolean getDatagramTerminateMode() {
        return this.datagramTerminateMode;
    }

    public void setInetRemoteAddress(InetAddress inetAddress) {
        this.networkAddress = inetAddress;
    }

    public InetAddress getInetRemoteAddress() {
        return this.networkAddress;
    }

    @Override
    public void setRemoteHost(String string) throws TMException {
        this.verifyIPAddress(string);
        this.remoteHost = string;
        this.updateNameProperty();
        this.postPropertyChangedEvent("RemoteHost", this.remoteHost);
        if (this.status == 0) {
            return;
        }
        try {
            if (this.remoteHost.equals("")) {
                this.networkAddress = null;
                throw new UnknownHostException("Unknown RemoteHost: ' '.");
            }
            try {
                this.networkAddress = InetAddress.getByName(this.remoteHost);
            }
            catch (UnknownHostException unknownHostException) {
                this.networkAddress = null;
                throw new UnknownHostException("Unknown RemoteHost: " + this.remoteHost + ".");
            }
        }
        catch (UnknownHostException unknownHostException) {
            UDP.displayError(unknownHostException.getMessage());
        }
    }

    @Override
    public void setRemotePort(int n) throws TMException {
        if (!this.verifySetRange(n, 1, 65535)) {
            UDP.displayError("RemotePort must range between 1 and 65535.");
        }
        this.remotePort = n;
        this.postPropertyChangedEvent("RemotePort", new Integer(this.remotePort));
    }

    @Override
    protected void nameStandardFormat() {
        this.nameStandardFormat = this.name.equals("UDP-" + this.remoteHost);
    }

    @Override
    protected void updateNameProperty() {
        if (this.nameStandardFormat) {
            this.setName("UDP-" + this.remoteHost);
        }
    }

    @Override
    public void setSendBufferSize(int n) {
        try {
            this.socketUDP.setSendBufferSize(n);
        }
        catch (SocketException socketException) {
            // empty catch block
        }
    }

    @Override
    public int getSendBufferSize() {
        int n = 0;
        try {
            n = this.socketUDP.getSendBufferSize();
        }
        catch (SocketException socketException) {
            // empty catch block
        }
        return n;
    }

    @Override
    public void setReceiveBufferSize(int n) {
        try {
            this.socketUDP.setReceiveBufferSize(n);
        }
        catch (SocketException socketException) {
            // empty catch block
        }
    }

    @Override
    public int getReceiveBufferSize() {
        int n = 0;
        try {
            n = this.socketUDP.getReceiveBufferSize();
        }
        catch (SocketException socketException) {
            // empty catch block
        }
        return n;
    }

    @Override
    public void openHardware() throws IOException, ConnectException, TMException {
        try {
            this.verifyIPAddress(this.getRemoteHost());
            if (this.getLocalPortMode() == 1 && this.localPort == 0) {
                UDP.displayError("LocalPort must be an integer ranging from 1 to 65535.");
            }
            if (this.getRemoteHost().equals("")) {
                this.setInetRemoteAddress(null);
                throw new UnknownHostException("Unknown RemoteHost: ' '.");
            }
            try {
                this.setInetRemoteAddress(InetAddress.getByName(this.remoteHost));
            }
            catch (UnknownHostException unknownHostException) {
                this.setInetRemoteAddress(null);
                throw new UnknownHostException("Unknown RemoteHost: " + this.remoteHost + ".");
            }
            if (this.localHost.equals("") && this.localPortMode == 0) {
                this.socketUDP = new DatagramSocket();
            } else if (this.localHost.equals("") && this.localPortMode == 1) {
                this.socketUDP = new DatagramSocket(this.localPort);
            } else {
                try {
                    this.socketUDP = new DatagramSocket(this.localPort, InetAddress.getByName(this.getLocalHost()));
                }
                catch (UnknownHostException unknownHostException) {
                    throw new UnknownHostException("Unknown LocalHost: " + this.getLocalHost() + ".");
                }
            }
            this.enableOSBuffer(1);
            this.enableOSBuffer(0);
            this.socketUDP.setSoTimeout(1);
            this.localPort = this.socketUDP.getLocalPort();
            int n = this.getInputDatagramPacketSize();
            this.bufferReceive = new byte[n];
            this.packetReceive = new DatagramPacket(this.bufferReceive, n);
        }
        catch (UnknownHostException unknownHostException) {
            UDP.displayError(unknownHostException.getMessage());
        }
    }

    @Override
    public void closeHardware() throws Exception {
        Poller.removeInstrument(this);
        if (this.wasTimerStarted) {
            this.timer.hold();
        }
        this.socketUDP.close();
        this.socketUDP = null;
    }

    @Override
    public void disposeMLArrayRefs() {
        this.superDisposeMLArrayRef();
        this.terminatorObject.dispose();
        if (this.timer != null) {
            this.timer.removeActionListener((ActionListener)this);
        }
        if (this.datagramReceivedFcn != ACTION) {
            this.datagramReceivedFcn.dispose();
        }
        this.socketUDP = null;
        this.packetReceive = null;
    }

    @Override
    public void updatePropsOnOpen() throws Exception {
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        this.eventTime = Calendar.getInstance();
        if (this.timerFcn != ACTION) {
            this.executeEvent(6, "Timer", this.eventTime, new ICEvent("Timer", UDP.constructClockVector(this.eventTime)));
        }
    }

    @Override
    public void createTimer() {
        this.timer = new Timer((int)(this.timerPeriod * 1000.0), (ActionListener)this, 1, 5, "UDPTimer");
        this.timer.start();
        this.wasTimerStarted = true;
    }

    @Override
    public final Object[] constructorargs() {
        Object[] objectArray = new Object[]{this.getRemoteHost(), new Integer(this.getRemotePort())};
        return objectArray;
    }

    @Override
    public final String getConstructor() {
        return "udp('" + this.getRemoteHost() + "', " + this.getRemotePort() + ");";
    }

    @Override
    public String getConstructorDescription() {
        return "Remote Host - " + this.getRemoteHost() + ", Remote Port - " + this.getRemotePort();
    }

    @Override
    public String getInstrfindArgs() {
        return "('Type', '" + this.type + "', 'RemoteHost', '" + this.remoteHost + "', 'RemotePort', " + this.remotePort + ", 'Tag', '" + this.tag + "');";
    }

    @Override
    protected int getBlockSizeForWrite() {
        return this.getOutputDatagramPacketSize();
    }

    @Override
    protected void writeData(String string, int n, int n2) throws Exception {
        this.socketUDP.send(new DatagramPacket(string.getBytes(), n, n2 - n, this.networkAddress, this.remotePort));
    }

    @Override
    protected void writeData(byte[] byArray, int n, int n2) throws Exception {
        this.socketUDP.send(new DatagramPacket(byArray, n, n2, this.networkAddress, this.remotePort));
    }

    @Override
    protected int writeAsciiToHardware(String string) {
        if (this.getInetRemoteAddress() == null) {
            return -8;
        }
        try {
            return this.writeAsciiToNetwork(string);
        }
        catch (Exception exception) {
            return this.returnWriteErrorCode(-1);
        }
    }

    @Override
    protected int writeBinaryToHardware(Object object, int n, int n2) {
        if (this.getInetRemoteAddress() == null) {
            return -8;
        }
        try {
            return this.writeBinaryToNetwork(object, n, n2);
        }
        catch (Exception exception) {
            return this.returnWriteErrorCode(-1);
        }
    }

    @Override
    protected int writeAsyncDataToHardware(int n, int n2) {
        if (this.getInetRemoteAddress() == null) {
            return -8;
        }
        try {
            this.socketUDP.send(new DatagramPacket(this.dataToWriteAsync, n, n2, this.getInetRemoteAddress(), this.remotePort));
        }
        catch (Exception exception) {
            return -9;
        }
        return 0;
    }

    @Override
    protected void cleanupWriteAsync() {
        if (!this.outputEmptyFcn.equals(ACTION)) {
            this.eventTime = Calendar.getInstance();
            this.executeEvent(4, "OutputEmpty", this.eventTime, new ICEvent("OutputEmpty", UDP.constructClockVector(this.eventTime)));
        }
    }

    @Override
    protected boolean okToPollRead() {
        if (this.okToPollReadCount >= 0) {
            ++this.okToPollReadCount;
        }
        if (this.okToPollReadCount > this.maxOkToPollReadCount) {
            this.okToPollReadCount = -1;
        }
        if (this.okToPollReadCount != -1) {
            this.setCompletedAction(false);
            return false;
        }
        boolean bl = false;
        switch (this.readAsyncMode) {
            case 0: {
                bl = this.inputBufferSize - this.getBytesAvailable() > 0;
                break;
            }
            case 1: {
                boolean bl2 = bl = this.readAsyncCount > 0;
            }
        }
        if (this.readAsyncCount == 0 && this.readAsyncMode == 1) {
            this.hardwareFlushInput();
        }
        return bl;
    }

    @Override
    protected synchronized int getBytesAvailableFromHardware() {
        return 0;
    }

    @Override
    protected synchronized byte[] readAsynchronousDataFromHardware(int n) {
        try {
            this.numOfTerminatorsFound = 0;
            this.packetReceive.setData(this.bufferReceive);
            this.packetReceive.setLength(this.getInputDatagramPacketSize());
            this.socketUDP.receive(this.packetReceive);
            int n2 = this.packetReceive.getLength();
            if (n2 == 0) {
                this.okToPollReadCount = 0;
                this.setCompletedAction(false);
                return null;
            }
            int n3 = this.packetReceive.getPort();
            String string = this.packetReceive.getAddress().getHostAddress();
            byte[] byArray = this.packetReceive.getData();
            int n4 = 0;
            DatagramPacketInfo datagramPacketInfo = null;
            switch (this.readAsyncMode) {
                case 0: {
                    this.updateReadTransferStatus(true);
                    n4 = Math.min(this.inputBufferSize - this.getBytesAvailable(), n2);
                    datagramPacketInfo = new DatagramPacketInfo(string, n3);
                    this.putDataInputBuffer(byArray, n4, datagramPacketInfo);
                    this.updateReadTransferStatus(false);
                    break;
                }
                case 1: {
                    n4 = Math.min(this.readAsyncCount, n2);
                    datagramPacketInfo = new DatagramPacketInfo(string, n3);
                    this.putDataInputBuffer(byArray, n4, datagramPacketInfo);
                    this.readAsyncCount -= n4;
                    if (this.readAsyncCount != 0 && this.numOfTerminatorsFound <= 0) break;
                    this.updateReadTransferStatus(false);
                    this.readAsyncCount = 0;
                }
            }
            if (n4 == n2 && !this.ignoreReadEvents && !this.datagramReceivedFcn.equals(ACTION)) {
                this.eventTime = Calendar.getInstance();
                this.executeEvent(8, "DatagramReceived", this.eventTime, new ICEvent("DatagramReceived", UDP.constructClockVector(this.eventTime), string, n3, n2));
            }
            byArray = null;
            return null;
        }
        catch (Exception exception) {
            this.okToPollReadCount = 0;
            this.setCompletedAction(false);
            return null;
        }
    }

    protected void putDataInputBuffer(byte[] byArray, int n, Object object) {
        int n2;
        this.numOfTerminatorsFound = 0;
        if (byArray == null) {
            return;
        }
        byte by = this.inputBuffer.getLastByte();
        int n3 = 0;
        int n4 = 0;
        for (n2 = 0; n2 < n - 1; ++n2) {
            if (this.tlength == 1 && byArray[n2] == this.char0 || this.tlength == 2 && by == this.char0 && byArray[n2] == this.char1) {
                ++this.numOfTerminatorsFound;
                this.inputBuffer.addData(byArray, 1, object, n4, ++n3);
                n4 += n3;
                n3 = 0;
            } else {
                ++n3;
            }
            by = byArray[n2];
        }
        n2 = 3;
        if (this.tlength == 1 && byArray[n - 1] == this.char0 || this.tlength == 2 && by == this.char0 && byArray[n - 1] == this.char1) {
            ++this.numOfTerminatorsFound;
            n2 = 4;
        }
        this.inputBuffer.addData(byArray, n2, object, n4, ++n3);
    }

    @Override
    protected boolean okToTerminateASCIIRead(int n) {
        if (this.datagramTerminateMode) {
            return n == 3 || n == 4;
        }
        return n == 1 || n == 4;
    }

    @Override
    protected boolean isReadAsyncOperationComplete(int n, int n2) {
        switch (this.readAsyncMode) {
            case 0: {
                if (this.datagramTerminateMode) {
                    return this.getBytesAvailable() >= n || this.inputBuffer.isReadComplete(3, 4);
                }
                return this.getBytesAvailable() >= n || this.inputBuffer.isReadComplete(1, 4);
            }
            case 1: {
                if (this.datagramTerminateMode) {
                    return this.getBytesAvailable() >= n || this.readAsyncCount == 0 || this.inputBuffer.isReadComplete(3, 4);
                }
                return this.getBytesAvailable() >= n || this.readAsyncCount == 0 || this.inputBuffer.isReadComplete(1, 4);
            }
        }
        return false;
    }

    @Override
    protected Object[] getASCIIDataFromBuffer(int n) {
        Object[] objectArray = this.inputBuffer.getDataWithInfoAndUserData(n);
        if (objectArray == null) {
            objectArray = new Object[]{"", new Integer(0)};
            return objectArray;
        }
        String string = "";
        string = objectArray[0] instanceof String ? (String)objectArray[0] : new String((byte[])objectArray[0]);
        int n2 = (Integer)objectArray[1];
        DatagramPacketInfo datagramPacketInfo = (DatagramPacketInfo)objectArray[2];
        this.datagramAddressRead = datagramPacketInfo.getAddress();
        int n3 = datagramPacketInfo.getPort();
        boolean bl = true;
        while (!this.okToTerminateASCIIRead(n2) && this.getBytesAvailable() > 0 && !this.okToTerminateASCIIReadForSize(n, string)) {
            objectArray = this.inputBuffer.getDataWithInfoAndUserData(n);
            string = string + new String((byte[])objectArray[0]);
            n2 = (Integer)objectArray[1];
            datagramPacketInfo = (DatagramPacketInfo)objectArray[2];
            if (bl && datagramPacketInfo != null && this.datagramAddressRead.equals(datagramPacketInfo.getAddress()) && n3 == datagramPacketInfo.getPort()) continue;
            bl = false;
            this.datagramAddressRead = "";
            this.datagramPortRead = null;
        }
        if (bl) {
            this.datagramPortRead = new Integer(n3);
        }
        objectArray[0] = string;
        return objectArray;
    }

    private boolean okToTerminateASCIIReadForSize(int n, String string) {
        if (this.datagramTerminateMode) {
            return false;
        }
        return string.length() >= n;
    }

    @Override
    protected Object[] addToASCIIOutput(Object[] objectArray) {
        Object[] objectArray2 = new Object[]{objectArray[0], objectArray[1], objectArray[2], this.datagramAddressRead, this.datagramPortRead};
        this.datagramAddressRead = "";
        this.datagramPortRead = null;
        return objectArray2;
    }

    @Override
    protected Object[] addToBinaryOutput(Object[] objectArray) {
        return this.addToASCIIOutput(objectArray);
    }

    @Override
    public int getBinaryCountToReadFromBuffer(int n, int n2) {
        if (this.datagramTerminateMode) {
            return this.inputBuffer.getByteCountToNextDatagram();
        }
        if (this.inputBuffer.getBytesAvailable() >= n) {
            return n;
        }
        return -1;
    }

    @Override
    protected Object[] getBinaryDataFromBuffer(int n) {
        Object[] objectArray = this.inputBuffer.getDataWithInfoAndUserData(n);
        if (objectArray == null) {
            objectArray = new Object[]{new byte[0], new Integer(0)};
        }
        byte[] byArray = (byte[])objectArray[0];
        DatagramPacketInfo datagramPacketInfo = (DatagramPacketInfo)objectArray[2];
        this.datagramAddressRead = datagramPacketInfo.getAddress();
        int n2 = datagramPacketInfo.getPort();
        boolean bl = true;
        while (byArray.length < n && this.getBytesAvailable() > 0) {
            objectArray = this.inputBuffer.getDataWithInfoAndUserData(n - byArray.length);
            byArray = this.inputBuffer.concat(byArray, (byte[])objectArray[0]);
            datagramPacketInfo = (DatagramPacketInfo)objectArray[2];
            if (bl && datagramPacketInfo != null && this.datagramAddressRead.equals(datagramPacketInfo.getAddress()) && n2 == datagramPacketInfo.getPort()) continue;
            bl = false;
            this.datagramAddressRead = "";
            this.datagramPortRead = null;
        }
        if (bl) {
            this.datagramPortRead = new Integer(n2);
        }
        objectArray[0] = byArray;
        return objectArray;
    }

    @Override
    protected synchronized void hardwareFlushInput() {
        try {
            this.packetReceive.setData(this.bufferReceive);
            this.packetReceive.setLength(this.getInputDatagramPacketSize());
            this.socketUDP.receive(this.packetReceive);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    protected byte[] readBytes(int n) {
        return null;
    }

    @Override
    protected void stopHardwareDueToWriteTimeout() {
        try {
            this.hardwareFlushOutput();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    protected void updateObjectBinblockRead() {
        this.oldDatagramTerminateMode = this.datagramTerminateMode;
        this.datagramTerminateMode = false;
    }

    @Override
    protected void restoreObjectFromBinblockRead() {
        this.datagramTerminateMode = this.oldDatagramTerminateMode;
    }

    @Override
    protected String wasAsciiReadSuccessful(String string, int n, int n2) {
        if (ctrlc_flag) {
            return "Ctrl-C was hit before the data was read.";
        }
        if (this.datagramTerminateMode ? n2 == 3 || n2 == 4 : n2 == 1 || n2 == 4) {
            return "";
        }
        if (n == 0 && string.length() == this.inputBufferSize && !string.endsWith(this.terminatorChar)) {
            if (this.datagramTerminateMode) {
                return "The input buffer was filled before the datagram was read.";
            }
            return "The input buffer was filled before the Terminator was reached.";
        }
        if (n == 0 && string.length() != this.inputBufferSize && this.terminatorChar.equals("")) {
            return "A timeout occurred.";
        }
        if (n != 0 && string.length() != n && this.terminatorChar.equals("")) {
            if (this.datagramTerminateMode) {
                return "A timeout occurred before the datagram was read.";
            }
            return "A timeout occurred before SIZE values were available.";
        }
        if (n == 0 && string.length() != this.inputBufferSize && !string.endsWith(this.terminatorChar)) {
            if (this.datagramTerminateMode) {
                return "A timeout occurred before the datagram was read.";
            }
            return "A timeout occurred before the Terminator was reached.";
        }
        if (n != 0 && string.length() != n && !string.endsWith(this.terminatorChar) && !this.terminatorChar.equals("")) {
            if (this.datagramTerminateMode) {
                return "A timeout occurred before the datagram was read.";
            }
            return "A timeout occurred before the Terminator was reached or SIZE values were available.";
        }
        if (n != 0 && string.length() < n && string.endsWith(this.terminatorChar)) {
            if (this.datagramTerminateMode) {
                return "";
            }
            return "The Terminator was reached before SIZE values were available.";
        }
        return "";
    }

    @Override
    protected String wasBinaryReadSuccessful(int n, int n2, String string, int n3) {
        if (n >= n2) {
            return "";
        }
        if (this.datagramTerminateMode) {
            if (n3 == 3 || n3 == 4) {
                return "";
            }
            return "The datagram was not returned within the Timeout period.";
        }
        return "The specified amount of data was not returned within the Timeout period.";
    }

    @Override
    protected void updateObjectSpecificProperties(ICProp[] iCPropArray) {
        for (int i = 0; i < iCPropArray.length; ++i) {
            String string = iCPropArray[i].name;
            if (string.equals("Name")) {
                iCPropArray[i].setDefaultValue("UDP-" + this.remoteHost);
                continue;
            }
            if (string.equals("RemoteHost")) {
                iCPropArray[i].setDefaultValue(this.remoteHost);
                continue;
            }
            if (!string.equals("RemotePort") || this.remotePort == 0) continue;
            iCPropArray[i].setDefaultValue(new Integer(this.remotePort));
        }
    }

    public static ICProp[] getProperties() {
        return DefaultICProp.addObjectProps(objectICProps);
    }

    @Override
    public void display() {
        if (!this.isvalid()) {
            System.out.println(Displays.invalidDisplay());
            return;
        }
        String string = LINESEP + "   UDP Object : " + this.name + LINESEP + LINESEP + "   Communication Settings " + LINESEP + "      RemotePort:         " + this.getRemotePort() + LINESEP + "      RemoteHost:         " + this.getRemoteHost() + LINESEP + "      Terminator:         " + this.displayTerminator + LINESEP + LINESEP + "   Communication State " + LINESEP + "      Status:             " + STATUS_ENUM[this.status] + LINESEP + "      RecordStatus:       " + RECORD_STATUS_ENUM[this.bool2int(this.recordStatus)] + LINESEP + LINESEP + "   Read/Write State  " + LINESEP + "      TransferStatus:     " + TRANSFER_STATUS_ENUM[this.transferStatus] + LINESEP + "      BytesAvailable:     " + this.bytesAvailable + LINESEP + "      ValuesReceived:     " + this.getValuesReceived() + LINESEP + "      ValuesSent:         " + this.getValuesSent() + LINESEP + " " + LINESEP;
        System.out.println(string);
    }

    @Override
    public String setDisplay() {
        return Displays.getSetDisplay("terminator") + "    UDP specific properties:" + LINESEP + "    DatagramReceivedFcn: string -or- function handle -or- cell array" + LINESEP + "    DatagramTerminateMode: [ {on} | off ]" + LINESEP + "    LocalHost" + LINESEP + "    LocalPort" + LINESEP + "    LocalPortMode: [ {auto} | manual ]" + LINESEP + "    ReadAsyncMode: [ {continuous} | manual ]" + LINESEP + "    RemoteHost" + LINESEP + "    RemotePort" + LINESEP + "    Terminator" + LINESEP + "    InputDatagramPacketSize" + LINESEP + "    OutputDatagramPacketSize" + LINESEP + " " + LINESEP;
    }

    class DatagramPacketInfo {
        private String address;
        private int port;

        DatagramPacketInfo(String string, int n) {
            this.address = string;
            this.port = n;
        }

        public String getAddress() {
            return this.address;
        }

        public int getPort() {
            return this.port;
        }
    }
}

