/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.instrument.browser.hardware;

import com.mathworks.jmi.Matlab;
import com.mathworks.jmi.MatlabEvent;
import com.mathworks.jmi.MatlabListener;
import com.mathworks.mwswing.DefaultSortableTable;
import com.mathworks.toolbox.instrument.AdaptorInfo;
import com.mathworks.toolbox.instrument.Instrument;
import com.mathworks.toolbox.instrument.browser.InstrumentControlBrowser;
import com.mathworks.toolbox.instrument.browser.InstrumentControlBrowserPage;
import com.mathworks.toolbox.instrument.browser.hardware.BoardPage;
import com.mathworks.toolbox.instrument.browser.hardware.GPIBBoardPage;
import com.mathworks.toolbox.instrument.guiutil.MatrixTableModel;
import com.mathworks.toolbox.testmeas.browser.BrowserConfigFileWriter;
import com.mathworks.toolbox.testmeas.browser.BrowserTreeNode;
import com.mathworks.toolbox.testmeas.util.TMStringUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableModel;
import org.w3c.dom.Element;

public abstract class ProtocolPage
extends InstrumentControlBrowserPage
implements ActionListener {
    protected static Hashtable<String, String> vendors;
    protected String[] headings = new String[]{"Vendor", ""};
    protected Object[][] data;
    protected InstrumentControlBrowser browser;
    protected String[] path = new String[]{"Instrument Control Toolbox", "Hardware", ""};
    protected MatrixTableModel tableModel;
    protected DefaultSortableTable table;
    protected JButton scanButton;
    protected JLabel lastScanDateLabel;
    protected String initialDate;
    protected Object[] matlabArgs;
    protected String panelTitle;
    protected Vector<BoardPage> pages = new Vector();
    private boolean scanForAll = false;
    protected String statusMessage;
    protected Vector<BrowserTreeNode> currentNodes = new Vector();
    protected Vector<BrowserTreeNode> lastNodes = new Vector();
    protected boolean disableOnStart = false;
    protected boolean enableOnFinish = false;
    protected ScanRunnable scanRunnable = null;

    protected abstract void constructDataArray(Object var1, String var2);

    protected abstract void createNodeOnLoad(String var1, String var2);

    protected abstract void createInstrumentNodeOnLoad(String var1, String var2, String var3, Element var4);

    public ProtocolPage() {
    }

    public ProtocolPage(InstrumentControlBrowser instrumentControlBrowser) {
        this.browser = instrumentControlBrowser;
        this.matlabArgs = new Object[2];
        this.matlabArgs[0] = "privateBrowserHelper";
        this.matlabArgs[1] = "identifyGPIB";
    }

    protected void init() {
        this.setLayout(new BorderLayout(0, 0));
        this.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.layoutPanel();
        this.cleanup();
    }

    @Override
    public void setup() {
        this.scanButton.addActionListener(this);
    }

    @Override
    public void cleanup() {
        this.scanButton.removeActionListener(this);
        if (this.pages != null) {
            for (int i = 0; i < this.pages.size(); ++i) {
                this.pages.elementAt(i).cleanup();
            }
        }
    }

    @Override
    public void dispose() {
        this.cleanup();
        if (this.pages != null) {
            for (int i = 0; i < this.pages.size(); ++i) {
                this.pages.elementAt(i).dispose();
            }
        }
        this.pages = null;
        this.currentNodes.removeAllElements();
        this.currentNodes = null;
        this.lastNodes.removeAllElements();
        this.lastNodes = null;
    }

    private void layoutPanel() {
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.setBorder(BorderFactory.createEmptyBorder(6, 10, 0, 10));
        this.add(jPanel, "Center");
        this.tableModel = new MatrixTableModel(this.headings);
        this.table = new DefaultSortableTable((TableModel)this.tableModel);
        this.table.getColumnModel().getColumn(0).setPreferredWidth(150);
        this.table.getColumnModel().getColumn(1).setPreferredWidth(50);
        this.table.setName(this.path[2] + " Hardware Table");
        JTableHeader jTableHeader = this.table.getTableHeader();
        jTableHeader.setReorderingAllowed(true);
        JScrollPane jScrollPane = new JScrollPane((Component)this.table);
        jPanel.add((Component)jScrollPane, "Center");
        jScrollPane.setPreferredSize(new Dimension(200, 50));
        JPanel jPanel2 = new JPanel(new BorderLayout(0, 0));
        this.initialDate = TMStringUtil.getDate();
        this.lastScanDateLabel = new JLabel("Last scan date: " + this.initialDate);
        jPanel2.add((Component)this.lastScanDateLabel, "West");
        jPanel2.add((Component)this.createButtonPanel(), "Center");
        jPanel.add((Component)jPanel2, "South");
    }

    private JPanel createButtonPanel() {
        JPanel jPanel = new JPanel(new FlowLayout(2, 0, 5));
        JPanel jPanel2 = new JPanel(new GridLayout(1, 1, 0, 0));
        this.scanButton = new JButton("Scan");
        this.scanButton.addActionListener(this);
        this.scanButton.setName(this.path[2] + " Scan Button");
        jPanel2.add(this.scanButton);
        jPanel.add(jPanel2);
        return jPanel;
    }

    public void save(BrowserConfigFileWriter browserConfigFileWriter, Element element) {
        Object object;
        int n;
        if (this.data == null) {
            return;
        }
        String string = this.lastScanDateLabel.getText();
        for (n = 0; n < this.data.length; ++n) {
            object = (String)this.data[n][0];
            if (((String)object).equals("No chassis were found") || ((String)object).equals("No boards were found")) continue;
            Element element2 = browserConfigFileWriter.addNode(element, "Instrument");
            element2.setAttribute("Type", this.path[2] + "Board");
            element2.setAttribute("LastScanDate", string);
            element2.setAttribute("Vendor", (String)this.data[n][0]);
            element2.setAttribute("Index", (String)this.data[n][1]);
        }
        for (n = 0; n < this.pages.size(); ++n) {
            object = this.pages.elementAt(n);
            ((BoardPage)object).save(browserConfigFileWriter, element);
        }
    }

    public void load(String string, Element element) {
        this.lastScanDateLabel.setText(string);
        String string2 = element.getAttribute("Vendor");
        String string3 = element.getAttribute("Index");
        Object[] objectArray = new Object[]{string2, string3};
        this.tableModel.append(objectArray);
        this.data = this.tableModel.getData();
        this.createNodeOnLoad(string2, string3);
    }

    public void load(String string, String string2, Element element) {
        String string3 = element.getAttribute("Vendor");
        String string4 = element.getAttribute("Index");
        string2 = string2.substring(string2.indexOf(": ") + 2);
        this.createInstrumentNodeOnLoad(string3, string4, string2, element);
    }

    protected String extractVendorAbbrv(String string) {
        int n = string.indexOf("(");
        int n2 = string.indexOf(")");
        return string.substring(n + 1, n2);
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        this.scanForAll = false;
        this.disableOnStart = true;
        this.enableOnFinish = true;
        this.callIntoMATLAB();
    }

    public void scanForAll() {
        this.scanForAll = true;
        this.disableOnStart = true;
        this.enableOnFinish = true;
        this.callIntoMATLAB();
    }

    @Override
    public void scanForAll(boolean bl, boolean bl2) {
        this.scanForAll = true;
        this.disableOnStart = bl;
        this.enableOnFinish = bl2;
        this.callIntoMATLAB();
    }

    public void callIntoMATLAB() {
        if (this.disableOnStart) {
            this.browser.postBlockEventsEvent(true);
        }
        this.pages.removeAllElements();
        this.browser.postStatusBarUpdateEvent(this.statusMessage);
        Instrument.enableInstrumentObjectEvents(false);
        if (this.scanRunnable == null) {
            this.scanRunnable = new ScanRunnable();
        }
        Matlab.whenMatlabReady((Runnable)this.scanRunnable);
    }

    private void updateTableData(Object object) {
        this.data = null;
        this.constructDataArray(object, TMStringUtil.getDate());
        if (this.table != null) {
            this.tableModel.setData(this.data);
        }
    }

    protected String createVendorStr(String string) {
        String string2 = string.toLowerCase();
        return vendors.get(string2) + " (" + string2 + ")";
    }

    protected void cleanupNodes() {
        for (int i = 0; i < this.lastNodes.size(); ++i) {
            if (this.currentNodes.contains(this.lastNodes.elementAt(i))) continue;
            BrowserTreeNode browserTreeNode = this.lastNodes.elementAt(i);
            this.browser.removeNode(browserTreeNode.getName(), this.path);
            ((BoardPage)((Object)browserTreeNode.getPanel())).cleanupNodes();
        }
        this.lastNodes = this.currentNodes;
        this.currentNodes = null;
        this.currentNodes = new Vector();
    }

    static {
        int n;
        vendors = new Hashtable();
        for (n = 0; n < AdaptorInfo.GPIB_VENDORS.length; ++n) {
            vendors.put(AdaptorInfo.GPIB_VENDORS[n], AdaptorInfo.GPIB_NAMES[n]);
        }
        for (n = 0; n < AdaptorInfo.VISA_VENDORS.length; ++n) {
            vendors.put(AdaptorInfo.VISA_VENDORS[n], AdaptorInfo.VISA_NAMES[n]);
        }
    }

    public class ScanRunnable
    implements Runnable,
    MatlabListener {
        private Matlab matlab = new Matlab();

        @Override
        public void run() {
            try {
                this.matlab.feval("instrgate", ProtocolPage.this.matlabArgs, 1, (MatlabListener)this);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        public void matlabEvent(MatlabEvent matlabEvent) {
            try {
                Instrument.enableInstrumentObjectEvents(true);
                if (matlabEvent.getStatus() == 0) {
                    Object object = matlabEvent.getResult();
                    ProtocolPage.this.updateTableData(object);
                    ProtocolPage.this.browser.postRefreshFinishedEvent();
                    if (ProtocolPage.this.enableOnFinish) {
                        ProtocolPage.this.browser.postBlockEventsEvent(false);
                    }
                    if (ProtocolPage.this.scanForAll) {
                        for (int i = 0; i < ProtocolPage.this.pages.size(); ++i) {
                            BoardPage boardPage = ProtocolPage.this.pages.elementAt(i);
                            if (boardPage instanceof GPIBBoardPage) {
                                ((GPIBBoardPage)boardPage).updateTableData();
                                continue;
                            }
                            boardPage.scanForAll(true, true);
                        }
                    }
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

