/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.instrument.device.drivers.vxipnp.fp;

import com.mathworks.jmi.Matlab;
import com.mathworks.toolbox.instrument.util.Preferences;
import com.mathworks.toolbox.testmeas.util.TMStringUtil;
import java.util.Hashtable;

public class Argument {
    public static final int kInput = 1;
    public static final int kOutput = 2;
    public static final int kRing = 3;
    public static final int kBinary = 4;
    public static final int kSlide = 5;
    public static final int kReturnValue = 6;
    public static final int kGlobal = 7;
    public static final int kMessage = 8;
    public static final int kEnumRing = 1;
    public static final int kIntegerRing = 2;
    public static final int kDoubleRing = 3;
    private String name;
    private int controlType;
    private String dataTypeName;
    private int position;
    private int ringType;
    private double increment;
    private double minValue;
    private double maxValue;
    private double defaultNumericValue;
    private Hashtable<Object, Object> enums;

    public Argument(String string, int n, String string2) {
        this.setName(string);
        this.setType(n);
        this.dataTypeName = string2.indexOf("struct") == -1 ? string2.toLowerCase() : string2;
        this.enums = new Hashtable();
        this.increment = 0.0;
        this.minValue = 0.0;
        this.maxValue = 0.0;
        this.defaultNumericValue = 0.0;
    }

    public int getType() {
        return this.controlType;
    }

    private void setType(int n) {
        this.controlType = n;
    }

    public String getName() {
        if (this.name == null) {
            return "x";
        }
        String string = this.name.trim().replaceAll("\\W+", "");
        if (string.length() > 0) {
            char c = string.charAt(0);
            if (Character.isDigit(c)) {
                string = "x" + string;
            }
            return string;
        }
        return "x";
    }

    public void setName(String string) {
        string = TMStringUtil.strrep((String)string, (String)" ", (String)"");
        string = TMStringUtil.strrep((String)string, (String)"-", (String)"");
        string = TMStringUtil.strrep((String)string, (String)"(", (String)"");
        string = TMStringUtil.strrep((String)string, (String)")", (String)"");
        string = TMStringUtil.strrep((String)string, (String)"[", (String)"");
        if (!TMStringUtil.isvarname((String)(string = TMStringUtil.strrep((String)string, (String)"]", (String)"")))) {
            string = "temp" + string;
        }
        if (string.length() > Matlab.getNameLengthMax()) {
            string = string.substring(0, Matlab.getNameLengthMax() - 1);
        }
        this.name = string;
    }

    public int getPosition() {
        return this.position;
    }

    public void setPosition(int n) {
        this.position = n;
    }

    public String getDataType() {
        return this.dataTypeName;
    }

    public int getRingType() {
        return this.ringType;
    }

    public void setRingType(int n) {
        this.ringType = n;
    }

    public double getIncrement() {
        return this.increment;
    }

    public void setIncrement(double d) {
        this.increment = d;
    }

    public double getMinValue() {
        return this.minValue;
    }

    public void setMinValue(double d) {
        this.minValue = d;
    }

    public double getMaxValue() {
        return this.maxValue;
    }

    public void setMaxValue(double d) {
        this.maxValue = d;
    }

    public double getDefaultNumericValue() {
        return this.defaultNumericValue;
    }

    public void setDefaultNumericValue(double d) {
        this.defaultNumericValue = d;
    }

    public Hashtable<Object, Object> getEnums() {
        return this.enums;
    }

    public void setEnums(Hashtable<Object, Object> hashtable) {
        this.enums = hashtable;
    }

    public boolean isReference() {
        if (this.dataTypeName.startsWith("vip")) {
            return true;
        }
        if (this.dataTypeName.startsWith("viattr")) {
            return false;
        }
        if (this.dataTypeName.startsWith("via")) {
            return true;
        }
        if (this.dataTypeName.endsWith("[]")) {
            return true;
        }
        if (this.dataTypeName.equalsIgnoreCase("virsrc")) {
            return true;
        }
        return this.isOutput();
    }

    public boolean isArray() {
        if (this.dataTypeName.startsWith("viattr")) {
            return false;
        }
        if (this.dataTypeName.startsWith("via")) {
            return true;
        }
        return this.dataTypeName.endsWith("[]");
    }

    public boolean isBoolean() {
        if (this.dataTypeName.startsWith("viboolean")) {
            return true;
        }
        if (this.dataTypeName.equalsIgnoreCase("vipboolean")) {
            return true;
        }
        return this.dataTypeName.equalsIgnoreCase("viaboolean");
    }

    public boolean isString() {
        if (this.dataTypeName.equals("viconststring")) {
            return true;
        }
        if (this.dataTypeName.equals("vistring")) {
            return true;
        }
        if (this.dataTypeName.equals("vipchar")) {
            return true;
        }
        if (this.dataTypeName.equals("viachar")) {
            return true;
        }
        if (this.dataTypeName.startsWith("vichar") && this.dataTypeName.endsWith("]")) {
            return true;
        }
        return this.dataTypeName.indexOf("rsrc") != -1;
    }

    public boolean isOutput() {
        return this.controlType == 2;
    }

    public boolean isSession() {
        return this.dataTypeName.equalsIgnoreCase("visession");
    }

    public boolean isStatus() {
        return this.dataTypeName.equalsIgnoreCase("viStatus");
    }

    public String getMATLABPointerType() {
        if (!this.isReference()) {
            return "notref";
        }
        if (this.dataTypeName.indexOf("byte") != -1) {
            return "uint8Ptr";
        }
        if (this.dataTypeName.indexOf("buf") != -1) {
            return "uint8Ptr";
        }
        if (this.dataTypeName.indexOf("uint8") != -1) {
            return "uint8Ptr";
        }
        if (this.dataTypeName.indexOf("int8") != -1) {
            return "int8Ptr";
        }
        if (this.dataTypeName.indexOf("uint16") != -1) {
            return "uint16Ptr";
        }
        if (this.dataTypeName.indexOf("int16") != -1) {
            return "int16Ptr";
        }
        if (this.dataTypeName.indexOf("uint32") != -1) {
            return "uint32Ptr";
        }
        if (this.dataTypeName.indexOf("int32") != -1) {
            return "int32Ptr";
        }
        if (this.dataTypeName.indexOf("uint64") != -1) {
            return "uint64Ptr";
        }
        if (this.dataTypeName.indexOf("int64") != -1) {
            return "int64Ptr";
        }
        if (this.dataTypeName.indexOf("real32") != -1) {
            return "singlePtr";
        }
        if (this.dataTypeName.indexOf("real64") != -1) {
            return "doublePtr";
        }
        if (this.dataTypeName.indexOf("boolean") != -1) {
            return "uint16Ptr";
        }
        if (this.dataTypeName.indexOf("object") != -1) {
            return "uint32Ptr";
        }
        if (this.dataTypeName.indexOf("session") != -1) {
            return "uint32Ptr";
        }
        if (this.dataTypeName.indexOf("status") != -1) {
            return "int32Ptr";
        }
        if (this.dataTypeName.indexOf("version") != -1) {
            return "uint32Ptr";
        }
        if (this.dataTypeName.indexOf("addr") != -1) {
            return "voidPtr";
        }
        if (this.isString()) {
            return "int8Ptr";
        }
        if (Preferences.log_vxipnp) {
            System.out.println("Failed to locate appropriate pointer type for " + this.dataTypeName + ".");
        }
        return this.dataTypeName;
    }

    public boolean isStruct() {
        return this.dataTypeName.indexOf("struct") != -1;
    }

    public String getMATLABStructPointerType() {
        String string = new String("unknowStruct");
        String[] stringArray = this.dataTypeName.split(" ");
        if (stringArray.length > 1) {
            string = stringArray[1].replaceAll("\\[\\]", "");
        }
        return string;
    }
}

