/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.instrument.device.drivers.vxipnp.fp;

import com.mathworks.toolbox.instrument.device.drivers.vxipnp.fp.Argument;
import com.mathworks.toolbox.instrument.device.drivers.vxipnp.fp.FunctionPanel;
import com.mathworks.toolbox.instrument.device.drivers.vxipnp.fp.VendorParser;
import com.mathworks.toolbox.instrument.device.guiutil.midtool.DriverFunction;
import com.mathworks.toolbox.instrument.device.guiutil.midtool.DriverGroup;
import com.mathworks.toolbox.instrument.device.guiutil.midtool.DriverModel;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class BasicParser
implements VendorParser {
    protected DriverModel fModel;
    protected Hashtable<String, ?> fFunctions;
    protected Vector<String> fFunctionNames;
    protected Hashtable<Object, FunctionPanel> fModelFPMapping;

    @Override
    public void parseFunctionPanels(DriverModel driverModel, Hashtable<String, ?> hashtable) {
        this.fModel = driverModel;
        this.fFunctions = hashtable;
        this.fFunctionNames = new Vector();
        this.fModelFPMapping = new Hashtable();
        Enumeration<String> enumeration = hashtable.keys();
        while (enumeration.hasMoreElements()) {
            this.fFunctionNames.add(enumeration.nextElement());
        }
        this.sortFunctionPanels();
    }

    protected void sortFunctionPanels() {
        try {
            while (!this.fFunctionNames.isEmpty()) {
                String string = this.fFunctionNames.get(0);
                this.fFunctionNames.remove(string);
                FunctionPanel functionPanel = (FunctionPanel)this.fFunctions.get(string);
                DriverGroup driverGroup = this.fModel.getGroup(functionPanel.getMATLABSafeClassName());
                if (driverGroup == null) {
                    driverGroup = this.fModel.createGroup(functionPanel.getMATLABSafeClassName());
                }
                this.createFunction(functionPanel.getName(), functionPanel, driverGroup);
            }
        }
        catch (Exception exception) {
            System.out.println(exception.getMessage());
            exception.printStackTrace();
        }
    }

    protected DriverFunction createFunction(String string, FunctionPanel functionPanel, DriverGroup driverGroup) {
        DriverFunction driverFunction = new DriverFunction(string, driverGroup);
        driverFunction.setCodeType(0);
        Vector<String> vector = new Vector<String>();
        Argument[] argumentArray = functionPanel.getArguments();
        if (argumentArray != null) {
            for (int i = 0; i < argumentArray.length; ++i) {
                vector.add(argumentArray[i].getName());
            }
            driverFunction.setInputs(vector);
        }
        driverFunction.setDescription(functionPanel.getHelpText());
        this.fModel.add(driverFunction);
        this.fModelFPMapping.put(driverGroup.getName() + string, functionPanel);
        return driverFunction;
    }

    @Override
    public void removeSmallGroups() {
    }
}

