/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.instrument.device.guiutil.midtest.panel;

import com.mathworks.toolbox.instrument.device.guiutil.midtest.CodeGenerator;
import com.mathworks.toolbox.instrument.device.guiutil.midtest.MIDTestToolClient;
import com.mathworks.toolbox.instrument.device.guiutil.midtest.MIDTestToolFileWriter;
import com.mathworks.toolbox.instrument.device.guiutil.midtest.panel.FunctionSweepInfo;
import com.mathworks.toolbox.instrument.device.guiutil.midtest.panel.MIDStepPanel;
import com.mathworks.toolbox.instrument.device.guiutil.midtest.panel.StepInfo;
import com.mathworks.toolbox.testmeas.util.TMStringUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.table.AbstractTableModel;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class FunctionSweepPanel
extends MIDStepPanel
implements ActionListener {
    private static final long serialVersionUID = 1L;
    private static final Boolean TRUE = new Boolean(true);
    private static final Boolean FALSE = new Boolean(false);
    public static final String ACTION = "ACTION";
    private static final int SELECT = 0;
    private static final int UNSELECT = 1;
    private static final String NO_HELP = "No help is defined for the function: ";
    private String[] headings = new String[]{" ", "Function Name", "Group Name"};
    private Object[][] data = null;
    private FunctionTableModel model = null;
    private JScrollPane groupComboBoxesPanel;
    private Hashtable<String, JComboBox> groupComboBoxes = new Hashtable();
    private JTextField stepPassesFunction;
    private JCheckBox noErrorStepPass;
    private JCheckBox functionStepPass;
    private int maxLabelWidth = 0;
    private JLabel tempLabel = new JLabel();
    private long driverLastModified = 0L;

    public FunctionSweepPanel(MIDTestToolClient mIDTestToolClient) {
        this.client = mIDTestToolClient;
        this.layoutPanel();
        this.setName("Function Sweep Step Panel");
    }

    @Override
    public void update(StepInfo stepInfo) {
        FunctionSweepInfo functionSweepInfo = (FunctionSweepInfo)stepInfo;
        if (functionSweepInfo.getData() == null) {
            this.updateMethodsInTable();
            return;
        }
        if (functionSweepInfo.getNeedsToUpdate() == TRUE.booleanValue()) {
            this.setSelectedMethods(functionSweepInfo.getSelectedMethods());
            this.setSelectedGroups(functionSweepInfo.getSelectedGroups());
            this.noErrorStepPass.setSelected(functionSweepInfo.getNoErrorStepPass());
            this.functionStepPass.setSelected(functionSweepInfo.getFunctionStepPass());
            this.stepPassesFunction.setText(functionSweepInfo.getStepPassesFunction());
            return;
        }
        this.updateAfterDriverReload(functionSweepInfo);
        functionSweepInfo.setNeedsToUpdate(FALSE);
    }

    public void updatePanelAfterDriverReload() {
        this.updateMethodsInTable();
        this.groupComboBoxesPanel.getViewport().setView(this.layoutGroupObjectComboboxes());
    }

    private void updateAfterDriverReload(FunctionSweepInfo functionSweepInfo) {
        this.updateMethodsInTable();
        Object[][] objectArray = functionSweepInfo.getData();
        for (int i = 0; i < objectArray.length; ++i) {
            int n;
            boolean bl = (Boolean)objectArray[i][0];
            if (bl != FALSE || (n = this.findTableRow((String)objectArray[i][1], (String)objectArray[i][2])) == -1) continue;
            this.data[n][0] = FALSE;
        }
        this.model.fireTableDataChanged();
        this.groupComboBoxesPanel.getViewport().setView(this.layoutGroupObjectComboboxes());
        String[] stringArray = functionSweepInfo.getGroupNames();
        this.setSelectedGroups(stringArray);
        this.noErrorStepPass.setSelected(functionSweepInfo.getNoErrorStepPass());
        this.functionStepPass.setSelected(functionSweepInfo.getFunctionStepPass());
    }

    @Override
    public void cleanup(StepInfo stepInfo) {
        FunctionSweepInfo functionSweepInfo = (FunctionSweepInfo)stepInfo;
        functionSweepInfo.setSelectedMethods(this.getSelectedMethods());
        functionSweepInfo.setSelectedGroups(this.getSelectedGroups());
        functionSweepInfo.setNoErrorStepPass(this.noErrorStepPass.isSelected());
        functionSweepInfo.setFunctionStepPass(this.functionStepPass.isSelected());
        functionSweepInfo.setStepPassesFunction(this.stepPassesFunction.getText());
        functionSweepInfo.setData(this.data);
        functionSweepInfo.setGroupNames(this.getSelectedGroupNames());
    }

    private int findTableRow(String string, String string2) {
        for (int i = 0; i < this.data.length; ++i) {
            String string3 = (String)this.data[i][1];
            String string4 = (String)this.data[i][2];
            if (!string3.equals(string) || !string4.equals(string2)) continue;
            return i;
        }
        return -1;
    }

    private int[] getSelectedMethods() {
        int[] nArray = new int[this.data.length];
        int n = 0;
        for (int i = 0; i < this.data.length; ++i) {
            if (!this.data[i][0].equals(TRUE)) continue;
            nArray[n++] = i;
        }
        int[] nArray2 = new int[n];
        for (int i = 0; i < n; ++i) {
            nArray2[i] = nArray[i];
        }
        return nArray2;
    }

    private void setSelectedMethods(int[] nArray) {
        if (nArray == null) {
            this.selectMethods(TRUE);
            return;
        }
        this.selectMethods(FALSE);
        for (int i = 0; i < nArray.length; ++i) {
            this.data[nArray[i]][0] = TRUE;
        }
    }

    private String[] getSelectedGroupNames() {
        String[] stringArray = this.getGroupNames();
        String[] stringArray2 = new String[2 * stringArray.length];
        int n = 0;
        for (int i = 0; i < stringArray.length; ++i) {
            JComboBox jComboBox = this.groupComboBoxes.get(stringArray[i]);
            stringArray2[n++] = stringArray[i];
            stringArray2[n++] = (String)jComboBox.getSelectedItem();
        }
        return stringArray2;
    }

    private void setSelectedGroups(String[] stringArray) {
        for (int i = 0; i < stringArray.length; i += 2) {
            JComboBox jComboBox = this.groupComboBoxes.get(stringArray[i]);
            if (jComboBox == null) continue;
            jComboBox.setSelectedItem(stringArray[i + 1]);
        }
    }

    private int[] getSelectedGroups() {
        String[] stringArray = this.getGroupNames();
        int[] nArray = new int[stringArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            JComboBox jComboBox = this.groupComboBoxes.get(stringArray[i]);
            nArray[i] = jComboBox.getSelectedIndex();
        }
        return nArray;
    }

    private void setSelectedGroups(int[] nArray) {
        int n;
        String[] stringArray = this.getGroupNames();
        if (nArray == null) {
            nArray = new int[stringArray.length];
            for (n = 0; n < nArray.length; ++n) {
                nArray[n] = 0;
            }
        }
        for (n = 0; n < stringArray.length; ++n) {
            JComboBox jComboBox = this.groupComboBoxes.get(stringArray[n]);
            jComboBox.setSelectedIndex(nArray[n]);
        }
    }

    @Override
    public void save(MIDTestToolFileWriter mIDTestToolFileWriter, Element element, StepInfo stepInfo) {
        FunctionSweepInfo functionSweepInfo = (FunctionSweepInfo)stepInfo;
        mIDTestToolFileWriter.addNode(element, "Name", functionSweepInfo.getName());
        Object[][] objectArray = functionSweepInfo.getData();
        int n = 0;
        for (int i = 0; i < objectArray.length; ++i) {
            Element element2 = mIDTestToolFileWriter.addNode(element, "DataRow");
            element2.setAttribute("Selected", String.valueOf(objectArray[i][0]));
            element2.setAttribute("Method", (String)objectArray[i][1]);
            element2.setAttribute("Group", (String)objectArray[i][2]);
            if (!objectArray[i][0].equals(TRUE)) continue;
            ++n;
        }
        String[] stringArray = functionSweepInfo.getGroupNames();
        for (int i = 0; i < stringArray.length; ++i) {
            mIDTestToolFileWriter.addNode(element, "GroupName", stringArray[i]);
        }
        int[] nArray = functionSweepInfo.getSelectedGroups();
        for (int i = 0; i < nArray.length; ++i) {
            mIDTestToolFileWriter.addNode(element, "GroupIndex", nArray[i]);
        }
        mIDTestToolFileWriter.addNode(element, "SelectedMethods", n);
        mIDTestToolFileWriter.addNode(element, "NoErrorStepPass", functionSweepInfo.getNoErrorStepPass());
        mIDTestToolFileWriter.addNode(element, "FunctionStepPass", functionSweepInfo.getFunctionStepPass());
        mIDTestToolFileWriter.addNode(element, "StepPassesFunction", functionSweepInfo.getStepPassesFunction());
    }

    @Override
    public void load(Node node, StepInfo stepInfo) {
        FunctionSweepInfo functionSweepInfo = (FunctionSweepInfo)stepInfo;
        functionSweepInfo.setNeedsToUpdate(TRUE);
        Vector<String> vector = new Vector<String>();
        Vector<String> vector2 = new Vector<String>();
        Vector<String> vector3 = new Vector<String>();
        int n = 0;
        NodeList nodeList = node.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            String string = nodeList.item(i).getNodeName();
            NodeList nodeList2 = nodeList.item(i).getChildNodes();
            if (string.equals("Name")) {
                functionSweepInfo.setName(nodeList2.item(0).getNodeValue());
                continue;
            }
            if (string.equals("DataRow")) {
                Element element = (Element)nodeList.item(i);
                vector3.addElement(element.getAttribute("Selected"));
                vector3.addElement(element.getAttribute("Method"));
                vector3.addElement(element.getAttribute("Group"));
                continue;
            }
            if (string.equals("GroupName")) {
                vector.addElement(nodeList2.item(0).getNodeValue());
                continue;
            }
            if (string.equals("NoErrorStepPass")) {
                functionSweepInfo.setNoErrorStepPass(new Boolean(nodeList2.item(0).getNodeValue()));
                continue;
            }
            if (string.equals("FunctionStepPass")) {
                functionSweepInfo.setFunctionStepPass(new Boolean(nodeList2.item(0).getNodeValue()));
                continue;
            }
            if (string.equals("StepPassesFunction")) {
                functionSweepInfo.setStepPassesFunction(nodeList2.item(0).getNodeValue());
                continue;
            }
            if (string.equals("GroupIndex")) {
                vector2.addElement(nodeList2.item(0).getNodeValue());
                continue;
            }
            if (!string.equals("SelectedMethods")) continue;
            n = new Integer(nodeList2.item(0).getNodeValue());
        }
        functionSweepInfo.setGroupNames(TMStringUtil.vector2StringArray(vector));
        Object[][] objectArray = new Object[vector3.size() / 3][3];
        int n2 = 0;
        for (int i = 0; i < vector3.size(); i += 3) {
            objectArray[n2][0] = this.str2Boolean((String)vector3.elementAt(i));
            objectArray[n2][1] = vector3.elementAt(i + 1);
            objectArray[n2++][2] = vector3.elementAt(i + 2);
        }
        functionSweepInfo.setData(objectArray);
        int[] nArray = new int[vector2.size()];
        for (int i = 0; i < vector2.size(); ++i) {
            nArray[i] = new Integer((String)vector2.elementAt(i));
        }
        functionSweepInfo.setSelectedGroups(nArray);
        n2 = 0;
        int[] nArray2 = new int[n];
        for (int i = 0; i < objectArray.length; ++i) {
            if (!objectArray[i][0].equals(TRUE)) continue;
            nArray2[n2++] = i;
        }
        functionSweepInfo.setSelectedMethods(nArray2);
        functionSweepInfo.setIsNodeDirty(FALSE);
    }

    private Boolean str2Boolean(String string) {
        if (string.equals("true")) {
            return TRUE;
        }
        return FALSE;
    }

    @Override
    public void duplicate(StepInfo stepInfo, StepInfo stepInfo2) {
        FunctionSweepInfo functionSweepInfo = (FunctionSweepInfo)stepInfo;
        FunctionSweepInfo functionSweepInfo2 = (FunctionSweepInfo)stepInfo2;
        functionSweepInfo.setSelectedMethods(functionSweepInfo2.getSelectedMethods());
        functionSweepInfo.setSelectedGroups(functionSweepInfo2.getSelectedGroups());
        functionSweepInfo.setData(functionSweepInfo2.getData());
        functionSweepInfo.setGroupNames(functionSweepInfo2.getGroupNames());
        functionSweepInfo.setNoErrorStepPass(functionSweepInfo2.getNoErrorStepPass());
        functionSweepInfo.setFunctionStepPass(functionSweepInfo2.getFunctionStepPass());
        functionSweepInfo.setStepPassesFunction(functionSweepInfo2.getStepPassesFunction());
    }

    private void layoutPanel() {
        this.setLayout(new BorderLayout(0, 0));
        JPanel jPanel = this.add(this.createSelectButtonPanel(), this.createFunctionTablePanel(), 5);
        JPanel jPanel2 = this.add(jPanel, this.createGroupObjectPanel(), 5);
        JPanel jPanel3 = this.add(jPanel2, this.createStepPassesPanel(), 5);
        this.add((Component)jPanel3, "North");
    }

    private JPanel createSelectButtonPanel() {
        JPanel jPanel = new JPanel(new BorderLayout(0, 0));
        jPanel.add((Component)new JLabel("Select the functions to test:"), "West");
        JButton jButton = new JButton("Select All");
        JButton jButton2 = new JButton("Unselect All");
        jButton.setName("Select All Button");
        jButton2.setName("Unselect All Button");
        jButton.putClientProperty(ACTION, new Integer(0));
        jButton2.putClientProperty(ACTION, new Integer(1));
        jButton.addActionListener(this);
        jButton2.addActionListener(this);
        JPanel jPanel2 = new JPanel(new GridLayout(1, 2, 5, 0));
        jPanel2.add(jButton);
        jPanel2.add(jButton2);
        JPanel jPanel3 = new JPanel(new FlowLayout(2, 0, 0));
        jPanel3.add(jPanel2);
        jPanel.add((Component)jPanel3, "Center");
        jPanel.setBorder(BorderFactory.createEmptyBorder(0, 2, 0, 2));
        return jPanel;
    }

    private JPanel createFunctionTablePanel() {
        JPanel jPanel = new JPanel(new BorderLayout(0, 0));
        this.createTableData();
        this.model = new FunctionTableModel();
        JTable jTable = new JTable(this.model);
        jTable.setName("Function Sweep Table");
        jTable.getColumnModel().getColumn(0).setPreferredWidth(200);
        jTable.getColumnModel().getColumn(1).setPreferredWidth(1000);
        jTable.getColumnModel().getColumn(2).setPreferredWidth(1000);
        JScrollPane jScrollPane = new JScrollPane(jTable);
        jScrollPane.setPreferredSize(new Dimension(150, 300));
        jPanel.add((Component)jScrollPane, "Center");
        jPanel.setBorder(BorderFactory.createEmptyBorder(0, 2, 0, 2));
        return jPanel;
    }

    private JPanel createGroupObjectPanel() {
        JPanel jPanel = new JPanel(new BorderLayout(0, 4));
        jPanel.add((Component)new JLabel("Select the group object(s) to use on sweep:"), "North");
        this.groupComboBoxesPanel = new JScrollPane(this.layoutGroupObjectComboboxes());
        this.groupComboBoxesPanel.getVerticalScrollBar().setUnitIncrement(10);
        this.groupComboBoxesPanel.setPreferredSize(new Dimension(54, 300));
        this.groupComboBoxesPanel.setBorder(BorderFactory.createTitledBorder(""));
        jPanel.add((Component)this.groupComboBoxesPanel, "Center");
        jPanel.setBorder(BorderFactory.createEmptyBorder(0, 2, 0, 2));
        return jPanel;
    }

    private JPanel createStepPassesPanel() {
        JPanel jPanel = new JPanel(new BorderLayout(0, 0));
        this.stepPassesFunction = new JTextField();
        this.noErrorStepPass = new JCheckBox("If no MATLAB or instrument error occurs", (boolean)TRUE);
        this.functionStepPass = new JCheckBox("If output of function: ", (boolean)FALSE);
        this.stepPassesFunction.setName("Step Passes Function Text Field");
        this.noErrorStepPass.setName("No error Checkbox");
        this.functionStepPass.setName("Function CheckBox");
        JPanel jPanel2 = new JPanel(new GridLayout(3, 1, 0, 0));
        jPanel2.setBorder(BorderFactory.createTitledBorder("Select when this step passes"));
        jPanel2.add(this.noErrorStepPass);
        JPanel jPanel3 = new JPanel(new BorderLayout(0, 0));
        jPanel3.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 5));
        JLabel jLabel = new JLabel("  is true");
        jPanel3.add((Component)jLabel, "East");
        jPanel3.add((Component)this.functionStepPass, "West");
        jPanel3.add((Component)this.stepPassesFunction, "Center");
        jPanel2.add(jPanel3);
        jPanel.add((Component)jPanel2, "North");
        return jPanel;
    }

    private void createTableData() {
        int n;
        if (this.getDriverDate() == this.driverLastModified && this.data != null) {
            return;
        }
        this.driverLastModified = this.getDriverDate();
        String[] stringArray = this.getGroupNames();
        int n2 = 0;
        int n3 = 0;
        Vector<String> vector = this.getParser().getMethods("parent");
        Vector vector2 = vector == null ? new Vector() : (Vector)vector.clone();
        vector2.add("devicereset");
        vector2.add("geterror");
        vector2.add("selftest");
        vector2 = TMStringUtil.stringArray2Vector((String[])TMStringUtil.sort((String[])TMStringUtil.vector2StringArray((Vector)vector2)));
        n2 = vector2.size();
        for (n = 0; n < stringArray.length; ++n) {
            vector = this.getParser().getMethods(stringArray[n]);
            if (vector == null) continue;
            n2 += vector.size();
        }
        this.data = new Object[n2][3];
        for (n = 0; n < vector2.size(); ++n) {
            this.data[n3][0] = TRUE;
            this.data[n3][1] = vector2.elementAt(n);
            this.data[n3++][2] = "Device Object";
        }
        for (n = 0; n < stringArray.length; ++n) {
            String string = stringArray[n];
            Vector<String> vector3 = this.getParser().getMethods(string);
            if (vector3 == null) continue;
            Vector vector4 = (Vector)vector3.clone();
            for (int i = 0; i < vector4.size(); ++i) {
                this.data[n3][0] = TRUE;
                this.data[n3][1] = vector4.elementAt(i);
                this.data[n3++][2] = string;
            }
        }
    }

    private JPanel layoutGroupObjectComboboxes() {
        String[] stringArray = this.getGroupNames();
        this.groupComboBoxes = new Hashtable();
        JPanel jPanel = new JPanel(new GridLayout(stringArray.length, 1, 0, 0));
        if (stringArray.length == 0) {
            return jPanel;
        }
        this.calculateMaximumGroupLabelWidth();
        jPanel.setBorder(BorderFactory.createEmptyBorder(4, 4, 4, 4));
        for (int i = 0; i < stringArray.length; ++i) {
            jPanel.add(this.createGroupPanel(stringArray[i]));
        }
        return jPanel;
    }

    private void calculateMaximumGroupLabelWidth() {
        String[] stringArray = this.getGroupNames();
        for (int i = 0; i < stringArray.length; ++i) {
            this.tempLabel.setText(stringArray[i] + ":");
            int n = this.tempLabel.getPreferredSize().width;
            if (n <= this.maxLabelWidth) continue;
            this.maxLabelWidth = n;
        }
        this.maxLabelWidth += 2;
    }

    private JPanel createGroupPanel(String string) {
        this.tempLabel.setText(string + ":");
        int n = this.maxLabelWidth - this.tempLabel.getPreferredSize().width;
        JPanel jPanel = new JPanel(new BorderLayout(n, 0));
        jPanel.add((Component)new JLabel(string + ":"), "West");
        JComboBox<String> jComboBox = new JComboBox<String>();
        jComboBox.setName(string + " ComboBox");
        int n2 = this.getGroupSize(string);
        for (int i = 0; i < n2; ++i) {
            jComboBox.addItem(this.getGroupCommandNameAt(string, i + 1));
        }
        jComboBox.addItem("All " + string + " group objects");
        this.groupComboBoxes.put(string, jComboBox);
        jPanel.add(jComboBox, "Center");
        JPanel jPanel2 = new JPanel(new BorderLayout(0, 0));
        jPanel2.add((Component)jPanel, "North");
        return jPanel2;
    }

    protected void updateMethodsInTable() {
        this.data = null;
        this.createTableData();
        this.model.fireTableDataChanged();
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        JComponent jComponent = (JComponent)actionEvent.getSource();
        int n = (Integer)jComponent.getClientProperty(ACTION);
        switch (n) {
            case 0: {
                this.selectMethods(TRUE);
                break;
            }
            case 1: {
                this.selectMethods(FALSE);
            }
        }
    }

    private void selectMethods(boolean bl) {
        Boolean bl2 = TRUE;
        if (bl == FALSE) {
            bl2 = FALSE;
        }
        for (int i = 0; i < this.data.length; ++i) {
            this.data[i][0] = bl2;
        }
        this.model.fireTableDataChanged();
    }

    @Override
    public String generateCode(StepInfo stepInfo, boolean bl, boolean bl2, int n) {
        FunctionSweepInfo functionSweepInfo = (FunctionSweepInfo)stepInfo;
        String string = this.getDisplayFunction(bl);
        String string2 = this.getDisplayInsert(bl);
        String string3 = "";
        int[] nArray = functionSweepInfo.getSelectedMethods();
        int[] nArray2 = functionSweepInfo.getSelectedGroups();
        String[] stringArray = functionSweepInfo.getGroupNames();
        string3 = this.addLine(string3, "finalerrorcode = false;");
        string3 = this.addLine(string3, "");
        string3 = this.addLine(string3, "% M-Lint warnings to be ignored:");
        string3 = this.addLine(string3, "% Cell array concatenation warning: ");
        string3 = this.addLine(string3, "%#ok<*CCAT>");
        string3 = this.addLine(string3, "% Unused variables warning: ");
        string3 = this.addLine(string3, "%#ok<*NASGU>");
        for (int i = 0; i < nArray.length; ++i) {
            String string4;
            String string5 = (String)this.data[nArray[i]][1];
            String string6 = (String)this.data[nArray[i]][2];
            String[] stringArray2 = null;
            int n2 = 0;
            String string7 = "deviceObj";
            if (string6.equals("Device Object")) {
                string6 = "parent";
            } else {
                n2 = this.getSelectedGroupIndex(string6, stringArray, nArray2);
                string7 = this.getSelectedGroupName(string6, stringArray);
            }
            String string8 = this.createHeaderLine(string5, string6);
            string3 = this.addLine(string3, " ");
            string3 = this.addLine(string3, string8);
            string3 = this.addLine(string3, " ");
            string3 = this.addLine(string3, "% Reset errorcode.");
            string3 = this.addLine(string3, "errorcode = false;");
            if (bl == TRUE) {
                string3 = this.addLine(string3, "");
                string3 = this.addLine(string3, "% Post information on the method being tested.");
                string3 = this.addLine(string3, string + "('Testing " + string5 + " method in the " + string6 + " group." + string2 + "');");
                string3 = this.addLine(string3, "% Verify that the test is still running.");
                string3 = this.addLine(string3, "if (MIDTestToolClient.isTestRunning == false)");
                string3 = this.addLine(string3, "    MessageService.publish('Test status: " + CodeGenerator.generateColorCode(TRUE, "\"#0000FF\"", "INCOMPLETE") + "');");
                string3 = this.addLine(string3, "    return;");
                string3 = this.addLine(string3, "end");
            }
            string3 = this.addLine(string3, "try");
            string3 = this.addTabbedLine(string3, "% Execute the function.");
            String string9 = this.getFunctionDefinitionForSweep(string6, string5);
            if (string6.equals("parent")) {
                string3 = this.addTabbedLine(string3, string9);
            } else {
                string3 = this.addTabbedLine(string3, "groupObj = get(deviceObj, '" + string6 + "');");
                String string10 = "All " + string6 + " group objects";
                if (!string7.equals(string10)) {
                    string3 = this.addTabbedLine(string3, "groupObj = groupObj(" + (n2 + 1) + ");");
                }
                string3 = this.addTabbedLine(string3, string9);
            }
            int n3 = this.getNumOutputArguments(string9);
            if (n3 > 0) {
                string4 = this.getOutputArgumentString(string9);
                stringArray2 = this.getOutputArguments(string4, n3);
                string3 = this.addTabbedLine(string3, " ");
                string3 = this.addTabbedLine(string3, "% Store the result so that it can be returned.");
                string3 = this.addTabbedLine(string3, "varargout = {varargout{:}, " + string4 + "};");
            }
            string3 = this.addLine(string3, " ");
            string3 = this.addTabbedLine(string3, "% Check if instrument error occurred.");
            string4 = this.getParser().getDriverType();
            if (string4.equalsIgnoreCase("MATLAB VXIplug&play") || string4.equalsIgnoreCase("MATLAB IVI-C") || string4.equalsIgnoreCase("MATLAB IVI-COM")) {
                string3 = this.addTabbedLine(string3, "util = get(deviceObj, 'Utility');");
                string3 = this.addTabbedLine(string3, "util = util(1);");
            }
            string3 = string4.equalsIgnoreCase("MATLAB IVI-COM") ? this.addTabbedLine(string3, "[~ , result] = invoke(util,'ErrorQuery');") : (string4.equalsIgnoreCase("MATLAB VXIplug&play") || string4.equalsIgnoreCase("MATLAB IVI-C") ? this.addTabbedLine(string3, "[~ , result] = invoke(util,'errorquery');") : this.addTabbedLine(string3, "result = geterror(deviceObj);"));
            if (functionSweepInfo.getNoErrorStepPass() == TRUE.booleanValue()) {
                string3 = this.addTabbedLine(string3, "errorcode = ~strcmpi(result, noErrorMsg);");
                string3 = this.addTabbedLine(string3, "");
                string3 = this.addTabbedLine(string3, this.postMessage(bl, "An instrument error occurred while executing the function.", "result", TRUE, "    "));
            }
            string3 = this.addLine(string3, "catch aException");
            string3 = this.addTabbedLine(string3, "% A MATLAB error occurred.");
            if (functionSweepInfo.getNoErrorStepPass() == TRUE.booleanValue()) {
                string3 = this.addTabbedLine(string3, "errorcode = true;");
                string3 = this.addLine(string3, "");
                string3 = this.addTabbedLine(string3, "% Post information about error.");
                string3 = this.addTabbedLine(string3, string + "('" + CodeGenerator.generateColorCode(bl, "\"#FF0000\"", "A MATLAB error occurred while testing the function.") + string2 + "');");
                string3 = this.addTabbedLine(string3, string + "(" + CodeGenerator.generateColorCodeToEval(bl, "\"#FF0000\"", "aException.message") + ");");
            }
            string3 = this.addLine(string3, "end");
            if (functionSweepInfo.getFunctionStepPass() == TRUE.booleanValue()) {
                string3 = this.addLine(string3, "");
                string3 = this.addLine(string3, "% Error if the output of the test function does not return true.");
                string3 = this.addLine(string3, "if (errorcode == false)");
                string3 = this.addTabbedLine(string3, "outputOfFeval = feval(" + functionSweepInfo.getStepPassesFunction() + ");");
                string3 = this.addTabbedLine(string3, "");
                string3 = this.addTabbedLine(string3, "if (outputOfFeval == false)");
                string3 = this.addTabbedLine(string3, "    errorcode = true;");
                string3 = this.addTabbedLine(string3, "");
                string3 = this.addTabbedLine(string3, "    % Post information about error.");
                string3 = this.addTabbedLine(string3, "    " + string + "('The testing function did not return true." + string2 + "');");
                string3 = this.addTabbedLine(string3, "end");
                string3 = this.addLine(string3, "end");
            }
            string3 = this.addLine(string3, "");
            string3 = this.addLine(string3, "if(errorcode)");
            string3 = this.addTabbedLine(string3, "finalerrorcode = true;");
            string3 = this.addLine(string3, "end");
            string3 = this.addLine(string3, "");
            if (bl == TRUE) {
                this.client.assignVariableInformation(new Integer(n3));
                for (int j = 0; j < n3; ++j) {
                    this.client.assignVariable(stringArray2[j]);
                }
            }
            if (bl2 != TRUE || this.isFunctionHelpDefined(string6, string5) != FALSE.booleanValue()) continue;
            string3 = this.addLine(string3, "");
            string3 = this.addLine(string3, "% Post warnings.");
            string3 = this.addLine(string3, "warningOccurred = true;");
            string3 = this.addLine(string3, "stepWarningOccurred = true;");
            string3 = this.addLine(string3, string + "('" + CodeGenerator.generateColorCode(bl, "\"#0000FF\"", NO_HELP + string5 + ", in the " + string6 + " group.") + string2 + "');");
        }
        string3 = this.addLine(string3, "% Assign finalerrorcode to errorcode.");
        string3 = this.addLine(string3, "% If finalerrorcode is true, at least one function failed in Function Sweep.");
        string3 = this.addLine(string3, "errorcode = finalerrorcode;");
        return string3;
    }

    private String createHeaderLine(String string, String string2) {
        String string3 = new String("%% " + string.toUpperCase() + " from group: " + string2.toUpperCase());
        return string3;
    }

    private int getNumOutputArguments(String string) {
        int n = string.indexOf(61);
        if (n == -1) {
            return 0;
        }
        String string2 = string.substring(0, n);
        return string2.replaceAll("[^,]", "").length() + 1;
    }

    private String getOutputArgumentString(String string) {
        if (string.indexOf(91) == -1) {
            return string.substring(0, string.indexOf(61));
        }
        return string.substring(string.indexOf(91) + 1, string.indexOf(93));
    }

    private String[] getOutputArguments(String string, int n) {
        if (n == 0) {
            return null;
        }
        string = TMStringUtil.strrep((String)string, (String)" ", (String)"");
        String[] stringArray = new String[n];
        int n2 = 0;
        int n3 = string.indexOf(",");
        int n4 = 0;
        while (n3 != -1) {
            stringArray[n2++] = string.substring(n4, n3);
            n4 = n3 + 1;
            n3 = string.indexOf(",", n3 + 1);
        }
        stringArray[n2] = string.substring(n4);
        return stringArray;
    }

    private String getFunctionDefinitionForSweep(String string, String string2) {
        if (string2.equals("devicereset") && string.equals("parent")) {
            return "devicereset(deviceObj);";
        }
        if (string2.equals("geterror") && string.equals("parent")) {
            return "msg = geterror(deviceObj);";
        }
        if (string2.equals("selftest") && string.equals("parent")) {
            return "out = selftest(deviceObj);";
        }
        String string3 = this.getParser().getMethodDefinition(string2, string).getInvokeCommand().toLowerCase();
        int n = this.getNumInputArguments(string3);
        if (n != 0) {
            int n2 = string3.indexOf("',");
            String string4 = new String("");
            for (int i = 0; i < n; ++i) {
                string4 = string4.concat(",0");
            }
            string4 = string4.concat(")");
            string3 = string3.substring(0, n2 + 1).concat(string4);
        }
        if (string.equals("parent")) {
            return string3.replace("(obj", "(deviceObj").concat(";");
        }
        return string3.replace("(obj", "(groupObj").concat(";");
    }

    private int getNumInputArguments(String string) {
        int n = string.indexOf("',");
        if (n != -1) {
            int n2 = string.length();
            int n3 = string.substring(n, n2).replaceAll("[^,]", "").length();
            return n3;
        }
        return 0;
    }

    private int getSelectedGroupIndex(String string, String[] stringArray, int[] nArray) {
        int n = 0;
        for (int i = 0; i < stringArray.length; i += 2) {
            String string2 = stringArray[i];
            if (string2.equals(string)) {
                return nArray[n];
            }
            ++n;
        }
        return 0;
    }

    private String getSelectedGroupName(String string, String[] stringArray) {
        for (int i = 0; i < stringArray.length; i += 2) {
            String string2 = stringArray[i];
            if (!string2.equals(string)) continue;
            return stringArray[i + 1];
        }
        return null;
    }

    public boolean isFunctionHelpDefined(String string, String string2) {
        String string3 = this.getFunctionHelp(string, string2);
        return !string3.equals(NO_HELP);
    }

    public String getFunctionHelp(String string, String string2) {
        if (string2.equals("devicereset")) {
            return this.getDeviceResetHelp();
        }
        if (string2.equals("geterror")) {
            return this.getGetErrorHelp();
        }
        if (string2.equals("selftest")) {
            return this.getSelfTestHelp();
        }
        String string3 = this.getParser().getMethodDefinition(string2, string).getDescription();
        string3 = string3 == null || string3.equals("") ? NO_HELP : this.updateHtml(string3);
        return string3;
    }

    private String getDeviceResetHelp() {
        return "<p>DEVICERESET Reset instrument.</p><p> </p><p>DEVICERESET(OBJ) resets the instrument associated with deviceobj object, OBJ. </p>";
    }

    private String getGetErrorHelp() {
        return "<p>GETERROR Check and return error message from instrument.</p><p> </p><p>MSG = GETERROR(OBJ) checks the instrument associated with deviceobj object, OBJ, for an error message and returns to MSG. The interpretation of MSG will vary based on the instrument.</p>";
    }

    private String getSelfTestHelp() {
        return "<p>SELFTEST Run the instrument self-test.</p><p> </p><p>OUT = SELFTEST(OBJ) runs the self-test for the instrument associated with deviceobj object, OBJ and returns the result of the self-test to OUT. OUT will vary based on the instrument.</p>";
    }

    public class FunctionTableModel
    extends AbstractTableModel {
        private static final long serialVersionUID = 1L;

        @Override
        public int getColumnCount() {
            return FunctionSweepPanel.this.headings.length;
        }

        @Override
        public int getRowCount() {
            if (FunctionSweepPanel.this.data == null) {
                return 0;
            }
            return FunctionSweepPanel.this.data.length;
        }

        @Override
        public String getColumnName(int n) {
            return FunctionSweepPanel.this.headings[n];
        }

        @Override
        public Object getValueAt(int n, int n2) {
            return FunctionSweepPanel.this.data[n][n2];
        }

        @Override
        public void setValueAt(Object object, int n, int n2) {
            ((FunctionSweepPanel)FunctionSweepPanel.this).data[n][n2] = object;
            this.fireTableCellUpdated(n, n2);
        }

        public Class<? extends Object> getColumnClass(int n) {
            return this.getValueAt(0, n).getClass();
        }

        @Override
        public boolean isCellEditable(int n, int n2) {
            if (n2 == 1) {
                return FALSE;
            }
            return TRUE;
        }
    }
}

