/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.instrument.util;

import com.mathworks.jmi.MatlabWorker;
import com.mathworks.mlservices.MLHelpServices;
import com.mathworks.mlservices.MLPrefsDialogServices;
import com.mathworks.mlwidgets.prefs.ConfirmationDialogPrefsPanel;
import com.mathworks.mwswing.FileExtensionFilter;
import com.mathworks.mwswing.FilePatternFilter;
import com.mathworks.mwswing.MJButton;
import com.mathworks.mwswing.MJCheckBox;
import com.mathworks.mwswing.MJFileChooserPerPlatform;
import com.mathworks.mwswing.MJLabel;
import com.mathworks.mwswing.MJOptionPane;
import com.mathworks.mwswing.MJPanel;
import com.mathworks.mwswing.MJRadioButton;
import com.mathworks.mwswing.MJTextField;
import com.mathworks.toolbox.instrument.Instrument;
import com.mathworks.toolbox.testmeas.util.TMException;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.ItemSelectable;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.File;
import java.util.ResourceBundle;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JOptionPane;
import javax.swing.border.Border;

public class PreferencePanel
extends MJPanel
implements ItemListener,
ActionListener {
    public static final long serialVersionUID = 0L;
    public static final int EDITOR_EDIT_FILES = 1;
    public static final int TESTER_EDIT_FILES = 3;
    public static final int DEVICE_MIN_PROPERTIES = 4;
    public static final int DEVICE_MIN_FUNCTIONS = 5;
    public static final int VXIPNP_STRING_ARG_LENGTH = 6;
    public static final int IVI_CUSTOM_CONFIG_STORE_LOCATION = 7;
    public static final int IVI_USE_MASTER_STORE = 8;
    public static final int ENABLE_IVI_C_INSTRUMENTS = 9;
    private static final boolean defaultEditFilesDontExist = true;
    private static final boolean defaultTesterEditFilesDontExist = true;
    private static final int defaultDeviceObjMinProperties = 0;
    private static final int defaultDeviceObjMinFunctions = 0;
    private static final int defaultVxipnpStringArgLength = 512;
    private static final boolean defaultIviUseMasterStore = true;
    public static final String MIDEDIT_SHOW_DNE_DIALOG_PROMPT = "InstrumentControl_MIDEDIT_DNE_Prompt";
    public static final String MIDTEST_SHOW_DNE_DIALOG_PROMPT = "InstrumentControl_MIDTEST_DNE_Prompt";
    protected static final ResourceBundle sResources = ResourceBundle.getBundle("com.mathworks.toolbox.instrument.util.resources.RES_INSTRUTIL");
    protected static final ResourceBundle ssResources = ResourceBundle.getBundle("com.mathworks.toolbox.instrument.util.resources.RES_INSTRUTIL_LOCALIZED");
    private static PreferencePanel preferencesPanel = null;
    private MJTextField minPropertiesTF;
    private MJTextField minFunctionsTF;
    private MJTextField vxipnpStringArgLengthTF;
    private MJTextField iviConfigStoreLocationTF;
    private MJRadioButton iviAlwaysUseMasterStoreRadio;
    private MJRadioButton iviUseSpecifiedStoreRadio;
    private MJButton iviLocateStoreButton;
    private MJCheckBox ivicInstrumentCheck;

    public static void registerPanel() {
        MLPrefsDialogServices.registerPanel((String)"Instrument Control Toolbox", (String)"com.mathworks.toolbox.instrument.util.PreferencePanel");
    }

    public static ConfirmationDialogPrefsPanel.DialogItem[] getDialogItems() {
        return new ConfirmationDialogPrefsPanel.DialogItem[]{new ConfirmationDialogPrefsPanel.DialogItem(ssResources.getString("General.PreferencePanel.ShowDialogDNEMIDEDIT.Message"), MIDEDIT_SHOW_DNE_DIALOG_PROMPT, "Instrument Control", true), new ConfirmationDialogPrefsPanel.DialogItem(ssResources.getString("General.PreferencePanel.ShowDialogDNEMIDTEST.Message"), MIDTEST_SHOW_DNE_DIALOG_PROMPT, "Instrument Control", true)};
    }

    public static MJPanel createPrefsPanel() {
        if (preferencesPanel == null) {
            preferencesPanel = new PreferencePanel();
        }
        preferencesPanel.updateValues();
        return preferencesPanel;
    }

    public static void commitPrefsChanges(boolean bl) {
        if (!bl) {
            return;
        }
        preferencesPanel.commitChanges();
    }

    public static boolean validatePrefsPanel() {
        if (PreferencePanel.preferencesPanel.iviUseSpecifiedStoreRadio.isSelected() && PreferencePanel.preferencesPanel.iviConfigStoreLocationTF.getText().length() == 0) {
            MJOptionPane.showMessageDialog((Component)((Object)preferencesPanel), (Object)sResources.getString("PreferencePanel.CustomStoreFile"), (String)"Instrument Control", (int)0);
            return false;
        }
        return true;
    }

    public static String[] getHelpInfo() {
        String[] stringArray = new String[]{MLHelpServices.getDocRoot() + "/toolbox/instrument/instrument.map", "general_preferences"};
        return stringArray;
    }

    private static boolean getBooleanPreference(int n) {
        String string = PreferencePanel.getToolboxPreference(n);
        return Boolean.valueOf(string);
    }

    private static String getToolboxPreference(int n) {
        switch (n) {
            case 4: {
                String string = Instrument.getPreferenceFile().read("DeviceObjectMinProperties");
                if (string.length() == 0) {
                    return Integer.toString(0);
                }
                return string;
            }
            case 5: {
                String string = Instrument.getPreferenceFile().read("DeviceObjectMinFunctions");
                if (string.length() == 0) {
                    return Integer.toString(0);
                }
                return string;
            }
            case 6: {
                String string = Instrument.getPreferenceFile().read("VxiPnpStringArgumentLength");
                if (string.length() == 0) {
                    return Integer.toString(512);
                }
                return string;
            }
            case 7: {
                String string = Instrument.getPreferenceFile().read("IviConfigStoreLocation");
                return string;
            }
            case 9: {
                String string = Instrument.getPreferenceFile().read("EnableIviCInstruments");
                return string;
            }
            case 8: {
                String string = Instrument.getPreferenceFile().read("IviUseMasterConfigStore");
                if (string.length() == 0) {
                    return Boolean.toString(true);
                }
                return string;
            }
            case 1: {
                String string = Instrument.getPreferenceFile().read("EditorEditFilesDontExist");
                if (string.length() == 0) {
                    return Boolean.toString(true);
                }
                return string;
            }
            case 3: {
                String string = Instrument.getPreferenceFile().read("TestToolCreateTestsDontExist");
                if (string.length() == 0) {
                    return Boolean.toString(true);
                }
                return string;
            }
        }
        return null;
    }

    private static void setToolboxPreference(int n, String string) throws TMException {
        switch (n) {
            case 4: {
                try {
                    Integer.parseInt(string);
                    Instrument.getPreferenceFile().update("DeviceObjectMinProperties", string);
                    break;
                }
                catch (NumberFormatException numberFormatException) {
                    throw new TMException(numberFormatException.getMessage());
                }
            }
            case 5: {
                try {
                    Integer.parseInt(string);
                    Instrument.getPreferenceFile().update("DeviceObjectMinFunctions", string);
                    break;
                }
                catch (NumberFormatException numberFormatException) {
                    throw new TMException(numberFormatException.getMessage());
                }
            }
            case 6: {
                try {
                    Integer.parseInt(string);
                    Instrument.getPreferenceFile().update("VxiPnpStringArgumentLength", string);
                    break;
                }
                catch (NumberFormatException numberFormatException) {
                    throw new TMException(numberFormatException.getMessage());
                }
            }
            case 7: {
                Instrument.getPreferenceFile().update("IviConfigStoreLocation", string);
                break;
            }
            case 9: {
                Instrument.getPreferenceFile().update("EnableIviCInstruments", string);
                break;
            }
            case 8: {
                Instrument.getPreferenceFile().update("IviUseMasterConfigStore", string);
                break;
            }
            case 1: {
                Instrument.getPreferenceFile().update("EditorEditFilesDontExist", string);
                break;
            }
            case 3: {
                Instrument.getPreferenceFile().update("EditorEditFilesDontExist", string);
                break;
            }
            default: {
                throw new TMException("Invalid preference name.");
            }
        }
    }

    private PreferencePanel() {
        this.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 12, 2, new Insets(0, 0, 0, 0), 0, 0);
        this.add((Component)this.createDeviceObjectPanel(), gridBagConstraints);
        ++gridBagConstraints.gridy;
        this.add((Component)this.createIviPanel(), gridBagConstraints);
        ++gridBagConstraints.gridy;
        this.add((Component)this.createIviCInstrumentPanel(), gridBagConstraints);
        ++gridBagConstraints.gridy;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        this.add((Component)new MJPanel(), gridBagConstraints);
    }

    private MJPanel createIviCInstrumentPanel() {
        MJPanel mJPanel = new MJPanel((LayoutManager)new BorderLayout());
        mJPanel.setBorder(this.titledBorder("IVI Instruments"));
        this.ivicInstrumentCheck = new MJCheckBox(sResources.getString("PreferencaPanel.EnableIviCInstruments"));
        this.ivicInstrumentCheck.addItemListener((ItemListener)this);
        mJPanel.add((Component)this.ivicInstrumentCheck, (Object)"West");
        return mJPanel;
    }

    private MJPanel createDeviceObjectPanel() {
        MJPanel mJPanel = new MJPanel((LayoutManager)new GridBagLayout());
        mJPanel.setBorder(this.titledBorder("Device Objects"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 5, 5, 5), 0, 0);
        mJPanel.add((Component)new MJLabel(sResources.getString("PreferencaPanel.MinimumGroupProperties")), (Object)gridBagConstraints);
        this.minPropertiesTF = new MJTextField("", 4);
        ++gridBagConstraints.gridx;
        gridBagConstraints.insets = new Insets(0, 0, 5, 5);
        mJPanel.add((Component)this.minPropertiesTF, (Object)gridBagConstraints);
        gridBagConstraints.gridx = 0;
        ++gridBagConstraints.gridy;
        gridBagConstraints.insets = new Insets(0, 5, 5, 5);
        mJPanel.add((Component)new MJLabel(sResources.getString("PreferencaPanel.MinimumFunctionProperties")), (Object)gridBagConstraints);
        this.minFunctionsTF = new MJTextField("", 4);
        ++gridBagConstraints.gridx;
        gridBagConstraints.insets = new Insets(0, 0, 5, 5);
        mJPanel.add((Component)this.minFunctionsTF, (Object)gridBagConstraints);
        gridBagConstraints.gridx = 0;
        ++gridBagConstraints.gridy;
        gridBagConstraints.insets = new Insets(0, 5, 0, 5);
        mJPanel.add((Component)new MJLabel(sResources.getString("PreferencaPanel.DefaultCharArrayLength")), (Object)gridBagConstraints);
        this.vxipnpStringArgLengthTF = new MJTextField("", 4);
        ++gridBagConstraints.gridx;
        gridBagConstraints.insets = new Insets(0, 0, 0, 5);
        mJPanel.add((Component)this.vxipnpStringArgLengthTF, (Object)gridBagConstraints);
        gridBagConstraints.gridx = 0;
        ++gridBagConstraints.gridy;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        gridBagConstraints.fill = 1;
        mJPanel.add((Component)new MJPanel(), (Object)gridBagConstraints);
        return mJPanel;
    }

    private MJPanel createIviPanel() {
        MJPanel mJPanel = new MJPanel((LayoutManager)new GridBagLayout());
        mJPanel.setBorder(this.titledBorder("IVI Configuration Store"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 5, 5, 5), 0, 0);
        this.iviAlwaysUseMasterStoreRadio = new MJRadioButton(sResources.getString("PreferencaPanel.MasterConfigurationStore"));
        this.iviAlwaysUseMasterStoreRadio.addItemListener((ItemListener)this);
        gridBagConstraints.gridwidth = 0;
        mJPanel.add((Component)this.iviAlwaysUseMasterStoreRadio, (Object)gridBagConstraints);
        ++gridBagConstraints.gridy;
        gridBagConstraints.gridwidth = 1;
        this.iviUseSpecifiedStoreRadio = new MJRadioButton(sResources.getString("PreferencaPanel.ConfigurationStore"));
        mJPanel.add((Component)this.iviUseSpecifiedStoreRadio, (Object)gridBagConstraints);
        this.iviConfigStoreLocationTF = new MJTextField("");
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add((AbstractButton)this.iviAlwaysUseMasterStoreRadio);
        buttonGroup.add((AbstractButton)this.iviUseSpecifiedStoreRadio);
        ++gridBagConstraints.gridx;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 0, 5, 5);
        mJPanel.add((Component)this.iviConfigStoreLocationTF, (Object)gridBagConstraints);
        this.iviLocateStoreButton = new MJButton("...");
        this.iviLocateStoreButton.setSize(this.iviLocateStoreButton.getWidth(), this.iviConfigStoreLocationTF.getHeight());
        this.iviLocateStoreButton.setMargin(new Insets(0, 0, 0, 0));
        this.iviLocateStoreButton.addActionListener((ActionListener)this);
        ++gridBagConstraints.gridx;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = new Insets(0, 0, 5, 5);
        mJPanel.add((Component)this.iviLocateStoreButton, (Object)gridBagConstraints);
        return mJPanel;
    }

    private Border titledBorder(String string) {
        return BorderFactory.createTitledBorder(string);
    }

    private void updateValues() {
        this.minPropertiesTF.setText(PreferencePanel.getToolboxPreference(4));
        this.minFunctionsTF.setText(PreferencePanel.getToolboxPreference(5));
        this.vxipnpStringArgLengthTF.setText(PreferencePanel.getToolboxPreference(6));
        String string = PreferencePanel.getToolboxPreference(7);
        this.iviConfigStoreLocationTF.setText(string);
        if (PreferencePanel.getBooleanPreference(8) || string.length() == 0) {
            this.iviAlwaysUseMasterStoreRadio.setSelected(true);
        } else {
            this.iviUseSpecifiedStoreRadio.setSelected(true);
        }
        boolean bl = PreferencePanel.getToolboxPreference(9).equals("enabled");
        this.ivicInstrumentCheck.setSelected(bl);
    }

    private void commitChanges() {
        try {
            PreferencePanel.setToolboxPreference(4, this.minPropertiesTF.getText());
        }
        catch (TMException tMException) {
            // empty catch block
        }
        try {
            PreferencePanel.setToolboxPreference(5, this.minFunctionsTF.getText());
        }
        catch (TMException tMException) {
            // empty catch block
        }
        try {
            PreferencePanel.setToolboxPreference(6, this.vxipnpStringArgLengthTF.getText());
        }
        catch (TMException tMException) {
            // empty catch block
        }
        boolean bl = this.iviAlwaysUseMasterStoreRadio.isSelected();
        try {
            if (bl) {
                PreferencePanel.setToolboxPreference(7, "");
                PreferencePanel.setToolboxPreference(8, Boolean.toString(bl));
            } else {
                PreferencePanel.setToolboxPreference(7, this.iviConfigStoreLocationTF.getText());
                PreferencePanel.setToolboxPreference(8, Boolean.toString(bl));
            }
        }
        catch (TMException tMException) {
            // empty catch block
        }
        try {
            String string = this.ivicInstrumentCheck.isSelected() ? "enabled" : "disabled";
            PreferencePanel.setToolboxPreference(9, string);
        }
        catch (TMException tMException) {
            // empty catch block
        }
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        File file = new File(this.iviConfigStoreLocationTF.getText());
        MJFileChooserPerPlatform mJFileChooserPerPlatform = new MJFileChooserPerPlatform(file);
        mJFileChooserPerPlatform.addChoosableFileFilter((FilePatternFilter)new FileExtensionFilter("IVI configuration store file", "xml", true));
        mJFileChooserPerPlatform.showOpenDialog((Component)((Object)this));
        if (mJFileChooserPerPlatform.getState() == 0) {
            this.iviConfigStoreLocationTF.setText(mJFileChooserPerPlatform.getSelectedFile().getAbsolutePath());
        }
    }

    @Override
    public void itemStateChanged(ItemEvent itemEvent) {
        ItemSelectable itemSelectable = itemEvent.getItemSelectable();
        if (itemSelectable == this.ivicInstrumentCheck) {
            if (itemEvent.getStateChange() == 1) {
                NICPInstallationChecker nICPInstallationChecker = new NICPInstallationChecker();
                nICPInstallationChecker.start();
            }
        } else if (itemEvent.getStateChange() == 1) {
            this.iviConfigStoreLocationTF.setBackground(this.iviConfigStoreLocationTF.getParent().getBackground());
            this.iviConfigStoreLocationTF.setEnabled(false);
            this.iviLocateStoreButton.setEnabled(false);
        } else {
            this.iviConfigStoreLocationTF.setBackground(this.minPropertiesTF.getBackground());
            this.iviConfigStoreLocationTF.setEnabled(true);
            this.iviLocateStoreButton.setEnabled(true);
        }
    }

    public class NICPInstallationChecker
    extends MatlabWorker {
        private final Object[] matlabArgs = new Object[]{"privateIviCInstrumentHelper", "checkNICPInstallation"};

        public void runOnAWTEventDispatchThread(Object object) {
            if (object == null) {
                return;
            }
            String string = (String)object;
            if (string.equalsIgnoreCase("noNICPInstalled")) {
                PreferencePanel.this.ivicInstrumentCheck.setSelected(false);
                JOptionPane.showMessageDialog(null, "Please install National Instrument Class Compliant package first!", "", 2);
            }
        }

        public Object runOnMatlabThread() throws Exception {
            Object object = null;
            try {
                object = NICPInstallationChecker.feval((String)"instrgate", (Object[])this.matlabArgs, (int)1, (boolean)false);
            }
            catch (Exception exception) {
                object = exception.getMessage();
            }
            return object;
        }
    }
}

