/*
 * Decompiled with CFR 0.152.
 */
package ice.pilots.html4;

import ice.debug.Debug;
import ice.pilots.html4.FramesetInfo;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;

class FramesDivider
implements MouseListener,
MouseMotionListener {
    private FramesetInfo framesetInfo;
    private boolean isdraged = false;
    private Point pressedPoint;
    int x_width = 4;
    int y_width = 4;
    int moved_X = 0;
    int moved_Y = 0;
    Component component = null;

    FramesDivider(Component component) {
        this.component = component;
    }

    void dispose() {
        if (this.component != null) {
            this.component.removeMouseListener(this);
            this.component.removeMouseListener(this);
            Container container = this.component.getParent();
            if (container != null) {
                container.remove(this.component);
            }
        }
        this.framesetInfo = null;
        this.pressedPoint = null;
        this.component = null;
    }

    public void mouseEntered(MouseEvent mouseEvent) {
        if (this.component != null) {
            if (this.framesetInfo.getOrientation() == 1) {
                Cursor cursor = new Cursor(8);
                this.component.setCursor(cursor);
            } else {
                Cursor cursor = new Cursor(11);
                this.component.setCursor(cursor);
            }
        }
    }

    public void mousePressed(MouseEvent mouseEvent) {
        if (this.component != null) {
            Cursor cursor = new Cursor(13);
            this.component.setCursor(cursor);
            this.pressedPoint = mouseEvent.getPoint();
        }
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        if (this.component != null) {
            if (this.isdraged) {
                if (this.framesetInfo.getOrientation() == 1) {
                    this.framesetInfo.dividerMoved(mouseEvent.getPoint().y - this.pressedPoint.y, this);
                } else {
                    this.framesetInfo.dividerMoved(mouseEvent.getPoint().x - this.pressedPoint.x, this);
                }
            }
            Cursor cursor = new Cursor(0);
            this.component.setCursor(cursor);
            this.isdraged = false;
        }
    }

    Component getComponent() {
        return this.component;
    }

    void setProperty(String string, String string2) {
        block7: {
            if (string.equalsIgnoreCase("frameborder")) {
                if (string2.equalsIgnoreCase("no") || string2.equalsIgnoreCase("0")) {
                    this.x_width = 0;
                    this.y_width = 0;
                }
            } else if (string.equalsIgnoreCase("border")) {
                string2 = string2.trim();
                int n = string2.length();
                for (int i = 0; i != n; ++i) {
                    char c = string2.charAt(i);
                    if ('0' <= c && c <= '9') continue;
                    n = i;
                    string2 = string2.substring(0, i);
                    break;
                }
                try {
                    this.y_width = this.x_width = Integer.parseInt(string2);
                }
                catch (Exception exception) {
                    if (!Debug.trace) break block7;
                    Debug.trace((String)("Bad frame border value: " + string2));
                }
            }
        }
    }

    public void mouseDragged(MouseEvent mouseEvent) {
        this.isdraged = true;
    }

    void setFramesetInfo(FramesetInfo framesetInfo) {
        this.framesetInfo = framesetInfo;
    }

    public void mouseMoved(MouseEvent mouseEvent) {
    }

    public void mouseClicked(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }
}

