/*
 * Decompiled with CFR 0.152.
 */
package ice.pilots.html4;

import ice.pilots.html4.BlockBox;
import ice.pilots.html4.BoxList;
import ice.pilots.html4.CSSAttribs;
import ice.pilots.html4.CSSBox;
import ice.pilots.html4.CSSLayout;
import ice.pilots.html4.CSSRect;
import ice.pilots.html4.DElement;
import ice.pilots.html4.DNode;
import ice.pilots.html4.FloatBox;
import ice.pilots.html4.FloatManager;
import ice.pilots.html4.FloatPainter;
import ice.pilots.html4.InlineBox;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.Enumeration;
import java.util.Vector;

class PositionedBox
extends BlockBox {
    Vector children = new Vector();
    BoxList list;
    boolean dummy = false;
    private CSSBox firstBlock;
    CSSBox previousSibling;
    private FloatPainter floatPainter = new FloatPainter();

    PositionedBox(DElement dElement, CSSAttribs cSSAttribs, CSSLayout cSSLayout, byte by, CSSBox cSSBox) {
        super(dElement, cSSAttribs, cSSLayout, by);
        if (cSSAttribs.margin_left != -123456) {
            if (cSSAttribs.margin_left != 0) {
                cSSAttribs.left = cSSAttribs.left == -123456 ? cSSAttribs.margin_left : (cSSAttribs.left += cSSAttribs.margin_left);
                cSSAttribs.margin_left = -123456;
            }
        } else if (cSSAttribs.margin_right != -123456 && cSSAttribs.margin_right != 0) {
            cSSAttribs.right = cSSAttribs.right == -123456 ? cSSAttribs.margin_right : (cSSAttribs.right += cSSAttribs.margin_right);
            cSSAttribs.margin_right = -123456;
        }
        if (cSSAttribs.margin_top != -123456) {
            if (cSSAttribs.margin_top != 0) {
                cSSAttribs.top = cSSAttribs.top == -123456 ? cSSAttribs.margin_top : (cSSAttribs.top += cSSAttribs.margin_top);
                cSSAttribs.margin_top = -123456;
            }
        } else if (cSSAttribs.margin_bottom != -123456 && cSSAttribs.margin_bottom != 0) {
            cSSAttribs.bottom = cSSAttribs.bottom == -123456 ? cSSAttribs.margin_bottom : (cSSAttribs.bottom += cSSAttribs.margin_bottom);
            cSSAttribs.margin_bottom = -123456;
        }
        this.floatPainter = new FloatPainter();
        this.previousSibling = cSSBox;
    }

    PositionedBox(boolean bl, CSSBox cSSBox, BoxList boxList) {
        super(null, null, null, (byte)0);
        this.dummy = bl;
        if (cSSBox != null) {
            CSSAttribs cSSAttribs = cSSBox.css;
            this.css = new CSSAttribs(cSSBox.cssLayout.sdata, null);
            this.css.position = cSSAttribs.position;
            this.css.left = cSSAttribs.left;
            if (cSSAttribs.margin_left != -123456) {
                this.css.left += cSSAttribs.margin_left;
            }
            this.css.top = cSSAttribs.top;
            this.css.right = cSSAttribs.right;
            if (cSSAttribs.margin_right != -123456) {
                this.css.right += cSSAttribs.margin_right;
            }
            this.css.bottom = cSSAttribs.bottom;
            this.css.display = cSSAttribs.display;
            this.css.width = cSSAttribs.width;
            this.css.percentage_flag = cSSAttribs.percentage_flag;
            this.css.z_index = cSSAttribs.z_index;
        }
        this.firstBlock = cSSBox;
        this.list = boxList;
    }

    void propagateVisibility(short s, boolean bl) {
        if (this.firstBlock != null) {
            this.firstBlock.propagateVisibility(s, bl);
        } else {
            super.propagateVisibility(s, bl);
            Enumeration enumeration = this.children.elements();
            while (enumeration.hasMoreElements()) {
                CSSBox cSSBox = (CSSBox)enumeration.nextElement();
                cSSBox.propagateVisibility(s, true);
            }
        }
    }

    void changeTopAndLeft(int n, int n2) {
        this.oy += n2;
        this.ox += n;
        Enumeration enumeration = this.children.elements();
        while (enumeration.hasMoreElements()) {
            CSSBox cSSBox = (CSSBox)enumeration.nextElement();
            if (cSSBox instanceof PositionedBox) {
                ((PositionedBox)cSSBox).changeTopAndLeft(n, n2);
                continue;
            }
            cSSBox.oy += n2;
            cSSBox.ox += n;
        }
    }

    void setParentBox(CSSBox cSSBox) {
        super.setParentBox(cSSBox);
        if (this.parentBox.getType() == 0 && this.css.position == 126) {
            InlineBox inlineBox = (InlineBox)this.parentBox;
            this.parentBox = inlineBox.inline2Block();
        }
    }

    boolean substitute(CSSBox cSSBox, CSSBox cSSBox2) {
        if (this.firstBlock == cSSBox) {
            this.firstBlock = cSSBox2;
            return true;
        }
        for (int i = 0; i < this.children.size(); ++i) {
            PositionedBox positionedBox = (PositionedBox)this.children.elementAt(i);
            if (positionedBox == cSSBox) {
                ((PositionedBox)cSSBox2).list = this.list;
                this.children.setElementAt(cSSBox2, i);
                return true;
            }
            if (!positionedBox.substitute(cSSBox, cSSBox2)) continue;
            return true;
        }
        return false;
    }

    void clear() {
        this.firstBlock = null;
        for (int i = 0; i < this.children.size(); ++i) {
            PositionedBox positionedBox = (PositionedBox)this.children.elementAt(i);
            positionedBox.clear();
        }
        this.children.removeAllElements();
    }

    private CSSBox do_getBoxAt(int n, int n2, Point point, CSSBox cSSBox) {
        Object object;
        CSSBox cSSBox2;
        int n3 = cSSBox.ox;
        int n4 = cSSBox.oy;
        int n5 = cSSBox.width;
        int n6 = cSSBox.height;
        if (cSSBox.getType() == 0) {
            cSSBox2 = (InlineBox)cSSBox;
            object = new Rectangle();
            cSSBox2.findBoundingBox((Rectangle)object);
            n3 = ((Rectangle)object).x;
            n4 = ((Rectangle)object).y;
            n5 = ((Rectangle)object).width;
            n6 = ((Rectangle)object).height;
        }
        cSSBox2 = null;
        object = cSSBox.css.clip;
        if (object != null) {
            if (n >= n3 + ((CSSRect)object).left && n2 >= n4 + ((CSSRect)object).top && n < n3 + ((CSSRect)object).right && n2 < n4 + ((CSSRect)object).bottom) {
                cSSBox2 = cSSBox.getBoxAt(n - n3, n2 - n4, point);
            }
        } else if (n >= n3 && n2 >= n4 && n < n3 + n5 && n2 < n4 + n6) {
            cSSBox2 = cSSBox.getBoxAt(n - n3, n2 - n4, point);
        }
        return cSSBox2;
    }

    CSSBox _getBoxAt(int n, int n2, Point point) {
        CSSBox cSSBox = null;
        CSSBox cSSBox2 = this.firstBlock;
        if (cSSBox2 == null) {
            for (int i = this.children.size() - 1; i >= 0 && cSSBox == null; --i) {
                PositionedBox positionedBox = (PositionedBox)this.children.elementAt(i);
                cSSBox = positionedBox._getBoxAt(n, n2, point);
            }
        }
        if (!this.dummy) {
            cSSBox2 = this;
        }
        if (cSSBox == null && cSSBox2 != null && this._isVisible(cSSBox2) && !this.isClippedByParents(n, n2, cSSBox2)) {
            cSSBox = this.do_getBoxAt(n, n2, point, cSSBox2);
        }
        return cSSBox;
    }

    private void do_paint(Graphics graphics, CSSBox cSSBox) {
        if (cSSBox != null && this._isVisible(cSSBox) && cSSBox.getType() != 0) {
            Graphics graphics2 = graphics.create();
            PositionedBox.applyClippingFromParents(graphics2, cSSBox);
            graphics2.clipRect(cSSBox.ox, cSSBox.oy, cSSBox.width, cSSBox.height);
            cSSBox.cssLayout.outlinePainter.drawBox(graphics2, cSSBox, cSSBox.ox, cSSBox.oy);
            graphics2.dispose();
        }
    }

    void _paint(Graphics graphics) {
        PositionedBox positionedBox;
        int n;
        if (this.firstBlock != null) {
            this.do_paint(graphics, this.firstBlock);
            return;
        }
        int n2 = this.children.size();
        for (n = 0; n < n2; ++n) {
            positionedBox = (PositionedBox)this.children.elementAt(n);
            if (positionedBox.css.z_index >= 0) break;
            positionedBox._paint(graphics);
        }
        if (!this.dummy) {
            this.do_paint(graphics, this);
        }
        while (n < n2) {
            positionedBox = (PositionedBox)this.children.elementAt(n);
            positionedBox._paint(graphics);
            ++n;
        }
    }

    private boolean _isVisible(CSSBox cSSBox) {
        while (cSSBox != null) {
            if (cSSBox.css.position != 124 && (cSSBox.css.misc & 1) == 0) {
                return false;
            }
            cSSBox = cSSBox.getParentBox();
        }
        return true;
    }

    private static void applyClippingFromParents(Graphics graphics, CSSBox cSSBox) {
        for (cSSBox = cSSBox.getParentBox(); cSSBox != null; cSSBox = cSSBox.getParentBox()) {
            CSSRect cSSRect;
            if (cSSBox.css.position == 124 || (cSSRect = cSSBox.css.clip) == null) continue;
            graphics.clipRect(cSSBox.ox + cSSRect.left, cSSBox.oy + cSSRect.top, cSSRect.right - cSSRect.left, cSSRect.bottom - cSSRect.top);
        }
    }

    private boolean isClippedByParents(int n, int n2, CSSBox cSSBox) {
        for (cSSBox = cSSBox.getParentBox(); cSSBox != null; cSSBox = cSSBox.getParentBox()) {
            CSSRect cSSRect;
            if (cSSBox.css.position == 124 || (cSSRect = cSSBox.css.clip) == null || n >= cSSBox.ox + cSSRect.left && n2 >= cSSBox.oy + cSSRect.top && n < cSSBox.ox + cSSRect.right && n2 < cSSBox.oy + cSSRect.bottom) continue;
            return true;
        }
        return false;
    }

    void layout(CSSBox cSSBox) {
        if (cSSBox == null) {
            return;
        }
        if (!this.dummy || this.firstBlock != null) {
            if (this.css.position == 125) {
                this.layoutRelativeBox();
            } else if (this.css.position == 126) {
                this.layoutAbsoluteBox(cSSBox.width, cSSBox.height);
            }
        }
        if (this.firstBlock == null) {
            for (int i = 0; i < this.children.size(); ++i) {
                PositionedBox positionedBox = (PositionedBox)this.children.elementAt(i);
                positionedBox.layout(cSSBox);
            }
        }
    }

    CSSBox findCSSBox(DNode dNode) {
        if (this.firstBlock != null) {
            if (this.firstBlock.getDomNode() == dNode) {
                return this.firstBlock;
            }
            return null;
        }
        if (this.getDomNode() == dNode) {
            return this;
        }
        for (int i = 0; i < this.children.size(); ++i) {
            PositionedBox positionedBox = (PositionedBox)this.children.elementAt(i);
            CSSBox cSSBox = positionedBox.findCSSBox(dNode);
            if (cSSBox == null) continue;
            return cSSBox;
        }
        return null;
    }

    PositionedBox findBox(CSSBox cSSBox) {
        PositionedBox positionedBox;
        if (this.firstBlock != null) {
            return null;
        }
        if (cSSBox == this) {
            return this;
        }
        PositionedBox positionedBox2 = null;
        for (int i = 0; i < this.children.size() && (positionedBox2 = (positionedBox = (PositionedBox)this.children.elementAt(i)).findBox(cSSBox)) == null; ++i) {
        }
        return positionedBox2;
    }

    void add(CSSBox cSSBox, CSSBox cSSBox2) {
        PositionedBox positionedBox = null;
        if (!(cSSBox instanceof PositionedBox)) {
            positionedBox = new PositionedBox(true, cSSBox, this.list);
        } else {
            positionedBox = (PositionedBox)cSSBox;
            positionedBox.list = this.list;
        }
        positionedBox.setParentBox(cSSBox2);
        for (int i = 0; i < this.children.size(); ++i) {
            PositionedBox positionedBox2 = (PositionedBox)this.children.elementAt(i);
            if (cSSBox.css.z_index >= positionedBox2.css.z_index) continue;
            this.children.insertElementAt(positionedBox, i);
            return;
        }
        this.children.addElement(positionedBox);
    }

    private void layoutRelativeBox() {
        CSSBox cSSBox = this.firstBlock != null ? this.firstBlock : this;
        int n = 0;
        int n2 = 0;
        if (cSSBox.css.left != -123456) {
            n = cSSBox.css.left;
        }
        if (cSSBox.css.right != -123456 && Math.abs(cSSBox.css.right) > Math.abs(n)) {
            n = -cSSBox.css.right;
        }
        if (cSSBox.css.top != -123456) {
            n2 = cSSBox.css.top;
        }
        if (cSSBox.css.bottom != -123456 && Math.abs(cSSBox.css.bottom) > Math.abs(n2)) {
            n2 = -cSSBox.css.bottom;
        }
        if (cSSBox.getType() == 0) {
            InlineBox inlineBox = (InlineBox)cSSBox;
            inlineBox.relX = n;
            inlineBox.relY = n2;
        } else {
            Point point = new Point();
            point.x = cSSBox.ox;
            point.y = cSSBox.oy;
            if (cSSBox.parentBox != null) {
                cSSBox.parentBox.findAbsolutePosition(point);
            }
            cSSBox.ox = point.x + n;
            cSSBox.oy = point.y + n2;
            if (cSSBox.parentBox != null && cSSBox.parentBox.minWidth == cSSBox.parentBox.maxWidth) {
                cSSBox.width = cSSBox.maxWidth;
            }
        }
    }

    void layoutAbsoluteBox(int n, int n2) {
        CSSBox cSSBox = this.firstBlock != null ? this.firstBlock : this;
        Rectangle rectangle = new Rectangle();
        CSSBox cSSBox2 = cSSBox.parentBox;
        if (cSSBox2 == null) {
            cSSBox2 = this.parentBox;
        } else {
            while (cSSBox2 != null && cSSBox2.css.position == 124 && cSSBox2.parentBox != null) {
                cSSBox2 = cSSBox2.parentBox;
            }
        }
        cSSBox2.findBoundingBox(rectangle);
        int n3 = 0;
        int n4 = 0;
        if (cSSBox instanceof PositionedBox) {
            CSSBox cSSBox3 = cSSBox;
            CSSBox cSSBox4 = ((PositionedBox)cSSBox3).previousSibling;
            if (cSSBox4 != null) {
                Rectangle rectangle2 = new Rectangle();
                if (cSSBox4.next != null) {
                    cSSBox4 = cSSBox4.next;
                }
                if (cSSBox4.getType() == 2) {
                    cSSBox4 = ((FloatBox)cSSBox4).getBlock();
                }
                cSSBox4.findBoundingBox(rectangle2);
                n4 = rectangle2.y - rectangle.y + rectangle2.height;
            }
        }
        int n5 = 0;
        if (cSSBox.css.left != -123456) {
            n5 = PositionedBox.getValueOrPercentage(cSSBox.css.percentage_flag, 16, cSSBox.css.left, cSSBox2.width);
        }
        int n6 = 0;
        if (cSSBox.css.right != -123456) {
            n6 = PositionedBox.getValueOrPercentage(cSSBox.css.percentage_flag, 131072, cSSBox.css.right, cSSBox2.width);
        }
        int n7 = 0;
        if (cSSBox.css.top != -123456) {
            n7 = PositionedBox.getValueOrPercentage(cSSBox.css.percentage_flag, 524288, cSSBox.css.top, cSSBox2.width);
        }
        int n8 = 0;
        if (cSSBox.css.bottom != -123456) {
            n8 = PositionedBox.getValueOrPercentage(cSSBox.css.percentage_flag, 4, cSSBox.css.bottom, cSSBox2.width);
        }
        int n9 = 0;
        if (cSSBox.css.width != -123456) {
            n9 = PositionedBox.getValueOrPercentage(cSSBox.css.percentage_flag, 0x100000, cSSBox.css.width, cSSBox2.width);
        }
        int n10 = 0;
        if (cSSBox.css.height != -123456) {
            n10 = PositionedBox.getValueOrPercentage(cSSBox.css.percentage_flag, 8, cSSBox.css.height, cSSBox2.width);
        }
        cSSBox.calcMinMaxWidths();
        int n11 = 0;
        int n12 = 0;
        if (this.css.width == -123456) {
            n11 = n5 + n6;
        }
        if (this.css.height == -123456) {
            n12 = n7 + n8;
        }
        if (cSSBox instanceof PositionedBox) {
            int n13 = cSSBox2.width;
            int n14 = cSSBox2.height;
            if (n13 == 0 || n14 == 0) {
                n13 = n;
                n14 = n2;
            }
            n13 -= n11;
            n14 -= n12;
            if (cSSBox.css.width == -123456) {
                if (n13 > cSSBox.maxWidth) {
                    n13 = cSSBox.maxWidth;
                }
                if (n13 < cSSBox.minWidth) {
                    n13 = cSSBox.minWidth;
                }
            }
            ((PositionedBox)cSSBox).layout(n13, n14);
        } else {
            FloatManager floatManager = new FloatManager(0, n9);
            cSSBox.layout(n9, n10, floatManager);
            cSSBox.height += floatManager.skipTill(n9);
        }
        cSSBox.ox = cSSBox2.ox + cSSBox2.css.margin_left + n3;
        if (this.css.left != -123456) {
            cSSBox.ox += n5;
        } else if (this.css.right != -123456) {
            cSSBox.ox += cSSBox2.width - n6 - cSSBox.width;
        }
        cSSBox.oy = cSSBox2.oy;
        cSSBox.oy = this.css.top != -123456 ? (cSSBox.oy += n7) : (this.css.bottom != -123456 ? (cSSBox.oy += cSSBox2.height - n8 - cSSBox.height) : (cSSBox.oy += n4));
        if (n10 >= 0) {
            if (cSSBox.height > n10) {
                if (n7 == -123456) {
                    cSSBox.oy -= cSSBox.height - n10;
                }
            } else {
                cSSBox.height = n10;
            }
        }
        if (cSSBox.ox + cSSBox.width > this.list.maxWidth) {
            this.list.maxWidth = cSSBox.ox + cSSBox.width;
        }
        if (cSSBox.oy + cSSBox.height > this.list.maxHeight) {
            this.list.maxHeight = cSSBox.oy + cSSBox.height;
        }
    }

    void dispose() {
        super.dispose();
        this.firstBlock = null;
        for (int i = 0; i < this.children.size(); ++i) {
            PositionedBox positionedBox = (PositionedBox)this.children.elementAt(i);
            positionedBox.dispose();
        }
        this.children.removeAllElements();
    }

    CSSBox getBoxAt(int n, int n2, Point point) {
        CSSBox cSSBox = this.floatPainter.getBoxAt(n, n2, point);
        if (cSSBox == null) {
            cSSBox = super.getBoxAt(n, n2, point);
        }
        return cSSBox;
    }

    void layout(int n, int n2) {
        this.floatPainter.clear();
        FloatManager floatManager = new FloatManager(0, n);
        super.layout(n, n2, floatManager);
        this.height += floatManager.skipTill(n);
        CSSBox cSSBox = floatManager.getFirstFloater();
        if (cSSBox != null) {
            this.floatPainter.add(cSSBox);
        }
    }

    public void paint(Graphics graphics) {
        super.paint(graphics);
        this.floatPainter.paintNegativeZ_Indices(graphics);
        this.floatPainter.paintPositiveZ_Indices(graphics);
    }
}

