/*
 * Decompiled with CFR 0.152.
 */
package ice.pilots.html4.awt;

import ice.debug.Debug;
import ice.pilots.html4.ComponentFactory;
import ice.pilots.html4.FocusManager;
import ice.pilots.html4.Html4DocumentAccess;
import ice.pilots.html4.ObjectBox;
import ice.pilots.html4.awt.DocView;
import ice.pilots.html4.awt.FormInputText;
import ice.pilots.html4.awt.FormTextArea;
import ice.pilots.html4.awt.Movable;
import ice.util.Defs;
import ice.util.JavaVersion;
import ice.util.awt.AWTEventListenerCallback;
import java.awt.AWTEvent;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Panel;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Scrollbar;
import java.awt.event.InputEvent;
import java.awt.event.MouseEvent;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;

class DocPanel
extends Panel
implements AWTEventListenerCallback {
    private static final boolean isMacOS = Defs.sysProperty((String)"os.name").startsWith("Mac OS");
    private DocView docView;
    int sx = 0;
    int sy = 0;
    int nsx = 0;
    int nsy = 0;
    private Image offscreenBuffer = null;
    boolean reflow_req = false;
    private boolean clear_req = false;
    private boolean childrenHidden = false;
    private int scrollHeight;
    private int scrollTimeout;
    private int lastDraggedY;
    private int scrollMouseX = -1;
    private int scrollMouseY = -1;
    private int selectMouseX = -1;
    private int selectMouseY = -1;
    private int selectButton = 0;
    private int scrollButton = 1;
    private boolean reclaimFocusOnScroll = false;
    private long scrollTimestamp = 0L;
    private boolean childrenValidated;
    private Object v14FocusKeyListener;
    boolean preventOptimisedPaintOnce = false;

    DocPanel(DocView docView) {
        this.docView = docView;
        this.enableEvents(60L);
        this.setLayout(null);
        this.scrollHeight = Defs.sysPropertyInt((String)"ice.pilots.html4.scrollHeight", (int)14);
        this.scrollTimeout = Defs.sysPropertyInt((String)"ice.pilots.html4.scrollTimeout", (int)100);
        this.reclaimFocusOnScroll = Defs.sysPropertyBoolean((String)"ice.pilots.html4.awt.reclaimFocus");
        String string = Defs.sysProperty((String)"ice.pilots.html4.selectButton");
        if (!docView.enableTextSelection) {
            string = "none";
        }
        this.selectButton = ComponentFactory.parseButton(string, this.selectButton);
        string = Defs.sysProperty((String)"ice.pilots.html4.scrollButton");
        this.scrollButton = ComponentFactory.parseButton(string, this.scrollButton);
        if (JavaVersion.isV14orGreater()) {
            this.addEventListenerReflectively();
        }
    }

    public boolean isFocusTraversable() {
        return true;
    }

    public Component add(Component component) {
        component.setVisible(false);
        if (!isMacOS) {
            super.add(component);
            return component;
        }
        if (component instanceof FormInputText || component instanceof FormTextArea) {
            try {
                Class<?> clazz = component.getClass();
                Class[] classArray = new Class[]{Boolean.TYPE};
                Method method = clazz.getMethod("enableInputMethods", classArray);
                Object[] objectArray = new Object[]{Boolean.TRUE};
                Object[] objectArray2 = new Object[]{Boolean.FALSE};
                method.invoke((Object)component, objectArray2);
                super.add(component);
                method.invoke((Object)component, objectArray);
            }
            catch (Exception exception) {
                Debug.ex((Throwable)exception);
            }
        } else {
            super.add(component);
        }
        return component;
    }

    public void removeNotify() {
        if (this.offscreenBuffer != null) {
            this.offscreenBuffer.flush();
            this.offscreenBuffer = null;
        }
        super.removeNotify();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void hideChildren() {
        Object object = this.getTreeLock();
        synchronized (object) {
            if (this.childrenHidden) {
                return;
            }
            this.childrenHidden = true;
            int n = this.getComponentCount();
            try {
                for (int i = 0; i < n; ++i) {
                    Component component = this.getComponent(i);
                    if (!component.isVisible()) continue;
                    component.setVisible(false);
                }
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                return;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void showChildren() {
        long l = System.currentTimeMillis();
        if (l - this.scrollTimestamp < this.docView.repaintTimeout) {
            return;
        }
        Object object = this.getTreeLock();
        synchronized (object) {
            if (!this.childrenHidden) {
                return;
            }
            this.childrenHidden = false;
            int n = this.getComponentCount();
            try {
                for (int i = 0; i < n; ++i) {
                    Movable movable;
                    ObjectBox objectBox;
                    Component component = this.getComponent(i);
                    if (!(component instanceof Movable) || (objectBox = (movable = (Movable)((Object)component)).getBox()) == null) continue;
                    Point point = new Point(0, 0);
                    objectBox.findAbsolutePosition(point);
                    movable.syncDom(point.x - this.sx, point.y - this.sy, objectBox.checkIfVisible());
                }
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                return;
            }
        }
        if (this.reclaimFocusOnScroll && !((FocusManager)(object = this.docView.getPilot().getView().getFocusManager())).requestFocus()) {
            this.requestFocus();
        }
        this.childrenValidated = true;
    }

    public void doLayout() {
        int n;
        int n2;
        block19: {
            if (this.docView.isPilotDisposed()) {
                return;
            }
            Dimension dimension = this.getSize();
            n2 = dimension.width;
            n = dimension.height;
            if (this.offscreenBuffer != null && (this.offscreenBuffer.getWidth(null) != n2 || this.offscreenBuffer.getHeight(null) != n)) {
                this.offscreenBuffer.flush();
                this.offscreenBuffer = null;
            }
            try {
                this.docView.docLayout(n2, n);
            }
            catch (Exception exception) {
                if (Debug.ex) {
                    Debug.ex((Throwable)exception);
                }
                if (!Debug.trace) break block19;
                Debug.trace((String)("Layout exception: " + exception));
            }
        }
        Scrollbar scrollbar = this.docView.vbar;
        Scrollbar scrollbar2 = this.docView.hbar;
        if (scrollbar != null && this.isVisible()) {
            int n3 = scrollbar.getValue();
            int n4 = n;
            int n5 = this.docView.getDocHeight();
            if (n4 > n5) {
                n4 = n5;
            }
            if (n3 + n4 > n5) {
                this.sy = this.nsy = (n3 = n5 - n4);
            }
            scrollbar.setValues(n3, n4, 0, n5);
            scrollbar.setBlockIncrement(n4);
            scrollbar.setUnitIncrement(20);
            int n6 = scrollbar2.getValue();
            int n7 = this.docView.getDocWidth();
            int n8 = n2;
            if (n8 > n7) {
                n8 = n7;
            }
            if (n6 + n8 > n7) {
                this.sx = this.nsx = (n6 = n7 - n8);
            }
            scrollbar2.setValues(n6, n8, 0, n7);
            scrollbar2.setBlockIncrement(n8);
            scrollbar2.setUnitIncrement(20);
            boolean bl = false;
            if (n5 <= n4) {
                if (scrollbar.isVisible() && this.docView.validateTreeNesting <= 1) {
                    scrollbar.setVisible(false);
                    bl = true;
                }
            } else if (!scrollbar.isVisible()) {
                scrollbar.setVisible(true);
                bl = true;
            }
            if (n7 <= n8) {
                if (scrollbar2.isVisible() && this.docView.validateTreeNesting <= 1) {
                    scrollbar2.setVisible(false);
                    bl = true;
                }
            } else if (!scrollbar2.isVisible()) {
                scrollbar2.setVisible(true);
                bl = true;
            }
            if (bl) {
                this.docView._panePanel.validateTree();
                return;
            }
        }
        this.docView.docPostLayout();
        this.sx = this.nsx;
        this.sy = this.nsy;
        this.childrenHidden = true;
        this.scrollTimestamp = 0L;
        this.showChildren();
    }

    void scroll(int n, int n2) {
        if (this.docView.canScroll(n, n2)) {
            this.nsx = n;
            this.nsy = n2;
            this.hideChildren();
            this.repaint();
            this.scrollTimestamp = System.currentTimeMillis();
            this.docView.postShowChildren(this);
        }
    }

    public void setBounds(int n, int n2, int n3, int n4) {
        if (n3 < 0 || n4 < 0) {
            if (Debug.trace) {
                Debug.trace((String)("Error: negative dimension: w=" + n3 + " h=" + n4));
            }
            if (n3 < 0) {
                n3 = 0;
            }
            if (n4 < 0) {
                n4 = 0;
            }
        }
        super.setBounds(n, n2, n3, n4);
    }

    public void update(Graphics graphics) {
        this.paint(graphics);
    }

    public void paint(Graphics graphics) {
        Graphics graphics2;
        if (this.docView.isPilotDisposed()) {
            return;
        }
        if (!this.docView.doesAutoRepaint()) {
            return;
        }
        if (graphics == null) {
            return;
        }
        Rectangle rectangle = graphics.getClipBounds();
        Dimension dimension = this.getSize();
        if (rectangle != null) {
            if (rectangle.x >= dimension.width) {
                return;
            }
            if (rectangle.y >= dimension.height) {
                return;
            }
            if (rectangle.x + rectangle.width < 0) {
                return;
            }
            if (rectangle.y + rectangle.height < 0) {
                return;
            }
        }
        if (this.offscreenBuffer == null) {
            try {
                this.offscreenBuffer = this.createImage(dimension.width, dimension.height);
            }
            catch (Exception exception) {
                return;
            }
        }
        if ((graphics2 = this.offscreenBuffer.getGraphics()) == null) {
            if (this.offscreenBuffer != null) {
                this.offscreenBuffer.flush();
            }
            this.offscreenBuffer = null;
            return;
        }
        if (this.preventOptimisedPaintOnce || this.docView.docContainsFixedBoxes() || this.nsx != this.sx && this.nsy != this.sy) {
            this.sx = this.nsx;
            this.sy = this.nsy;
        } else if (rectangle == null || rectangle.width == dimension.width && rectangle.height == dimension.height) {
            if (this.nsy < this.sy) {
                if (this.sy - this.nsy < dimension.height) {
                    graphics.copyArea(0, 0, dimension.width, dimension.height - (this.sy - this.nsy), 0, this.sy - this.nsy);
                    graphics.setClip(0, 0, dimension.width, this.sy - this.nsy);
                }
            } else if (this.nsy > this.sy) {
                if (this.nsy - this.sy < dimension.height) {
                    graphics.copyArea(0, this.nsy - this.sy, dimension.width, dimension.height - (this.nsy - this.sy), 0, this.sy - this.nsy);
                    graphics.setClip(0, dimension.height - (this.nsy - this.sy), dimension.width, this.nsy - this.sy);
                }
            } else if (this.nsx < this.sx) {
                if (this.sx - this.nsx < dimension.width) {
                    graphics.copyArea(0, 0, dimension.width - (this.sx - this.nsx), dimension.height, this.sx - this.nsx, 0);
                    graphics.setClip(0, 0, this.sx - this.nsx, dimension.height);
                }
            } else if (this.nsx > this.sx && this.nsx - this.sx < dimension.width) {
                graphics.copyArea(this.nsx - this.sx, 0, dimension.width - (this.nsx - this.sx), dimension.height, this.sx - this.nsx, 0);
                graphics.setClip(dimension.width - (this.nsx - this.sx), 0, this.nsx - this.sx, dimension.height);
            }
            rectangle = graphics.getClipBounds();
            this.sy = this.nsy;
            this.sx = this.nsx;
        }
        if (rectangle == null) {
            graphics.setClip(0, 0, dimension.width, dimension.height);
            rectangle = graphics.getClipBounds();
        }
        graphics2.setClip(rectangle);
        this.childrenValidated = false;
        this.paintInto(graphics2, rectangle);
        if (!this.childrenValidated) {
            this.childrenHidden = true;
            this.showChildren();
        }
        graphics2.dispose();
        if (this.offscreenBuffer != null) {
            graphics.drawImage(this.offscreenBuffer, rectangle.x, rectangle.y, rectangle.x + rectangle.width, rectangle.y + rectangle.height, rectangle.x, rectangle.y, rectangle.x + rectangle.width, rectangle.y + rectangle.height, null);
        }
        this.preventOptimisedPaintOnce = false;
    }

    private void paintInto(Graphics graphics, Rectangle rectangle) {
        graphics.translate(-this.sx, -this.sy);
        graphics.setClip(rectangle.x + this.sx, rectangle.y + this.sy, rectangle.width, rectangle.height);
        this.docView.docPaint(graphics);
        graphics.translate(this.sx, this.sy);
        this.docView.docPaintFixed(graphics);
    }

    private boolean isButtonDown(int n, InputEvent inputEvent) {
        if (n < 0) {
            return false;
        }
        int n2 = inputEvent.getModifiers();
        if (n == 0 && (n2 == 0 || (n2 & 0x10) != 0)) {
            return true;
        }
        return n == 1 && (n2 & 4) != 0;
    }

    private void mouseDragged(MouseEvent mouseEvent) {
        this.lastDraggedY = mouseEvent.getY();
        if (this.isButtonDown(this.scrollButton, mouseEvent)) {
            if (this.scrollMouseX >= 0) {
                int n = this.scrollMouseX - mouseEvent.getX();
                int n2 = this.scrollMouseY - mouseEvent.getY();
                if (Math.abs(n) > Math.abs(n2)) {
                    n2 = 0;
                } else {
                    n = 0;
                }
                this.docView.setScrollPosition(this.sx + n, this.sy + n2);
            }
            this.scrollMouseX = mouseEvent.getX();
            this.scrollMouseY = mouseEvent.getY();
        } else if (this.isButtonDown(this.selectButton, mouseEvent)) {
            if (this.selectMouseX >= 0) {
                int n = 0;
                if (mouseEvent.getY() > this.getSize().height) {
                    n = this.scrollHeight;
                } else if (mouseEvent.getY() < 0) {
                    n = -this.scrollHeight;
                }
                this.scrollAndSelect(n, mouseEvent.getX(), mouseEvent.getY());
            } else {
                this.selectMouseX = mouseEvent.getX();
                this.selectMouseY = mouseEvent.getY();
            }
        }
    }

    private void scrollAndSelect(int n, int n2, int n3) {
        if (n != 0) {
            long l = System.currentTimeMillis();
            if (l - this.scrollTimestamp > (long)this.scrollTimeout) {
                int n4 = this.docView.vbar.getMaximum();
                int n5 = this.docView.vbar.getVisibleAmount();
                int n6 = this.docView.vbar.getValue();
                if (n > 0 && n6 + n5 == n4) {
                    return;
                }
                if (n < 0 && n6 == 0) {
                    return;
                }
                this.docView.setScrollPosition(this.sx, this.sy + n);
                this.scrollTimestamp = l;
                this.selectMouseY -= n;
            }
            ScrollTimer scrollTimer = new ScrollTimer(this, n2, n3, n);
            this.docView.getPilot().getStorm().runOnEventThreadLater(scrollTimer, this.scrollTimeout + 10);
        }
        this.docView.docSetSelection(this.selectMouseX, this.selectMouseY, n2, n3 + n);
    }

    void verifyScrollTime(ScrollTimer scrollTimer) {
        if (this.selectMouseX != -1 && scrollTimer.dragY == this.lastDraggedY) {
            this.scrollAndSelect(scrollTimer.scr, scrollTimer.selX, scrollTimer.dragY);
        }
    }

    private void mousePressed(MouseEvent mouseEvent) {
        this.requestFocus();
        if (this.isButtonDown(this.selectButton, mouseEvent)) {
            this.docView.docClearSelection();
        }
    }

    private void mouseReleased(MouseEvent mouseEvent) {
        this.scrollMouseX = -1;
        this.selectMouseX = -1;
    }

    private void mouseExited(MouseEvent mouseEvent) {
        this.scrollMouseX = -1;
    }

    private void mouseClicked(MouseEvent mouseEvent) {
        if (this.isButtonDown(this.selectButton, mouseEvent)) {
            int n = mouseEvent.getClickCount();
            int n2 = mouseEvent.getX();
            int n3 = mouseEvent.getY();
            Html4DocumentAccess html4DocumentAccess = new Html4DocumentAccess(this.docView.getPilot());
            switch (n) {
                case 4: {
                    html4DocumentAccess.setSelection(0, n2, n3);
                    break;
                }
                case 3: {
                    break;
                }
                case 2: {
                    html4DocumentAccess.setSelection(2, n2, n3);
                }
            }
        }
    }

    protected void processEvent(AWTEvent aWTEvent) {
        if (this.docView.onComponentEvent(this, aWTEvent)) {
            super.processEvent(aWTEvent);
            switch (aWTEvent.getID()) {
                case 506: {
                    this.mouseDragged((MouseEvent)aWTEvent);
                    break;
                }
                case 501: {
                    this.mousePressed((MouseEvent)aWTEvent);
                    break;
                }
                case 502: {
                    this.mouseReleased((MouseEvent)aWTEvent);
                    break;
                }
                case 505: {
                    this.mouseExited((MouseEvent)aWTEvent);
                    break;
                }
                case 500: {
                    this.mouseClicked((MouseEvent)aWTEvent);
                }
            }
        }
    }

    private void addEventListenerReflectively() {
        block4: {
            try {
                String string = "ice.util.awt.jdk12.AWTEventListener";
                Constructor<?> constructor = Class.forName(string).getConstructors()[0];
                Object[] objectArray = new Object[]{this};
                this.v14FocusKeyListener = constructor.newInstance(objectArray);
                if (Debug.trace) {
                    Debug.trace((String)"Custom AWTEventListener constructed.");
                }
            }
            catch (Throwable throwable) {
                if (Debug.trace) {
                    Debug.trace((String)"Problem constructing custom AWTEventListener.");
                }
                if (!Debug.ex) break block4;
                Debug.ex((Throwable)throwable);
            }
        }
    }

    public void receiveEvent(AWTEvent aWTEvent) {
        if (this.equals(aWTEvent.getSource())) {
            this.processEvent(aWTEvent);
        }
    }

    public void dispose() {
        if (this.v14FocusKeyListener != null) {
            this.disposeEventListenerReflectively();
        }
    }

    private void disposeEventListenerReflectively() {
        block3: {
            try {
                Method method = this.v14FocusKeyListener.getClass().getDeclaredMethod("dispose", null);
                method.invoke(this.v14FocusKeyListener, null);
                if (Debug.trace) {
                    Debug.trace((String)"Custom AWTEventListener disposed.");
                }
            }
            catch (Throwable throwable) {
                if (!Debug.ex) break block3;
                Debug.ex((Throwable)throwable);
            }
        }
    }

    private static class ScrollTimer
    implements Runnable {
        final DocPanel owner;
        final int dragY;
        final int selX;
        final int scr;

        ScrollTimer(DocPanel docPanel, int n, int n2, int n3) {
            this.owner = docPanel;
            this.dragY = n2;
            this.scr = n3;
            this.selX = n;
        }

        public void run() {
            this.owner.verifyScrollTime(this);
        }
    }
}

