/*
 * Decompiled with CFR 0.152.
 */
package ice.pilots.html4.swing;

import ice.debug.Debug;
import ice.pilots.html4.AccessibleHyperPanel;
import ice.pilots.html4.ComponentFactory;
import ice.pilots.html4.Html4DocumentAccess;
import ice.pilots.html4.ObjectBox;
import ice.pilots.html4.swing.AccessibleHypertextPanel;
import ice.pilots.html4.swing.DocView;
import ice.pilots.html4.swing.Movable;
import ice.pilots.html4.swing.SwingScreenReaderStatusPanel;
import ice.util.Defs;
import java.awt.AWTEvent;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.InputEvent;
import java.awt.event.MouseEvent;
import javax.accessibility.AccessibleContext;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollBar;

class DocPanel
extends JPanel {
    DocView docView;
    int sx = 0;
    int sy = 0;
    int nsx = 0;
    int nsy = 0;
    private int selectButton = 0;
    private int scrollButton = 1;
    private int scrollMouseX = -1;
    private int scrollMouseY = -1;
    private int selectMouseX = -1;
    private int selectMouseY = -1;
    private int scrollHeight = 14;
    private int scrollTimeout = 100;
    private long scrollTimestamp;
    private int lastDraggedY;
    private boolean afterScrollBarShowHide = false;

    DocPanel(DocView docView) {
        this.docView = docView;
        this.enableEvents(60L);
        this.setLayout(null);
        this.scrollHeight = Defs.sysPropertyInt((String)"ice.pilots.html4.scrollHeight", (int)this.scrollHeight);
        this.scrollTimeout = Defs.sysPropertyInt((String)"ice.pilots.html4.scrollTimeout", (int)this.scrollTimeout);
        String value = Defs.sysProperty((String)"ice.pilots.html4.selectButton");
        if (!docView.enableTextSelection) {
            value = "none";
        }
        this.selectButton = ComponentFactory.parseButton(value, this.selectButton);
        value = Defs.sysProperty((String)"ice.pilots.html4.scrollButton");
        this.scrollButton = ComponentFactory.parseButton(value, this.scrollButton);
    }

    public boolean getFocusTraversalKeysEnabled() {
        return false;
    }

    public boolean isFocusable() {
        return true;
    }

    public boolean isFocusTraversable() {
        return true;
    }

    public boolean isManagingFocus() {
        return true;
    }

    void scrollLightweightChildren() {
        int count = this.getComponentCount();
        try {
            for (int i = 0; i < count; ++i) {
                Component component = this.getComponent(i);
                if (component == null || !(component instanceof JComponent)) continue;
                if (component instanceof Movable) {
                    Movable m = (Movable)((Object)component);
                    ObjectBox box = m.getBox();
                    if (box == null) continue;
                    Point p = new Point(0, 0);
                    box.findAbsolutePosition(p);
                    m.syncDom(p.x - this.sx, p.y - this.sy, box.checkIfVisible());
                    continue;
                }
                if (component.isVisible()) continue;
                component.setVisible(true);
            }
        }
        catch (ArrayIndexOutOfBoundsException exception) {
            return;
        }
    }

    public void doLayout() {
        Dimension sz = this.getSize();
        int width = sz.width <= 0 ? DocView.headlessLayoutWidth : sz.width;
        int height = sz.height <= 0 ? DocView.headlessLayoutHeight : sz.height;
        this.doLayout(width, height);
    }

    public void doLayout(int width, int height) {
        if (this.docView.isPilotDisposed()) {
            return;
        }
        this.docView.docLayout(width, height);
        JScrollBar vbar = this.docView.vbar;
        JScrollBar hbar = this.docView.hbar;
        JPanel spacer = this.docView.spacer;
        Color spacerBackColor = this.docView.spacerBackColor;
        if (vbar != null && this.isVisible()) {
            int y = vbar.getValue();
            int newHeight = height;
            int maxy = this.docView.getDocHeight();
            if (newHeight > maxy) {
                newHeight = maxy;
            }
            if (y + newHeight > maxy) {
                this.sy = this.nsy = (y = maxy - newHeight);
            }
            vbar.setValues(y, newHeight, 0, maxy);
            vbar.setBlockIncrement(newHeight);
            vbar.setUnitIncrement(20);
            int x = hbar.getValue();
            int maxx = this.docView.getDocWidth();
            int newWidth = width;
            if (newWidth > maxx) {
                newWidth = maxx;
            }
            if (x + newWidth > maxx) {
                this.sx = this.nsx = (x = maxx - newWidth);
            }
            hbar.setValues(x, newWidth, 0, maxx);
            hbar.setBlockIncrement(newWidth);
            hbar.setUnitIncrement(20);
            boolean scrollbarVisibilityChange = false;
            if (maxy <= newHeight) {
                if (vbar.isVisible() && this.docView.validateTreeNesting <= 1) {
                    vbar.setVisible(false);
                    scrollbarVisibilityChange = true;
                }
            } else if (!vbar.isVisible()) {
                vbar.setVisible(true);
                scrollbarVisibilityChange = true;
            }
            if (maxx <= newWidth) {
                if (hbar.isVisible() && this.docView.validateTreeNesting <= 1) {
                    hbar.setVisible(false);
                    scrollbarVisibilityChange = true;
                }
            } else if (!hbar.isVisible()) {
                hbar.setVisible(true);
                scrollbarVisibilityChange = true;
            }
            if (scrollbarVisibilityChange) {
                if (this.docView.fVerticalScrollbarSpacer) {
                    if (vbar.isVisible()) {
                        if (hbar.isVisible()) {
                            this.docView.southPanel.add((Component)spacer, "East");
                            spacer.setVisible(true);
                            spacer.setBackground(spacerBackColor);
                        } else {
                            spacer.setVisible(false);
                        }
                    } else {
                        this.docView.eastPanel.add((Component)spacer, "South");
                        spacer.setVisible(true);
                        spacer.setBackground(Color.white);
                    }
                }
                this.docView._panePanel.validateTree();
                return;
            }
        }
        this.docView.docPostLayout();
        this.scrollLightweightChildren();
    }

    void scroll(int x, int y) {
        if (!this.docView.canScroll(x, y)) {
            return;
        }
        this.nsx = x;
        this.nsy = y;
        this.sx = this.nsx;
        this.sy = this.nsy;
        this.scrollLightweightChildren();
        this.repaint();
    }

    public AccessibleContext getAccessibleContext() {
        if (!DocView.isAccessible) {
            return null;
        }
        if (this.accessibleContext == null) {
            if (DocView.accessibility.equalsIgnoreCase("java")) {
                AccessibleHypertextPanel ahp = new AccessibleHypertextPanel(this.docView, super.getAccessibleContext());
                SwingScreenReaderStatusPanel statusPanel = new SwingScreenReaderStatusPanel();
                this.docView._panePanel.add((Component)statusPanel, "North");
                statusPanel.setVisible(false);
                ahp.setAccessibleStatus(statusPanel);
                this.accessibleContext = ahp;
            }
            if (DocView.accessibility.equalsIgnoreCase("jaws")) {
                SwingScreenReaderStatusPanel statusPanel = new SwingScreenReaderStatusPanel();
                this.docView._panePanel.add((Component)statusPanel, "North");
                statusPanel.setVisible(false);
                this.accessibleContext = new AccessibleHyperPanel(this.docView.getPilot(), super.getAccessibleContext(), statusPanel);
            }
        }
        if (Debug.trace) {
            Debug.trace((String)("AccessibleContext <" + DocView.accessibility + " > created for " + this));
        }
        return this.accessibleContext;
    }

    public void paintComponent(Graphics g) {
        if (this.docView.isPilotDisposed()) {
            return;
        }
        long tt = System.currentTimeMillis();
        Rectangle r = g.getClipBounds();
        if (r == null) {
            g.setClip(0, 0, this.getSize().width, this.getSize().height);
            r = g.getClipBounds();
        }
        this.paintInto(g, r);
        this.scrollLightweightChildren();
        tt = System.currentTimeMillis() - tt;
    }

    private void paintInto(Graphics g, Rectangle r) {
        g.setColor(Color.white);
        g.fillRect(r.x, r.y, r.width, r.height);
        g.translate(-this.sx, -this.sy);
        g.setClip(r.x + this.sx, r.y + this.sy, r.width, r.height);
        this.docView.docPaint(g);
        g.translate(this.sx, this.sy);
        this.docView.docPaintFixed(g);
    }

    private void mouseDragged(MouseEvent e) {
        this.lastDraggedY = e.getY();
        if (this.isButtonDown(this.scrollButton, e)) {
            if (this.scrollMouseX >= 0) {
                int dx = this.scrollMouseX - e.getX();
                int dy = this.scrollMouseY - e.getY();
                if (Math.abs(dx) > Math.abs(dy)) {
                    dy = 0;
                } else {
                    dx = 0;
                }
                this.docView.setScrollPosition(this.sx + dx, this.sy + dy);
            }
            this.scrollMouseX = e.getX();
            this.scrollMouseY = e.getY();
        } else if (this.isButtonDown(this.selectButton, e)) {
            if (this.selectMouseX >= 0) {
                int scr = 0;
                if (e.getY() > this.getSize().height) {
                    scr = this.scrollHeight;
                } else if (e.getY() < 0) {
                    scr = -this.scrollHeight;
                }
                this.scrollAndSelect(scr, e.getX(), e.getY());
            } else {
                this.selectMouseX = e.getX();
                this.selectMouseY = e.getY();
            }
        }
    }

    private void scrollAndSelect(int scr, int ex, int ey) {
        if (scr != 0) {
            long tmp = System.currentTimeMillis();
            if (tmp - this.scrollTimestamp > (long)this.scrollTimeout) {
                int max = this.docView.vbar.getMaximum();
                int vis = this.docView.vbar.getVisibleAmount();
                int val = this.docView.vbar.getValue();
                if (scr > 0 && val + vis == max) {
                    return;
                }
                if (scr < 0 && val == 0) {
                    return;
                }
                this.docView.setScrollPosition(this.sx, this.sy + scr);
                this.scrollTimestamp = tmp;
                this.selectMouseY -= scr;
            }
            DelayedScroll t = new DelayedScroll(this, ex, ey, scr);
            this.docView.getPilot().getStorm().runOnEventThreadLater(t, this.scrollTimeout + 10);
        }
        this.docView.docSetSelection(this.selectMouseX, this.selectMouseY, ex, ey + scr);
    }

    private void verifyScrollTime(DelayedScroll t) {
        if (this.selectMouseX != -1 && t.dragY == this.lastDraggedY) {
            this.scrollAndSelect(t.scr, t.selX, t.dragY);
        }
    }

    private void mousePressed(MouseEvent e) {
        this.requestFocus();
        if (this.isButtonDown(this.selectButton, e) && (!System.getProperty("os.name").startsWith("Mac OS") || (e.getModifiers() & 2) == 0)) {
            this.docView.docClearSelection();
        }
    }

    private void mouseReleased(MouseEvent e) {
        this.scrollMouseX = -1;
        this.selectMouseX = -1;
    }

    private void mouseExited(MouseEvent e) {
        this.scrollMouseX = -1;
    }

    private void mouseClicked(MouseEvent event) {
        if (this.isButtonDown(this.selectButton, event)) {
            int clickCount = event.getClickCount();
            int mouseX = event.getX();
            int mouseY = event.getY();
            Html4DocumentAccess access = new Html4DocumentAccess(this.docView.getPilot());
            switch (clickCount) {
                case 4: {
                    access.setSelection(0, mouseX, mouseY);
                    break;
                }
                case 3: {
                    break;
                }
                case 2: {
                    access.setSelection(2, mouseX, mouseY);
                }
            }
        }
    }

    private boolean isButtonDown(int whichButton, InputEvent e) {
        if (whichButton < 0) {
            return false;
        }
        int m = e.getModifiers();
        if (whichButton == 0 && (m == 0 || (m & 0x10) != 0)) {
            return true;
        }
        return whichButton == 1 && (m & 4) != 0;
    }

    protected void processEvent(AWTEvent e) {
        if (this.docView.onComponentEvent(this, e)) {
            super.processEvent(e);
            switch (e.getID()) {
                case 506: {
                    this.mouseDragged((MouseEvent)e);
                    break;
                }
                case 501: {
                    this.mousePressed((MouseEvent)e);
                    break;
                }
                case 502: {
                    this.mouseReleased((MouseEvent)e);
                    break;
                }
                case 505: {
                    this.mouseExited((MouseEvent)e);
                    break;
                }
                case 500: {
                    this.mouseClicked((MouseEvent)e);
                }
            }
        }
    }

    private static class DelayedScroll
    implements Runnable {
        private final DocPanel owner;
        private final int dragY;
        private final int selX;
        private final int scr;

        DelayedScroll(DocPanel owner, int selX, int dragY, int scr) {
            this.owner = owner;
            this.dragY = dragY;
            this.scr = scr;
            this.selX = selX;
        }

        public void run() {
            this.owner.verifyScrollTime(this);
        }
    }
}

