/*
 * Decompiled with CFR 0.152.
 */
package ice.pilots.html4.swing;

import ice.debug.Debug;
import ice.pilots.html4.DElement;
import ice.pilots.html4.DNode;
import ice.pilots.html4.DOMUIEvent;
import ice.pilots.html4.DocPaneXml;
import ice.pilots.html4.EmbeddedObject;
import ice.pilots.html4.ObjectBox;
import ice.pilots.html4.ObjectPainter;
import ice.pilots.html4.ScrollBox;
import ice.pilots.html4.ScrollHandler;
import ice.pilots.html4.swing.BufferedHeavyweightPanel;
import ice.pilots.html4.swing.DocPanel;
import ice.pilots.html4.swing.EmbeddedObjectContainer;
import ice.pilots.html4.swing.FormInputButton;
import ice.pilots.html4.swing.FormInputCheckbox;
import ice.pilots.html4.swing.FormInputPasswordText;
import ice.pilots.html4.swing.FormInputRadio;
import ice.pilots.html4.swing.FormInputText;
import ice.pilots.html4.swing.FormInputUpload;
import ice.pilots.html4.swing.FormSelectChoice;
import ice.pilots.html4.swing.FormSelectChoicePre14;
import ice.pilots.html4.swing.FormSelectList;
import ice.pilots.html4.swing.FormTextArea;
import ice.pilots.html4.swing.PanePanel;
import ice.pilots.html4.swing.Scroller;
import ice.pilots.html4.swing.TheFactory;
import ice.storm.ViewportLayoutManager;
import ice.util.Defs;
import ice.util.JavaVersion;
import ice.util.alg.HashArray;
import java.awt.AWTEvent;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Image;
import java.awt.Point;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import javax.accessibility.AccessibleContext;
import javax.swing.ButtonGroup;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import javax.swing.text.JTextComponent;
import org.w3c.dom.events.EventListener;

final class DocView
extends DocPaneXml
implements AdjustmentListener {
    TheFactory factory;
    PanePanel _panePanel;
    JScrollBar vbar;
    JScrollBar hbar;
    DocPanel docPanel;
    boolean fVerticalScrollbarSpacer = false;
    JPanel spacer;
    JPanel southPanel;
    JPanel eastPanel;
    Color spacerBackColor;
    BufferedHeavyweightPanel heavyPanel = null;
    private ScrollHandler scrollHandler;
    boolean cursorChange = true;
    private boolean scrollbarEast = true;
    private final HashArray cgs = new HashArray();
    private final HashArray cgs_none = new HashArray();
    int validateTreeNesting = 0;
    public static final String ACCESSIBILITY_NONE = "none";
    public static final String ACCESSIBILITY_JAVA = "java";
    public static final String ACCESSIBILITY_JAWS = "jaws";
    static String accessibility = "none";
    static boolean isAccessible = false;
    static int headlessLayoutWidth = 800;
    static int headlessLayoutHeight = 800;

    DocView(TheFactory factory) {
        this.factory = factory;
    }

    protected void init(int scrollbars) {
        boolean doHeavy;
        this.docPanel = new DocPanel(this);
        this._panePanel = new PanePanel(this);
        this._panePanel.setLayout(new BorderLayout());
        this._panePanel.setOpaque(true);
        boolean drawScrollbars = Defs.sysPropertyBoolean((String)"ice.pilots.html4.scrollbars", (boolean)true);
        String temp = Defs.sysProperty((String)"ice.pilots.html4.verticalScrollbarSpacer", (String)"0");
        int tempInt = Integer.parseInt(temp);
        boolean bl = this.fVerticalScrollbarSpacer = tempInt == 1;
        if (drawScrollbars && scrollbars != 2) {
            this.vbar = new JScrollBar(1);
            this.hbar = new JScrollBar(0);
        }
        if (doHeavy = Defs.sysPropertyBoolean((String)"ice.pilots.html4.swing.heavy")) {
            this.heavyPanel = new BufferedHeavyweightPanel();
            this.heavyPanel.getContentPane().setLayout(new BorderLayout());
            this._panePanel.add((Component)this.heavyPanel, "Center");
            this.heavyPanel.getContentPane().add(this.docPanel);
        } else {
            this._panePanel.add((Component)this.docPanel, "Center");
        }
        if (this.vbar != null) {
            if (this.fVerticalScrollbarSpacer) {
                this.eastPanel = new JPanel(new BorderLayout());
                this.eastPanel.add((Component)this.vbar, "Center");
                this.eastPanel.setBackground(Color.white);
                this._panePanel.add((Component)this.eastPanel, "East");
                this.spacer = new JPanel();
                this.spacer.setPreferredSize(new Dimension(this.hbar.getPreferredSize().height, this.vbar.getPreferredSize().width));
                this.southPanel = new JPanel(new BorderLayout());
                this.southPanel.add((Component)this.hbar, "Center");
                this.southPanel.add((Component)this.spacer, "East");
                this._panePanel.add((Component)this.southPanel, "South");
            } else {
                this._panePanel.add((Component)this.vbar, "East");
                this._panePanel.add((Component)this.hbar, "South");
            }
            this.vbar.addAdjustmentListener(this);
            this.hbar.addAdjustmentListener(this);
            this.initMouseWheelSupport();
        }
        this.cursorChange = Defs.sysPropertyBoolean((String)"ice.pilots.html4.cssCursor", (boolean)this.cursorChange);
    }

    private void initMouseWheelSupport() {
        block7: {
            try {
                Class<?> mouseWheelEvent = Class.forName("java.awt.event.MouseWheelEvent");
                try {
                    String className = "ice.util.swing.jdk14.SwingMouseWheelListener";
                    Constructor<?> constr = Class.forName(className).getConstructors()[0];
                    Object[] args = new Object[]{this.vbar, this.hbar};
                    java.util.EventListener aListener = null;
                    aListener = (java.util.EventListener)constr.newInstance(args);
                    this.addMouseWheelListenerReflectively(aListener, this.docPanel);
                    this.addMouseWheelListenerReflectively(aListener, this.vbar);
                    this.addMouseWheelListenerReflectively(aListener, this.hbar);
                    if (Debug.trace) {
                        Debug.trace((String)"MouseWheel support found and configured.");
                    }
                }
                catch (Throwable t1) {
                    if (Debug.trace) {
                        Debug.trace((String)"MouseWheel support found, but error occurred during configuration.");
                    }
                    if (Debug.ex) {
                        Debug.ex((Throwable)t1);
                    }
                }
            }
            catch (ClassNotFoundException e) {
                if (!Debug.trace) break block7;
                Debug.trace((String)"MouseWheel support not found.");
            }
        }
    }

    private void addMouseWheelListenerReflectively(Object listener, Object target) throws Throwable {
        Class<?> targetClass = target.getClass();
        Class[] classArgs = new Class[]{Class.forName("java.awt.event.MouseWheelListener")};
        Method addListenerMethod = targetClass.getMethod("addMouseWheelListener", classArgs);
        addListenerMethod.invoke(target, listener);
    }

    public void adjustmentValueChanged(AdjustmentEvent e) {
        this.docPanel.scroll(this.hbar.getValue(), this.vbar.getValue());
    }

    public void updateScrollbars(boolean isRTL) {
        if (this.vbar == null) {
            return;
        }
        if (isRTL) {
            if (this.scrollbarEast) {
                this._panePanel.remove(this.vbar);
                this._panePanel.add((Component)this.vbar, "West");
                this.scrollbarEast = false;
            }
        } else if (!this.scrollbarEast) {
            this._panePanel.remove(this.vbar);
            this._panePanel.add((Component)this.vbar, "East");
            this.scrollbarEast = true;
        }
    }

    public int getScrollX() {
        return this.docPanel.sx;
    }

    public int getScrollY() {
        return this.docPanel.sy;
    }

    public int getPaneWidth() {
        return this.docPanel.getSize().width;
    }

    public int getPaneHeight() {
        return this.docPanel.getSize().height;
    }

    public void setScrollPosition(int x, int y) {
        if (this.vbar != null) {
            this.hbar.setValue(this.getScrollX(x));
            this.vbar.setValue(this.getScrollY(y));
        } else {
            this.docPanel.scroll(this.getScrollX(x), this.getScrollY(y));
        }
    }

    public void setPaneBounds(int x, int y, int w, int h) {
        this._panePanel.setBounds(x, y, w, h);
    }

    public void revalidate() {
        if (!this.docPanel.isShowing()) {
            this.docPanel.doLayout(headlessLayoutWidth, headlessLayoutHeight);
            return;
        }
        this.docPanel.invalidate();
        if (this.heavyPanel != null) {
            this.heavyPanel.invalidate();
        }
        this._panePanel.revalidate();
        this._panePanel.repaint();
        if (this.heavyPanel != null) {
            this.heavyPanel.repaint();
        }
    }

    public void reqRepaint() {
        this.docPanel.repaint();
    }

    public void reqRepaint(int x, int y, int w, int h) {
        y -= this.getScrollY();
        if ((x -= this.getScrollX()) < 0) {
            if (x + w <= 0) {
                return;
            }
            w += x;
            x = 0;
        }
        if (y < 0) {
            if (y + h <= 0) {
                return;
            }
            h += y;
            y = 0;
        }
        int visibleWidth = this.getPaneWidth();
        int visibleHeight = this.getPaneHeight();
        if (x >= visibleWidth || y >= visibleHeight) {
            return;
        }
        if (x + w > visibleWidth) {
            w = visibleWidth - x;
        }
        if (y + h > visibleHeight) {
            h = visibleHeight - y;
        }
        if (w > 0 && h > 0) {
            this.docPanel.repaint(x, y, w, h);
        }
    }

    public void reqClear() {
        this.docPanel.removeAll();
        this.docPanel.sy = 0;
        this.docPanel.sx = 0;
        this.docPanel.nsy = 0;
        this.docPanel.nsx = 0;
        if (this.vbar != null) {
            this.vbar.setValue(0);
            this.hbar.setValue(0);
        }
    }

    public void setAutoRepaint(boolean flag) {
    }

    public boolean doesAutoRepaint() {
        return false;
    }

    public void setCursor(int type) {
        if (this.cursorChange) {
            final Cursor c = Cursor.getPredefinedCursor(type);
            if (SwingUtilities.isEventDispatchThread()) {
                this.docPanel.setCursor(c);
            } else {
                Runnable doWorkRunnable = new Runnable(){

                    public void run() {
                        DocView.this.docPanel.setCursor(c);
                    }
                };
                SwingUtilities.invokeLater(doWorkRunnable);
            }
        }
    }

    public Image createImage(int w, int h) {
        return this._panePanel.createImage(w, h);
    }

    protected Component getPaneComponent() {
        return this._panePanel;
    }

    public void setCursorChangeable(boolean state) {
        this.cursorChange = state;
    }

    protected ObjectPainter createFormControl(DElement e) {
        JComponent c = null;
        String tagName = e.getTagName();
        if (tagName.equalsIgnoreCase("input")) {
            String t = e.getAttribute("type");
            if (t == null || t.equalsIgnoreCase("text")) {
                c = new FormInputText(this, e);
            } else if (t.equalsIgnoreCase("password")) {
                c = new FormInputPasswordText(this, e);
            } else if (t.equalsIgnoreCase("button")) {
                c = new FormInputButton(this, e, "button");
            } else if (t.equalsIgnoreCase("submit")) {
                c = new FormInputButton(this, e, "submit");
            } else if (t.equalsIgnoreCase("reset")) {
                c = new FormInputButton(this, e, "reset");
            } else if (t.equalsIgnoreCase("checkbox")) {
                c = new FormInputCheckbox(this, e);
            } else if (t.equalsIgnoreCase("file")) {
                c = new FormInputUpload(this, e);
            } else if (t.equalsIgnoreCase("radio")) {
                JRadioButton cg_none = null;
                ButtonGroup cg = null;
                String name = e.getAttribute("name");
                if (name != null) {
                    cg_none = (JRadioButton)this.cgs_none.get((Object)name);
                    cg = (ButtonGroup)this.cgs.get((Object)name);
                    if (cg == null) {
                        cg = new ButtonGroup();
                        cg_none = new JRadioButton();
                        cg.add(cg_none);
                        this.cgs.put((Object)name, (Object)cg);
                        this.cgs_none.put((Object)name, (Object)cg_none);
                    }
                }
                c = new FormInputRadio(this, e, cg_none, cg);
            }
        } else if (tagName.equalsIgnoreCase("textarea")) {
            c = new FormTextArea(this, e);
        } else if (tagName.equalsIgnoreCase("select")) {
            int sz = e.getAttributeAsInt("size");
            if (sz <= 1) {
                c = JavaVersion.isV14orGreater() ? new FormSelectChoice(this, e) : new FormSelectChoicePre14(this, e);
                if (this.heavyPanel != null) {
                    ((JComboBox)c).setLightWeightPopupEnabled(false);
                }
            } else {
                c = new FormSelectList(this, e, sz);
            }
        }
        if (c != null) {
            ((Component)c).setVisible(false);
            this.docPanel.add(c);
            if (isAccessible) {
                this.setComponentAccessibleName(e, c);
                c.getAccessibleContext().setAccessibleParent(this.docPanel);
            }
        }
        return (ObjectPainter)((Object)c);
    }

    private void setComponentAccessibleName(DElement e, Component c) {
        String elementName = e.getName();
        AccessibleContext ctxt = c.getAccessibleContext();
        if (ctxt != null && elementName != null && elementName != null) {
            ctxt.setAccessibleName(elementName);
        }
    }

    protected ObjectPainter createScroller() {
        Scroller s = new Scroller(this);
        this.docPanel.add(s);
        return s;
    }

    protected Container createEmbeddedContainer(EmbeddedObject obj, Component child) {
        EmbeddedObjectContainer c = new EmbeddedObjectContainer(obj);
        c.setLayout(new ViewportLayoutManager(obj));
        c.setSize(obj.getPrefWidth(), obj.getPrefHeight());
        c.add(child);
        this.docPanel.add(c);
        ((JComponent)c.getParent()).revalidate();
        return c;
    }

    protected Component createFramesDividerComponent() {
        JPanel p = new JPanel();
        p.setBackground(new Color(200, 200, 200));
        return p;
    }

    protected void checkAwtTree(ObjectBox obox, Component c) {
        if (obox == null) {
            return;
        }
        ScrollBox sbox = obox.getAncestorScrollBox();
        if (sbox == null) {
            if (this.docPanel != c.getParent()) {
                this.docPanel.add(c);
            }
        } else {
            ObjectBox sobox = sbox.getObjectBox();
            ObjectPainter sop = sobox.getObjectPainter();
            if (sop instanceof Scroller) {
                Scroller scroller = (Scroller)sop;
                scroller.getView().add(c);
            }
        }
    }

    private DOMUIEvent _translateMouseEvent(MouseEvent e) {
        DOMUIEvent retval = null;
        int x = this._translateX(e);
        int y = this._translateY(e);
        int id = -1;
        switch (e.getID()) {
            case 504: {
                id = 5;
                break;
            }
            case 505: {
                id = 7;
                break;
            }
            case 500: {
                break;
            }
            case 501: {
                id = 3;
                break;
            }
            case 502: {
                id = 4;
                break;
            }
            case 503: 
            case 506: {
                id = 6;
            }
        }
        if (id >= 0) {
            retval = this.createDomUIEvent(id);
            retval.setClientCoords(x, y, this.docPanel.sx, this.docPanel.sy);
            try {
                Component c = e.getComponent();
                if (c.isShowing()) {
                    Point p = c.getLocationOnScreen();
                    retval.setScreenCoords(p.x + e.getX(), p.y + e.getY());
                }
            }
            catch (Exception ex) {
                // empty catch block
            }
        }
        return retval;
    }

    private int _translateX(MouseEvent e) {
        int add = 0;
        for (Component tmp = e.getComponent(); tmp != null && tmp != this.docPanel; tmp = tmp.getParent()) {
            Point ltmp = tmp.getLocation();
            add += ltmp.x;
        }
        return e.getX() + add;
    }

    private int _translateY(MouseEvent e) {
        int add = 0;
        for (Component tmp = e.getComponent(); tmp != null && tmp != this.docPanel; tmp = tmp.getParent()) {
            Point ltmp = tmp.getLocation();
            add += ltmp.y;
        }
        return e.getY() + add;
    }

    final boolean onComponentEvent(Component source, AWTEvent event) {
        return this.onComponentEvent(source, event, null);
    }

    boolean onComponentEvent(Component source, AWTEvent event, EventListener action) {
        if (!this.checkDocumentId()) {
            return false;
        }
        int id = event.getID();
        if (500 <= id && id <= 507) {
            return this.onComponentMouseEvent(source, (MouseEvent)event, action);
        }
        if (400 <= id && id <= 402) {
            return this.processAwtKeyEvent(source, (KeyEvent)event, action);
        }
        if (1004 == id) {
            this.notifyFocusGain();
        } else if (1005 == id) {
            this.notifyFocusLost();
        }
        return true;
    }

    protected boolean onComponentMouseEvent(Component c, MouseEvent e, EventListener action) {
        DOMUIEvent uie = this._translateMouseEvent(e);
        if (uie != null) {
            int id = uie.getTypeId();
            int x = uie.getPosX();
            int y = uie.getPosY();
            return this.uiEvent(uie, e, action);
        }
        return true;
    }

    protected void onNodeSelectCall(DNode node) {
        ObjectPainter painter = this.getNodePainter(node);
        if (painter instanceof Component) {
            Component c = (Component)((Object)painter);
            if (c instanceof JScrollPane) {
                c = ((JScrollPane)c).getViewport().getView();
            }
            if (c instanceof JTextComponent) {
                ((JTextComponent)c).selectAll();
            }
        }
    }

    protected void onNodeBlurEvent(DOMUIEvent event, DNode node) {
        ObjectPainter painter = this.getNodePainter(node);
        if (painter instanceof Component && event.getRelatedTarget() == null) {
            ((Component)((Object)painter)).getParent().requestFocus();
        }
    }

    protected void onNodeFocusEvent(DOMUIEvent event, DNode node) {
        ObjectPainter painter = this.getNodePainter(node);
        if (painter instanceof Component) {
            Component c = (Component)((Object)painter);
            if (c instanceof JScrollPane) {
                c = ((JScrollPane)c).getViewport().getView();
            }
            c.requestFocus();
        }
    }

    public void reqFocus() {
        this.docPanel.requestFocus();
    }

    static {
        accessibility = Defs.sysProperty((String)"ice.pilots.html4.swing.accessible", (String)ACCESSIBILITY_NONE);
        if (accessibility.equalsIgnoreCase(ACCESSIBILITY_JAVA) || accessibility.equalsIgnoreCase(ACCESSIBILITY_JAWS)) {
            isAccessible = true;
        }
        String temp = Defs.sysProperty((String)"ice.pilots.html4.swing.headlessWidth", (String)"800");
        try {
            headlessLayoutWidth = Integer.parseInt(temp);
            if (headlessLayoutWidth < 0) {
                headlessLayoutWidth = 200;
            }
        }
        catch (NumberFormatException nfe) {
            // empty catch block
        }
        temp = Defs.sysProperty((String)"ice.pilots.html4.swing.headlessHeight", (String)"800");
        try {
            headlessLayoutHeight = Integer.parseInt(temp);
            if (headlessLayoutHeight < 0) {
                headlessLayoutHeight = 200;
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }
}

