/*
 * Decompiled with CFR 0.152.
 */
package ice.storm;

import ice.storm.LoadSession;
import ice.storm.Viewport;
import ice.util.alg.IThread;
import ice.util.security.BoxedCode;
import ice.util.security.SecurityKit;

final class LoadThread
extends IThread {
    private volatile boolean shouldStop;
    private Viewport view;
    LoadSession loadSession;

    LoadThread(Viewport viewport) {
        super("Loader for " + viewport.getId());
        this.view = viewport;
        this.setDaemon(true);
    }

    static LoadThread create(final Viewport viewport) {
        return (LoadThread)((Object)SecurityKit.doPrivileged((BoxedCode)new BoxedCode(){

            public Object run() {
                return new LoadThread(viewport);
            }
        }));
    }

    boolean isStopRequested() {
        return this.shouldStop;
    }

    void shouldStop() {
        this.shouldStop = true;
    }

    public void run() {
        try {
            Thread.sleep(10L);
            this.view.runAsynchronousLoad(this.loadSession);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }
}

