/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.xom;

import java.util.HashMap;
import net.sf.saxon.Configuration;
import net.sf.saxon.om.DocumentInfo;
import net.sf.saxon.om.NamePool;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.xom.NodeWrapper;
import nu.xom.Attribute;
import nu.xom.Document;
import nu.xom.Element;
import nu.xom.Node;

public class DocumentWrapper
extends NodeWrapper
implements DocumentInfo {
    protected Configuration config;
    protected String baseURI;
    protected int documentNumber;
    private HashMap idIndex;

    public DocumentWrapper(Node root, String baseURI, Configuration config) {
        super(root, null, 0);
        if (root.getParent() != null) {
            throw new IllegalArgumentException("root node must not have a parent node");
        }
        this.baseURI = baseURI;
        this.docWrapper = this;
        this.setConfiguration(config);
    }

    public NodeInfo wrap(Node node) {
        if (node == this.node) {
            return this;
        }
        return this.makeWrapper(node, this);
    }

    public void setConfiguration(Configuration config) {
        this.config = config;
        this.documentNumber = config.getDocumentNumberAllocator().allocateDocumentNumber();
    }

    public Configuration getConfiguration() {
        return this.config;
    }

    public NamePool getNamePool() {
        return this.config.getNamePool();
    }

    public int getDocumentNumber() {
        return this.documentNumber;
    }

    public NodeInfo selectID(String id) {
        if (this.idIndex == null) {
            Element elem;
            switch (this.nodeKind) {
                case 9: {
                    elem = ((Document)this.node).getRootElement();
                    break;
                }
                case 1: {
                    elem = (Element)this.node;
                    break;
                }
                default: {
                    return null;
                }
            }
            this.idIndex = new HashMap(50);
            this.buildIDIndex(elem);
        }
        return (NodeInfo)this.idIndex.get(id);
    }

    private void buildIDIndex(Element elem) {
        int i = elem.getChildCount();
        while (--i >= 0) {
            Node child = elem.getChild(i);
            if (!(child instanceof Element)) continue;
            this.buildIDIndex((Element)child);
        }
        i = elem.getAttributeCount();
        while (--i >= 0) {
            Attribute att = elem.getAttribute(i);
            if (att.getType() != Attribute.Type.ID) continue;
            this.idIndex.put(att.getValue(), this.wrap((Node)elem));
        }
    }

    public String[] getUnparsedEntity(String name) {
        return null;
    }
}

