/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mwswing;

import com.mathworks.mwswing.CellPainterProvider;
import com.mathworks.mwswing.MJUtilities;
import com.mathworks.mwswing.MPopup;
import com.mathworks.mwswing.WindowUtils;
import com.mathworks.util.PlatformInfo;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.SystemColor;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import javax.swing.BorderFactory;
import javax.swing.CellRendererPane;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.ToolTipManager;
import javax.swing.event.MouseInputAdapter;

public class CellViewer {
    private Timer fShowTimer;
    private Timer fHideTimer;
    private Timer fDoubleClickTimer;
    private Timer fRecentTimer;
    private int fInitialDelay = ToolTipManager.sharedInstance().getInitialDelay();
    private int fRelaxationTime = ToolTipManager.sharedInstance().getDismissDelay();
    private boolean fWasJustClicked;
    private boolean fWasRecentlyShown;
    private boolean fMouseHasEntered;
    private MPopup fPopup;
    private CellPanel fCellPanel;
    private Container fClient;
    private Point fViewerLocation = new Point();
    private Dimension fViewerSize = new Dimension();
    private Rectangle fClientVisibleRect;
    private Dimension fPaintSize = new Dimension();
    private Point fUpperLeft = new Point();
    private Point fMouseLocationUponShow;
    private static CellViewer sTheInstance = new CellViewer();
    private CellPainterProvider fProvider;
    private static final int MOUSE_ENTER_DELAY = 100;
    private static final int RECENT = 250;

    public static CellViewer getInstance() {
        return sTheInstance;
    }

    private CellViewer() {
        this.fShowTimer = new Timer(this.fInitialDelay, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                CellViewer.this.showNow();
            }
        });
        this.fShowTimer.setRepeats(false);
        this.fHideTimer = new Timer(this.fRelaxationTime, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                CellViewer.this.hide();
            }
        });
        this.fDoubleClickTimer = new Timer(MJUtilities.getDoubleClickInterval(), new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                CellViewer.this.fWasJustClicked = false;
            }
        });
        this.fRecentTimer = new Timer(250, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                CellViewer.this.fWasRecentlyShown = false;
            }
        });
        this.fRecentTimer.setRepeats(false);
        this.fDoubleClickTimer.setRepeats(false);
        this.fCellPanel = new CellPanel();
    }

    public static boolean shouldShow(Rectangle rectangle, Rectangle rectangle2, Dimension dimension) {
        return CellViewer.shouldShow(rectangle, rectangle2, dimension, 2);
    }

    public static boolean shouldShow(Rectangle rectangle, Rectangle rectangle2, Dimension dimension, int n) {
        int n2;
        int n3;
        switch (n) {
            case 4: {
                n3 = rectangle2.x + rectangle2.width;
                n2 = n3 - dimension.width;
                break;
            }
            case 0: {
                n2 = rectangle2.x + (rectangle2.width - dimension.width) / 2;
                n3 = n2 + dimension.width;
                break;
            }
            default: {
                n2 = rectangle2.x;
                n3 = rectangle2.x + dimension.width;
            }
        }
        int n4 = rectangle.x + rectangle.width;
        return n2 < rectangle.x && n3 > rectangle.x || n3 > n4 && n2 < n4 || dimension.width > rectangle2.width;
    }

    public void show(Container container, CellPainterProvider cellPainterProvider, Dimension dimension, Rectangle rectangle, int n, Dimension dimension2, Point point) {
        Window window = WindowUtils.getTopmostWindow(container);
        if (window == null || !window.isActive()) {
            return;
        }
        boolean bl = this.isShowing();
        if (bl) {
            this.hide();
        }
        this.fProvider = cellPainterProvider;
        this.fClient = container;
        this.fUpperLeft.x = n == 4 && dimension.width < rectangle.width ? rectangle.x + rectangle.width - dimension.width : (n == 0 && dimension.width < rectangle.width ? rectangle.x + (rectangle.width - dimension.width) / 2 : rectangle.x);
        this.fUpperLeft.x += dimension2.width;
        this.fUpperLeft.y = rectangle.y + dimension2.height;
        this.fPaintSize.width = dimension.width + 2;
        this.fPaintSize.height = dimension.height;
        this.fMouseLocationUponShow = point;
        if (bl || this.fInitialDelay == 0 || this.wasRecentlyShown(container)) {
            this.showNow();
        } else {
            if (this.fShowTimer.isRunning()) {
                this.fShowTimer.stop();
            }
            this.fShowTimer.setInitialDelay(this.fInitialDelay);
            this.fShowTimer.start();
        }
    }

    protected void showNow() {
        this.fClientVisibleRect = this.fClient instanceof JComponent ? ((JComponent)this.fClient).getVisibleRect() : this.fClient.getBounds();
        this.fCellPanel.setBackground(this.fClient.getBackground());
        this.fCellPanel.setForeground(this.fClient.getForeground());
        this.fCellPanel.setFont(this.fClient.getFont());
        Insets insets = this.fCellPanel.getInsets();
        this.fUpperLeft.x -= insets.left;
        this.fUpperLeft.y -= insets.top;
        this.fViewerLocation.setLocation(this.fUpperLeft);
        this.fViewerSize.setSize(this.fPaintSize.width + insets.left + insets.right, this.fPaintSize.height + insets.top + insets.bottom);
        this.fCellPanel.setPreferredSize(this.fViewerSize);
        SwingUtilities.convertPointToScreen(this.fUpperLeft, this.fClient);
        this.fUpperLeft = WindowUtils.ensureOnScreen(this.fUpperLeft, this.fViewerSize, 0);
        this.fPopup = MPopup.getPopup(this.fClient, this.fCellPanel, this.fUpperLeft.x, this.fUpperLeft.y);
        this.fPopup.show();
        if (this.fHideTimer.isRunning()) {
            this.fHideTimer.stop();
        }
        boolean bl = false;
        if (!PlatformInfo.isMacintosh()) {
            boolean bl2 = bl = this.fViewerLocation.x <= this.fMouseLocationUponShow.x && this.fMouseLocationUponShow.x <= this.fViewerLocation.x + this.fViewerSize.width && this.fViewerLocation.y <= this.fMouseLocationUponShow.y && this.fMouseLocationUponShow.y <= this.fViewerLocation.y + this.fViewerSize.height;
        }
        if (bl) {
            this.fHideTimer.setInitialDelay(100);
        } else {
            this.fHideTimer.setInitialDelay(this.fRelaxationTime);
            this.fMouseHasEntered = false;
        }
        this.fHideTimer.start();
    }

    public void cancelShow() {
        if (this.fShowTimer.isRunning()) {
            this.fShowTimer.stop();
        }
    }

    public void hide() {
        this.fClient.repaint(this.fViewerLocation.x, this.fViewerLocation.y, this.fViewerSize.width, this.fViewerSize.height);
        this.fHideTimer.stop();
        if (this.fPopup != null) {
            this.fPopup.hide();
            this.fPopup = null;
        }
        this.fWasRecentlyShown = true;
        if (this.fRecentTimer.isRunning()) {
            this.fRecentTimer.restart();
        } else {
            this.fRecentTimer.start();
        }
    }

    public boolean isShowPending(Container container) {
        return container == this.fClient && this.fShowTimer.isRunning();
    }

    public boolean isShowPending() {
        return this.fShowTimer.isRunning();
    }

    public boolean isShowing(Container container) {
        return container == this.fClient && this.fPopup != null;
    }

    public boolean isShowing() {
        return this.fPopup != null;
    }

    public boolean wasJustClicked(Container container) {
        return container == this.fClient && this.fWasJustClicked;
    }

    public boolean wasRecentlyShown(Container container) {
        return container == this.fClient && this.fWasRecentlyShown;
    }

    public void mouseExitedClient(MouseEvent mouseEvent) {
        if (PlatformInfo.isMacintosh() && this.isShowing()) {
            this.fMouseHasEntered = new Rectangle(new Rectangle(this.fViewerLocation.x, this.fViewerLocation.y, this.fViewerSize.width, this.fViewerSize.height)).contains(mouseEvent.getX(), mouseEvent.getY());
        }
        if (!this.fMouseHasEntered) {
            this.fHideTimer.stop();
            this.fHideTimer.setInitialDelay(100);
            this.fHideTimer.start();
        }
    }

    public void dragRecognized() {
        if (this.isShowing()) {
            this.hide();
        }
    }

    public void setInitialDelay(int n) {
        this.fInitialDelay = n;
    }

    public int getInitialDelay() {
        return this.fInitialDelay;
    }

    public void setRelaxationTime(int n) {
        this.fRelaxationTime = n;
    }

    public int getRelaxationTime() {
        return this.fRelaxationTime;
    }

    private class LocalMouseListener
    extends MouseInputAdapter
    implements MouseWheelListener {
        private LocalMouseListener() {
        }

        @Override
        public void mousePressed(MouseEvent mouseEvent) {
            if (mouseEvent.getClickCount() == 1) {
                CellViewer.this.fDoubleClickTimer.setDelay(MJUtilities.getDoubleClickInterval());
                CellViewer.this.fDoubleClickTimer.start();
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        CellViewer.this.fClient.requestFocus();
                    }
                });
            }
            MouseEvent mouseEvent2 = MJUtilities.convertMouseEvent(mouseEvent.getComponent(), mouseEvent, CellViewer.this.fClient);
            if (CellViewer.this.fPopup != null && !CellViewer.this.fPopup.isUsingSwingPopup()) {
                CellViewer.this.hide();
            }
            CellViewer.this.fClient.dispatchEvent(mouseEvent2);
        }

        @Override
        public void mouseReleased(MouseEvent mouseEvent) {
            MouseEvent mouseEvent2 = MJUtilities.convertMouseEvent(mouseEvent.getComponent(), mouseEvent, CellViewer.this.fClient);
            CellViewer.this.fClient.dispatchEvent(mouseEvent2);
            if (CellViewer.this.fDoubleClickTimer.isRunning()) {
                CellViewer.this.fWasJustClicked = true;
            }
            CellViewer.this.hide();
        }

        @Override
        public void mouseMoved(MouseEvent mouseEvent) {
            MouseEvent mouseEvent2 = MJUtilities.convertMouseEvent(mouseEvent.getComponent(), mouseEvent, CellViewer.this.fClient);
            if (mouseEvent2.getX() >= ((CellViewer)CellViewer.this).fClientVisibleRect.x && mouseEvent2.getX() <= ((CellViewer)CellViewer.this).fClientVisibleRect.x + ((CellViewer)CellViewer.this).fClientVisibleRect.width && mouseEvent2.getY() >= ((CellViewer)CellViewer.this).fClientVisibleRect.y && mouseEvent2.getY() <= ((CellViewer)CellViewer.this).fClientVisibleRect.y + ((CellViewer)CellViewer.this).fClientVisibleRect.height) {
                CellViewer.this.fClient.dispatchEvent(mouseEvent2);
            } else {
                CellViewer.this.hide();
            }
        }

        @Override
        public void mouseDragged(MouseEvent mouseEvent) {
            this.mouseMoved(mouseEvent);
        }

        @Override
        public void mouseEntered(MouseEvent mouseEvent) {
            CellViewer.this.fMouseHasEntered = true;
            if (CellViewer.this.fHideTimer.isRunning()) {
                CellViewer.this.fHideTimer.setInitialDelay(CellViewer.this.fRelaxationTime);
                CellViewer.this.fHideTimer.restart();
            }
        }

        @Override
        public void mouseExited(MouseEvent mouseEvent) {
            CellViewer.this.hide();
        }

        @Override
        public void mouseWheelMoved(MouseWheelEvent mouseWheelEvent) {
            CellViewer.this.hide();
        }
    }

    private class CellPanel
    extends JPanel {
        private CellRendererPane fRendererPane;

        CellPanel() {
            this.setBorder(BorderFactory.createLineBorder(SystemColor.activeCaptionBorder));
            LocalMouseListener localMouseListener = new LocalMouseListener();
            this.addMouseListener(localMouseListener);
            this.addMouseMotionListener(localMouseListener);
            this.addMouseWheelListener(localMouseListener);
            this.fRendererPane = new CellRendererPane();
            this.add(this.fRendererPane);
        }

        @Override
        public void paintComponent(Graphics graphics) {
            if (CellViewer.this.fProvider != null) {
                Component component = CellViewer.this.fProvider.getCellPainter();
                if (component == null) {
                    CellViewer.this.hide();
                    return;
                }
                Insets insets = this.getInsets();
                Color color = component.getBackground();
                if (color != null) {
                    graphics.setColor(color);
                    graphics.fillRect(insets.left, insets.top, this.getWidth() - insets.left - insets.right, this.getHeight() - insets.top - insets.bottom);
                }
                this.fRendererPane.paintComponent(graphics, component, this, insets.left, insets.top, ((CellViewer)CellViewer.this).fPaintSize.width, ((CellViewer)CellViewer.this).fPaintSize.height, true);
            }
        }
    }
}

