/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mwswing;

import com.mathworks.mwswing.MJFrame;
import com.mathworks.util.PlatformInfo;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.SwingUtilities;

public class MJDialogParent
extends MJFrame {
    public MJDialogParent() {
        this((String)null);
    }

    public MJDialogParent(String string) {
        super(string);
        this.setLocation(-100, -100);
        this.setSize(0, 0);
        this.setResizable(false);
    }

    public void attachDialog(Dialog dialog) {
        this.addWindowListener(new FrameListener(dialog));
        DialogListener dialogListener = new DialogListener();
        dialog.addWindowListener(dialogListener);
        dialog.addComponentListener(dialogListener);
        Image image = MJDialogParent.findIcon(dialog.getOwner());
        if (image != null) {
            this.setIconImage(image);
        }
        if (PlatformInfo.isWindows()) {
            dialog.setAutoRequestFocus(false);
        }
    }

    private static Image findIcon(Window window) {
        Window window2;
        if (window instanceof Frame) {
            return ((Frame)window).getIconImage();
        }
        if (window instanceof Dialog && (window2 = window.getOwner()) != null) {
            return MJDialogParent.findIcon(window2);
        }
        return null;
    }

    @Override
    public void setVisible(boolean bl) {
        if (!PlatformInfo.isWindows()) {
            return;
        }
        super.setVisible(bl);
    }

    private class DialogListener
    extends WindowAdapter
    implements ComponentListener {
        private DialogListener() {
        }

        @Override
        public void windowOpened(WindowEvent windowEvent) {
            if (PlatformInfo.isWindows()) {
                MJDialogParent.this.setVisible(true);
            }
        }

        @Override
        public void windowClosing(WindowEvent windowEvent) {
            if (MJDialogParent.this.isVisible()) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            Thread.sleep(100L);
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                        MJDialogParent.this.setVisible(false);
                    }
                });
            }
        }

        @Override
        public void windowClosed(WindowEvent windowEvent) {
            MJDialogParent.this.setVisible(false);
        }

        @Override
        public void componentShown(ComponentEvent componentEvent) {
            MJDialogParent.this.setVisible(true);
        }

        @Override
        public void componentHidden(ComponentEvent componentEvent) {
            MJDialogParent.this.setVisible(false);
        }

        @Override
        public void componentResized(ComponentEvent componentEvent) {
        }

        @Override
        public void componentMoved(ComponentEvent componentEvent) {
        }
    }

    private static class FrameListener
    extends WindowAdapter {
        private final Dialog fDialog;

        private FrameListener(Dialog dialog) {
            this.fDialog = dialog;
        }

        @Override
        public void windowActivated(WindowEvent windowEvent) {
            if (this.fDialog.isVisible()) {
                this.fDialog.toFront();
            }
        }

        @Override
        public void windowClosing(WindowEvent windowEvent) {
            WindowEvent windowEvent2 = new WindowEvent(this.fDialog, 201);
            Toolkit.getDefaultToolkit().getSystemEventQueue().postEvent(windowEvent2);
        }

        @Override
        public void windowIconified(WindowEvent windowEvent) {
        }

        @Override
        public void windowDeiconified(WindowEvent windowEvent) {
            this.fDialog.setVisible(true);
        }
    }
}

