/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mwswing;

import com.mathworks.mwswing.ColorUtils;
import com.mathworks.mwswing.ComponentUtils;
import com.mathworks.mwswing.MJUtilities;
import com.mathworks.mwswing.binding.DefaultKeyBindings;
import com.mathworks.mwswing.binding.KeyBindingManager;
import com.mathworks.mwswing.binding.KeyBindingManagerRegistrant;
import com.mathworks.mwswing.text.TextContextMenu;
import com.mathworks.mwswing.text.TextDragRecognizer;
import com.mathworks.util.HTMLUtils;
import java.awt.Color;
import java.awt.Container;
import java.awt.Font;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.IOException;
import java.net.URL;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JPopupMenu;
import javax.swing.plaf.TextUI;
import javax.swing.text.html.HTMLDocument;

public class MJEditorPane
extends JEditorPane
implements KeyBindingManagerRegistrant {
    private ContextMenuListener fContextListener;
    private TextDragRecognizer fDragRecognizer;
    private boolean fWrapEnabled = true;

    public MJEditorPane() {
        this.initialize();
    }

    public MJEditorPane(URL uRL) throws IOException {
        super(uRL);
        this.initialize();
    }

    public MJEditorPane(String string) throws IOException {
        super(string);
        this.initialize();
    }

    public MJEditorPane(String string, String string2) {
        super(string, string2);
        this.initialize();
    }

    private void initialize() {
        this.registerWithKeyBindingManager(DefaultKeyBindings.getManager(), "DefaultContext");
    }

    @Override
    public void registerWithKeyBindingManager(KeyBindingManager keyBindingManager, String string) {
        MJUtilities.updateInputMap(this, keyBindingManager, string);
        this.addContextMenu(new TextContextMenu(keyBindingManager, string));
    }

    public void setWrapping(boolean bl) {
        this.fWrapEnabled = bl;
    }

    @Override
    public boolean getScrollableTracksViewportWidth() {
        Container container = this.getParent();
        TextUI textUI = this.getUI();
        return this.fWrapEnabled || container == null || textUI.getPreferredSize((JComponent)this).width <= container.getSize().width;
    }

    public void addContextMenu(JPopupMenu jPopupMenu) {
        if (this.fContextListener != null) {
            if (jPopupMenu == null) {
                this.removeContextMenu();
            } else {
                this.fContextListener.setMenu(jPopupMenu);
            }
        } else if (jPopupMenu != null) {
            this.fContextListener = new ContextMenuListener(jPopupMenu);
            this.addMouseListener(this.fContextListener);
        }
    }

    public void removeContextMenu() {
        if (this.fContextListener != null) {
            this.removeMouseListener(this.fContextListener);
            this.fContextListener = null;
        }
    }

    @Override
    public synchronized void addMouseListener(MouseListener mouseListener) {
        if (mouseListener instanceof TextDragRecognizer) {
            this.fDragRecognizer = (TextDragRecognizer)mouseListener;
        } else {
            super.addMouseListener(mouseListener);
        }
    }

    @Override
    public synchronized void removeMouseListener(MouseListener mouseListener) {
        if (mouseListener == this.fDragRecognizer) {
            this.fDragRecognizer = null;
        } else {
            super.removeMouseListener(mouseListener);
        }
    }

    public void setBackgroundColor(Color color) {
        this.setOpaque(true);
        this.setBackground(color);
        this.setHyperlinkColorToContrasting();
    }

    private void setHyperlinkColorToContrasting() {
        Color color = this.getHyperlinkColor();
        this.addRule("a", "color", HTMLUtils.convertColorToHex((Color)color));
    }

    public Color getHyperlinkColor() {
        return ColorUtils.getContrastingHyperlinkColor(ComponentUtils.getActualBackgroundColor(this));
    }

    @Override
    public void setFont(Font font) {
        super.setFont(font);
        if (this.getDocument() != null) {
            String string = "body { font-family: " + font.getFamily() + "; " + "font-size: " + font.getSize() + "pt; }";
            ((HTMLDocument)this.getDocument()).getStyleSheet().addRule(string);
        }
    }

    public void setFontColor(Color color) {
        this.addRule("body", "color", HTMLUtils.convertColorToHex((Color)color));
    }

    public void addRule(String string, String string2, String string3) {
        String string4 = string + " { " + string2 + " : " + string3 + "; }";
        ((HTMLDocument)this.getDocument()).getStyleSheet().addRule(string4);
    }

    @Override
    protected void processMouseEvent(MouseEvent mouseEvent) {
        if (this.fDragRecognizer != null) {
            int n = mouseEvent.getID();
            if (n == 501) {
                this.fDragRecognizer.mousePressed(mouseEvent);
            } else if (n == 502) {
                this.fDragRecognizer.mouseReleased(mouseEvent);
            }
            if (mouseEvent.isConsumed()) {
                return;
            }
        }
        super.processMouseEvent(mouseEvent);
    }

    @Override
    protected void processMouseMotionEvent(MouseEvent mouseEvent) {
        if (this.fDragRecognizer != null && mouseEvent.getID() == 506) {
            this.fDragRecognizer.mouseDragged(mouseEvent);
            if (mouseEvent.isConsumed()) {
                return;
            }
        }
        super.processMouseMotionEvent(mouseEvent);
    }

    private class ContextMenuListener
    extends MouseAdapter {
        private JPopupMenu fMenu;

        private ContextMenuListener(JPopupMenu jPopupMenu) {
            this.fMenu = jPopupMenu;
        }

        private void setMenu(JPopupMenu jPopupMenu) {
            this.fMenu = jPopupMenu;
        }

        @Override
        public void mousePressed(MouseEvent mouseEvent) {
            this.mouseReleased(mouseEvent);
        }

        @Override
        public void mouseReleased(MouseEvent mouseEvent) {
            if (mouseEvent.isPopupTrigger()) {
                MJEditorPane.this.requestFocus();
                this.fMenu.show(MJEditorPane.this, mouseEvent.getX(), mouseEvent.getY());
            }
        }
    }
}

