/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mwswing;

import com.mathworks.mwswing.BareSwingDetector;
import com.mathworks.mwswing.CheckThreadViolationRepaintManager;
import com.mathworks.mwswing.EdtExceptionHandler;
import com.mathworks.mwswing.MJStartupForDesktop;
import com.mathworks.mwswing.MJUtilities;
import com.mathworks.mwswing.MKeyEventDispatcher;
import com.mathworks.util.PlatformInfo;
import java.awt.AWTError;
import java.awt.KeyboardFocusManager;
import java.io.File;
import java.io.FileInputStream;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Properties;
import java.util.StringTokenizer;
import javax.swing.JPopupMenu;
import javax.swing.RepaintManager;
import javax.swing.ToolTipManager;

public class MJStartup {
    private static final boolean THREAD_CHECK_INVISIBLE = "true".equals(System.getProperty("mathworks.WarnIfNotVisible"));

    public MJStartup() {
        MJStartup.init();
    }

    public static void init() {
        MJStartup.init(true);
    }

    public static void init(boolean bl) {
        EdtExceptionHandler.registerExceptionHandler();
        if (PlatformInfo.isWindows()) {
            MJStartup.loadAssistiveTechnologies();
        }
        System.setProperty("sun.awt.noerasebackground", "true");
        String string = System.getProperty("mathworks.WarnIfWrongThread");
        if (string != null) {
            MJUtilities.setThreadingChecksEnabled(string.equalsIgnoreCase("true"));
        }
        if (MJUtilities.threadingChecksEnabled()) {
            RepaintManager.setCurrentManager(new CheckThreadViolationRepaintManager(THREAD_CHECK_INVISIBLE));
        }
        if (bl) {
            MJStartupForDesktop.init();
        }
        BareSwingDetector.init();
        KeyboardFocusManager.getCurrentKeyboardFocusManager().addKeyEventDispatcher(new MKeyEventDispatcher());
        JPopupMenu.setDefaultLightWeightPopupEnabled(false);
        ToolTipManager.sharedInstance().setLightWeightPopupEnabled(false);
        ToolTipManager.sharedInstance().setDismissDelay(10000);
        MJUtilities.initJIDE();
    }

    private static void loadAssistiveTechnologies() {
        final Properties properties = new Properties();
        AccessController.doPrivileged(new PrivilegedAction<Object>(){

            @Override
            public Object run() {
                Object object;
                try {
                    object = new File("accessibility.properties");
                    FileInputStream fileInputStream = new FileInputStream((File)object);
                    properties.load(fileInputStream);
                    fileInputStream.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                object = System.getProperty("javax.accessibility.screen_magnifier_present");
                if (object == null && (object = properties.getProperty("screen_magnifier_present", null)) != null) {
                    System.setProperty("javax.accessibility.screen_magnifier_present", (String)object);
                }
                return null;
            }
        });
        String string = properties.getProperty("assistive_technologies", null);
        ClassLoader classLoader = ClassLoader.getSystemClassLoader();
        if (string != null) {
            StringTokenizer stringTokenizer = new StringTokenizer(string, " ,");
            while (stringTokenizer.hasMoreTokens()) {
                String string2 = stringTokenizer.nextToken();
                try {
                    Class<?> clazz = classLoader != null ? classLoader.loadClass(string2) : Class.forName(string2);
                    clazz.newInstance();
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new AWTError("Assistive Technology not found: " + string2);
                }
                catch (InstantiationException instantiationException) {
                    throw new AWTError("Could not instantiate Assistive Technology: " + string2);
                }
                catch (IllegalAccessException illegalAccessException) {
                    throw new AWTError("Could not access Assistive Technology: " + string2);
                }
                catch (Exception exception) {
                    throw new AWTError("Error trying to install Assistive Technology: " + string2 + " " + exception);
                }
            }
        }
    }

    static {
        MJStartup.init(false);
    }
}

