/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mwswing;

import com.mathworks.mwswing.ExtendedButton;
import com.mathworks.mwswing.MJAbstractAction;
import com.mathworks.mwswing.MJButton;
import com.mathworks.mwswing.MJLabel;
import com.mathworks.mwswing.MJToggleButton;
import com.mathworks.mwswing.MJUtilities;
import com.mathworks.mwswing.MacAppearanceUtils;
import com.mathworks.mwswing.ScrollablePopupList;
import com.mathworks.util.PlatformInfo;
import java.awt.AlphaComposite;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ContainerEvent;
import java.awt.event.ContainerListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSeparator;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import javax.swing.plaf.ToolBarUI;
import javax.swing.plaf.basic.BasicBorders;
import javax.swing.plaf.basic.BasicToolBarUI;

public class MJToolBar
extends JToolBar {
    public static final String MORE_BUTTON_NAME = "MoreButton";
    private boolean fMorePopupEnabled;
    private int fMoreIndex = -1;
    private MJButton fMoreButton;
    private ScrollablePopupList fMorePopup;
    private int fMenuIndex = -1;
    private PopupMenuListener fMorePopupListener;
    private ContainerListener fContainerListener;
    private static Dimension sDefaultSeparatorSize = new Dimension(8, 6);
    private static int sDefaultGap = 4;
    private static Insets sButtonInsets = new Insets(1, 1, 2, 1);
    private static Border sFlyOverBorder;
    private static Border sToggleFlyOverBorder;
    private static Icon sMoreIcon;
    private static Insets sMoreMargin;
    protected static final Color ALPHA_SHADOW;
    public static final String NON_ESSENTIAL_PROPERTY_KEY = "NonEssentialComponent";
    public static final String MORE_MENU_INELIGIBLE_PROPERTY_KEY = "MoreMenuIneligible";
    private static final String CLEAR_ROLLOVER_LISTENER_PROPERTY_KEY = "ClearRolloverListener";

    public MJToolBar() {
        this.doCustomSetup();
    }

    public MJToolBar(int n) {
        super(n);
        this.doCustomSetup();
    }

    public MJToolBar(String string) {
        super(string);
        this.doCustomSetup();
    }

    public MJToolBar(String string, int n) {
        super(string, n);
        this.doCustomSetup();
    }

    protected void doCustomSetup() {
        this.setMorePopupEnabled(true);
    }

    public void setMorePopupEnabled(boolean bl) {
        if (this.fMorePopupEnabled != bl) {
            this.fMorePopupEnabled = bl;
            if (bl) {
                if (sMoreIcon == null) {
                    sMoreIcon = new ImageIcon(MJToolBar.class.getResource("resources/more.gif"));
                    sMoreMargin = new Insets(3, 0, 3, 0);
                }
                this.fMoreButton = new MJButton(sMoreIcon);
                this.fMoreButton.setName(MORE_BUTTON_NAME);
                MJToolBar.configureButton(this.fMoreButton);
                this.fMoreButton.setOpaque(false);
                this.fMoreButton.setMargin(sMoreMargin);
                this.fMoreButton.setVisible(false);
                if (this.getOrientation() == 0) {
                    this.fMoreButton.setVerticalAlignment(1);
                }
                this.fMoreButton.addMouseListener(new MouseAdapter(){

                    @Override
                    public void mousePressed(MouseEvent mouseEvent) {
                        if (!(mouseEvent.isPopupTrigger() || MJUtilities.isPopupPrecursor(mouseEvent) || MJUtilities.isMacintoshPopupTrigger(mouseEvent))) {
                            MJToolBar.this.showMorePopup();
                        }
                    }
                });
                this.add(this.fMoreButton);
                if (this.fContainerListener == null) {
                    this.fContainerListener = new LocalContainerListener();
                }
                this.addContainerListener(this.fContainerListener);
            } else if (this.fMoreButton != null) {
                this.remove(this.fMoreButton);
                this.fMoreButton = null;
                if (this.fMorePopup != null) {
                    this.fMorePopup.removePopupMenuListener(this.fMorePopupListener);
                    this.fMorePopup.cleanup();
                    this.fMorePopup = null;
                }
                this.fMoreIndex = -1;
                this.fMenuIndex = -1;
                this.removeContainerListener(this.fContainerListener);
            }
            this.invalidate();
            this.revalidate();
            this.repaint();
        }
    }

    public boolean isMorePopupEnabled() {
        return this.fMorePopupEnabled;
    }

    public Component getComponentExcludingMoreButton(int n) {
        if (!this.fMorePopupEnabled) {
            return super.getComponent(n);
        }
        for (int i = 0; i < this.getComponentCount(); ++i) {
            Component component = this.getComponent(i);
            if (component == this.fMoreButton) continue;
            if (n == 0) {
                return component;
            }
            --n;
        }
        return null;
    }

    public boolean isOnMoreMenu(Component component) {
        if (this.fMoreIndex < 0) {
            return false;
        }
        for (int i = 0; i < this.getComponentCount(); ++i) {
            if (component != this.getComponent(i)) continue;
            return i >= this.fMoreIndex && this.canPutOnMenu(component);
        }
        return false;
    }

    @Override
    public JButton add(Action action) {
        MJButton mJButton = new MJButton(action);
        MJToolBar.configureButton(mJButton);
        this.add(mJButton);
        return mJButton;
    }

    public JToggleButton addToggle(Action action) {
        MJToggleButton mJToggleButton = new MJToggleButton(action);
        MJToolBar.configureButton(mJToggleButton);
        this.add(mJToggleButton);
        return mJToggleButton;
    }

    public static void configure(ExtendedButton extendedButton) {
        if (extendedButton instanceof MJButton) {
            MJToolBar.configureButton((MJButton)extendedButton);
        } else if (extendedButton instanceof MJToggleButton) {
            MJToolBar.configureButton((MJToggleButton)extendedButton);
        }
    }

    public static void configureButton(final MJButton mJButton) {
        ActionListener actionListener;
        if (mJButton.getClientProperty(CLEAR_ROLLOVER_LISTENER_PROPERTY_KEY) == null) {
            actionListener = new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    mJButton.getModel().setRollover(false);
                }
            };
            mJButton.putClientProperty(CLEAR_ROLLOVER_LISTENER_PROPERTY_KEY, actionListener);
            mJButton.addActionListener(actionListener);
        }
        if ((actionListener = mJButton.getAction()) != null && actionListener.getValue("ToolBarText") instanceof String) {
            mJButton.setText((String)actionListener.getValue("ToolBarText"));
        } else if (mJButton.getIcon() != null) {
            mJButton.hideText();
            if (!PlatformInfo.isMacintosh()) {
                mJButton.setMargin(sButtonInsets);
            }
        }
        mJButton.setFocusTraversable(false);
        if (PlatformInfo.isMacintosh()) {
            mJButton.setBorderPainted(false);
            mJButton.setPressedIcon(MJToolBar.createMacPressedIcon(mJButton.getIcon()));
        } else {
            mJButton.setFlyOverAppearance(true);
            if (PlatformInfo.isWindows() && !PlatformInfo.isWindowsModernAppearance()) {
                mJButton.setBorder(MJToolBar.getFlyOverBorder());
            }
        }
    }

    public static void configureButton(MJToggleButton mJToggleButton) {
        MJToolBar.configureButton(mJToggleButton, true);
    }

    public static void configureButton(MJToggleButton mJToggleButton, boolean bl) {
        Action action = mJToggleButton.getAction();
        if (action != null && action.getValue("ToolBarText") instanceof String) {
            mJToggleButton.setText((String)action.getValue("ToolBarText"));
        } else if (mJToggleButton.getIcon() != null) {
            mJToggleButton.hideText();
            if (!PlatformInfo.isMacintosh()) {
                mJToggleButton.setMargin(sButtonInsets);
            }
        }
        mJToggleButton.setFocusTraversable(false);
        if (PlatformInfo.isMacintosh()) {
            if (bl) {
                MacAppearanceUtils.ButtonType.TEXTURED.apply(mJToggleButton);
            }
        } else {
            mJToggleButton.setFlyOverAppearance(true);
            if (PlatformInfo.isWindows() && !PlatformInfo.isWindowsModernAppearance()) {
                mJToggleButton.setBorder(MJToolBar.getToggleFlyOverBorder());
            }
        }
    }

    public static void markAsNonEssential(JComponent jComponent) {
        jComponent.putClientProperty(NON_ESSENTIAL_PROPERTY_KEY, Boolean.TRUE);
    }

    public static boolean isMarkedNonEssential(JComponent jComponent) {
        return jComponent.getClientProperty(NON_ESSENTIAL_PROPERTY_KEY) == Boolean.TRUE;
    }

    public static Border getFlyOverBorder() {
        if (sFlyOverBorder == null) {
            sFlyOverBorder = BorderFactory.createCompoundBorder(new BasicBorders.ButtonBorder(UIManager.getColor("control"), UIManager.getColor("controlShadow"), UIManager.getColor("control"), UIManager.getColor("controlLtHighlight")), new BasicBorders.MarginBorder());
        }
        return sFlyOverBorder;
    }

    public static Border getToggleFlyOverBorder() {
        if (sToggleFlyOverBorder == null) {
            sToggleFlyOverBorder = BorderFactory.createCompoundBorder(new BasicBorders.RadioButtonBorder(UIManager.getColor("control"), UIManager.getColor("controlShadow"), UIManager.getColor("control"), UIManager.getColor("controlLtHighlight")), new BasicBorders.MarginBorder());
        }
        return sToggleFlyOverBorder;
    }

    public static Icon createMacPressedIcon(Icon icon) {
        if (!(icon instanceof ImageIcon)) {
            return icon;
        }
        int n = icon.getIconWidth();
        int n2 = icon.getIconHeight();
        BufferedImage bufferedImage = new BufferedImage(n, n2, 2);
        Graphics2D graphics2D = (Graphics2D)bufferedImage.getGraphics();
        graphics2D.drawImage(((ImageIcon)icon).getImage(), 0, 0, null);
        graphics2D.setComposite(AlphaComposite.SrcAtop);
        graphics2D.setColor(ALPHA_SHADOW);
        graphics2D.fillRect(0, 0, n, n2);
        graphics2D.dispose();
        return new ImageIcon(bufferedImage);
    }

    public void setArmed(boolean bl) {
        for (int i = 0; i < this.getComponentCount(); ++i) {
            Component component = this.getComponent(i);
            if (!(component instanceof MJLabel)) continue;
            ((MJLabel)component).setArmed(bl);
        }
    }

    public void setInsideToolbarBorder() {
        if (PlatformInfo.isWindowsModernAppearance()) {
            this.setBorder(BorderFactory.createEmptyBorder(1, 0, 1, 0));
        } else {
            this.setBorder(null);
        }
    }

    @Override
    public void doLayout() {
        int n;
        int n2;
        int n3 = this.getComponentCount();
        ArrayList<Component> arrayList = null;
        if (this.getOrientation() == 0) {
            int n4;
            n2 = 0;
            n = 0;
            for (n4 = 0; n4 < n3; ++n4) {
                Component component = this.getComponent(n4);
                if (component == this.fMoreButton) continue;
                if (component instanceof JComponent && MJToolBar.isMarkedNonEssential((JComponent)component)) {
                    n += component.getPreferredSize().width;
                    component.setVisible(true);
                    ++n2;
                    continue;
                }
                if (!component.isVisible()) continue;
                n += component.getPreferredSize().width;
            }
            n4 = this.getWidth();
            for (int i = n3 - 1; i > 0 && n2 > 0 && n > n4; --i) {
                Component component = this.getComponent(i);
                if (!(component instanceof JComponent) || !MJToolBar.isMarkedNonEssential((JComponent)component)) continue;
                --n2;
                n -= component.getPreferredSize().width;
                component.setVisible(false);
                if (!(component instanceof JLabel) || ((JLabel)component).getLabelFor() == null) continue;
                if (arrayList == null) {
                    arrayList = new ArrayList<Component>();
                }
                arrayList.add(component);
            }
        }
        if (this.fMorePopupEnabled) {
            this.fMoreButton.setVisible(false);
        }
        super.doLayout();
        if (arrayList != null) {
            for (Component component : arrayList) {
                component.setBounds(this.getWidth() + 1, 0, 0, this.getHeight());
                component.setVisible(true);
            }
        }
        if (!this.fMorePopupEnabled || n3 <= 1 || this.isFloating()) {
            return;
        }
        n2 = this.getWidth();
        n = this.getHeight();
        Insets insets = this.getInsets();
        this.fMoreIndex = -1;
        if (this.getOrientation() == 0) {
            int n5;
            Component component = this.getComponent(n3 - 1);
            if (component == this.fMoreButton) {
                component = this.getComponent(n3 - 2);
            }
            if ((n5 = component.getX() + component.getWidth()) > n2) {
                int n6;
                int n7 = this.fMoreButton.getPreferredSize().width;
                int n8 = n5 - n2 + insets.right + n7 + 2;
                int n9 = 0;
                for (n6 = n3 - 1; n8 > 0 && n6 > 0; --n6) {
                    component = this.getComponent(n6);
                    if (!this.canPutOnMenu(component)) continue;
                    n8 -= component.getWidth();
                    component.setLocation(n2 + 1, component.getY());
                    if (this.isSpace(component)) continue;
                    ++n9;
                }
                if (n9 == 0) {
                    return;
                }
                this.fMoreIndex = n6 + 1;
                int n10 = 0;
                for (n6 = this.fMoreIndex; n6 < n3; ++n6) {
                    component = this.getComponent(n6);
                    if (this.canPutOnMenu(component)) {
                        n10 += component.getWidth();
                        continue;
                    }
                    component.setLocation(component.getX() - n10, component.getY());
                }
                this.fMoreButton.setVisible(true);
                this.fMoreButton.setBounds(n2 - n7, insets.top, n7, this.getHeight() - insets.top - insets.bottom);
            }
        } else {
            int n11;
            Component component = this.getComponent(n3 - 1);
            if (component == this.fMoreButton) {
                component = this.getComponent(n3 - 2);
            }
            if ((n11 = component.getY() + component.getHeight()) > n) {
                int n12;
                int n13 = this.fMoreButton.getPreferredSize().height;
                int n14 = n11 - n + insets.bottom + n13 + 2;
                int n15 = 0;
                for (n12 = n3 - 1; n14 > 0 && n12 > 0; --n12) {
                    component = this.getComponent(n12);
                    if (!this.canPutOnMenu(component)) continue;
                    n14 -= component.getHeight();
                    component.setLocation(component.getX(), n + 1);
                    if (this.isSpace(component)) continue;
                    ++n15;
                }
                if (n15 == 0) {
                    return;
                }
                this.fMoreIndex = n12 + 1;
                int n16 = 0;
                for (n12 = this.fMoreIndex; n12 < n3; ++n12) {
                    component = this.getComponent(n12);
                    if (this.canPutOnMenu(component)) {
                        n16 += component.getHeight();
                        continue;
                    }
                    component.setLocation(component.getX(), component.getY() - n16);
                }
                this.fMoreButton.setVisible(true);
                this.fMoreButton.setBounds(insets.left, n - n13, this.getWidth() - insets.left - insets.right, n13);
            }
        }
    }

    @Override
    public Dimension getPreferredSize() {
        Dimension dimension = new Dimension(super.getPreferredSize());
        if (this.fMoreButton != null && this.fMoreButton.isVisible()) {
            Dimension dimension2 = this.fMoreButton.getPreferredSize();
            if (this.getOrientation() == 0) {
                dimension.width -= dimension2.width;
            } else {
                dimension.height -= dimension2.height;
            }
        }
        return dimension;
    }

    @Override
    public Dimension getMinimumSize() {
        if (this.fMoreButton == null || this.isFloating()) {
            return super.getMinimumSize();
        }
        Dimension dimension = this.fMoreButton.getPreferredSize();
        for (int i = 0; i < this.getComponentCount(); ++i) {
            Component component = this.getComponent(i);
            if (!component.isVisible() || this.canPutOnMenu(component) || component instanceof JComponent && MJToolBar.isMarkedNonEssential((JComponent)component)) continue;
            Dimension dimension2 = component.getMinimumSize();
            if (this.getOrientation() == 0) {
                dimension.width += dimension2.width;
                if (dimension2.height <= dimension.height) continue;
                dimension.height = dimension2.height;
                continue;
            }
            dimension.height += dimension2.height;
            if (dimension2.width <= dimension.width) continue;
            dimension.width = dimension2.width;
        }
        Insets insets = this.getInsets();
        dimension.width += insets.left + insets.right;
        dimension.height += insets.top + insets.bottom;
        return dimension;
    }

    @Override
    public void removeAll() {
        super.removeAll();
        if (this.fMoreButton != null) {
            this.add(this.fMoreButton);
        }
    }

    public boolean isFloating() {
        ToolBarUI toolBarUI = this.getUI();
        if (toolBarUI instanceof BasicToolBarUI) {
            return ((BasicToolBarUI)toolBarUI).isFloating();
        }
        return false;
    }

    private boolean canPutOnMenu(Component component) {
        return component != this.fMoreButton && component instanceof AbstractButton && ((JComponent)component).getClientProperty(MORE_MENU_INELIGIBLE_PROPERTY_KEY) == null || component instanceof JSeparator || component instanceof VisibleSeparator;
    }

    private boolean isSpace(Component component) {
        return component instanceof JSeparator || component instanceof VisibleSeparator || component instanceof Gap;
    }

    public void dispose() {
        MJToolBar.dispose(this);
    }

    public static void dispose(JToolBar jToolBar) {
        int n = jToolBar.getComponentCount();
        for (int i = 0; i < n; ++i) {
            Component component = jToolBar.getComponent(i);
            if (!(component instanceof AbstractButton)) continue;
            MJUtilities.dispose((AbstractButton)component);
        }
    }

    @Override
    public void addSeparator() {
        this.add(new VisibleSeparator(this.getOrientation()));
    }

    @Override
    public void addSeparator(Dimension dimension) {
        this.add(new VisibleSeparator(this.getOrientation(), dimension));
    }

    public void addGap() {
        this.add(new Gap(sDefaultGap));
    }

    public void addGap(int n) {
        this.add(new Gap(n));
    }

    private void showMorePopup() {
        boolean bl = false;
        if (this.fMorePopup == null || this.fMenuIndex != this.fMoreIndex) {
            if (this.fMorePopup != null) {
                this.discardMorePopup();
            }
            this.fMenuIndex = this.fMoreIndex;
            this.fMorePopup = new ScrollablePopupList();
            boolean bl2 = true;
            int n = this.getComponentCount();
            for (int i = this.fMoreIndex; i < n; ++i) {
                Component component = this.getComponent(i);
                if (!this.canPutOnMenu(component)) continue;
                if (component instanceof AbstractButton) {
                    AbstractButton abstractButton = (AbstractButton)component;
                    Action action = abstractButton.getAction();
                    if (action == null) {
                        bl = true;
                        action = new SurrogateAction(abstractButton);
                    }
                    if (component instanceof JRadioButton) {
                        this.fMorePopup.addRadioButtonItem(action);
                    } else if (component instanceof JToggleButton) {
                        this.fMorePopup.addCheckBoxItem(action);
                    } else {
                        this.fMorePopup.addItem(action);
                    }
                    bl2 = false;
                    continue;
                }
                if (!(component instanceof JSeparator) && (!(component instanceof VisibleSeparator) || bl2)) continue;
                this.fMorePopup.addSeparator();
                bl2 = true;
            }
            if (bl2) {
                this.fMorePopup.removeSeparator();
            }
            if (this.fMorePopupListener == null) {
                this.fMorePopupListener = new MorePopupListener();
            }
            this.fMorePopup.addPopupMenuListener(this.fMorePopupListener);
        }
        if (this.fMorePopup != null && this.fMorePopup.getComponentCount() > 0) {
            this.fMorePopup.showPopup(this.fMoreButton, 0, this.fMoreButton.getHeight());
            if (bl) {
                this.discardMorePopup();
            }
        }
    }

    private void discardMorePopup() {
        this.fMorePopup.removePopupMenuListener(this.fMorePopupListener);
        this.fMorePopup.cleanup();
        this.fMorePopup = null;
    }

    static {
        ALPHA_SHADOW = new Color(0.0f, 0.0f, 0.0f, 0.5f);
    }

    private class LocalContainerListener
    implements ContainerListener {
        private LocalContainerListener() {
        }

        @Override
        public void componentAdded(ContainerEvent containerEvent) {
            if (MJToolBar.this.fMorePopup != null) {
                MJToolBar.this.discardMorePopup();
            }
        }

        @Override
        public void componentRemoved(ContainerEvent containerEvent) {
            if (MJToolBar.this.fMorePopup != null) {
                MJToolBar.this.discardMorePopup();
            }
        }
    }

    private class MorePopupListener
    implements PopupMenuListener {
        private MorePopupListener() {
        }

        @Override
        public void popupMenuWillBecomeVisible(PopupMenuEvent popupMenuEvent) {
        }

        @Override
        public void popupMenuWillBecomeInvisible(PopupMenuEvent popupMenuEvent) {
            MJToolBar.this.fMoreButton.doClick();
            MJToolBar.this.fMoreButton.dispatchEvent(new MouseEvent(MJToolBar.this.fMoreButton, 505, System.currentTimeMillis(), 0, 0, 0, 1, false));
        }

        @Override
        public void popupMenuCanceled(PopupMenuEvent popupMenuEvent) {
        }
    }

    private class SurrogateAction
    extends MJAbstractAction {
        AbstractButton fButton;

        SurrogateAction(AbstractButton abstractButton) {
            this.fButton = abstractButton;
            String string = abstractButton.getText();
            if (string == null || string.length() == 0) {
                string = abstractButton.getToolTipText();
            }
            this.setName(string);
            this.putValue("SmallIcon", abstractButton.getIcon());
            this.setEnabled(abstractButton.isEnabled());
            this.setSelected(abstractButton.isSelected());
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            this.fButton.doClick();
        }
    }

    private class Gap
    extends JPanel {
        int fExtent;

        public Gap(int n) {
            this.fExtent = n;
        }

        @Override
        public Dimension getPreferredSize() {
            if (MJToolBar.this.getOrientation() == 0) {
                return new Dimension(this.fExtent, 0);
            }
            return new Dimension(0, this.fExtent);
        }

        @Override
        public Dimension getMaximumSize() {
            return this.getPreferredSize();
        }
    }

    public static class VisibleSeparator
    extends JComponent {
        Dimension fPreferredSize;
        Dimension fMaxSize;

        public VisibleSeparator(int n, Dimension dimension) {
            Border border;
            JSeparator jSeparator;
            this.setLayout(new BorderLayout());
            this.setOpaque(false);
            this.fPreferredSize = dimension;
            if (n == 0) {
                this.fMaxSize = new Dimension(this.fPreferredSize.width, 1000);
                jSeparator = new JSeparator(1);
                int n2 = dimension.width - 2 >> 1;
                border = BorderFactory.createEmptyBorder(2, n2, 2, n2);
            } else {
                this.fMaxSize = new Dimension(1000, this.fPreferredSize.height);
                jSeparator = new JSeparator(0);
                int n3 = dimension.height - 2 >> 1;
                border = BorderFactory.createEmptyBorder(n3, 2, n3, 2);
            }
            this.setBorder(border);
            this.add((Component)jSeparator, 0);
        }

        public VisibleSeparator(int n) {
            this(n, sDefaultSeparatorSize);
        }

        @Override
        public Dimension getPreferredSize() {
            return this.fPreferredSize;
        }

        @Override
        public Dimension getMaximumSize() {
            return this.fMaxSize;
        }
    }
}

