/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mwswing.checkboxtree;

import com.mathworks.mwswing.checkboxtree.CheckBoxTree;
import com.mathworks.mwswing.checkboxtree.CheckBoxTreeCellRenderer;
import com.mathworks.mwswing.checkboxtree.Selectable;
import com.mathworks.mwswing.checkboxtree.SelectionState;
import java.awt.Component;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.EventObject;
import javax.swing.JTree;
import javax.swing.event.CellEditorListener;
import javax.swing.tree.DefaultTreeCellEditor;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.TreeCellEditor;
import javax.swing.tree.TreeCellRenderer;

public class CheckBoxTreeCellEditor
implements TreeCellEditor {
    private final TreeCellEditor fEditor;
    private final CheckBoxTreeCellRenderer fRenderer;
    private CheckBoxTree fTree;
    private Selectable fValue;

    public CheckBoxTreeCellEditor(CheckBoxTree checkBoxTree, TreeCellRenderer treeCellRenderer) {
        this(checkBoxTree, treeCellRenderer, new DefaultTreeCellEditor(checkBoxTree, new DefaultTreeCellRenderer()){

            @Override
            protected boolean canEditImmediately(EventObject eventObject) {
                return true;
            }
        });
    }

    public CheckBoxTreeCellEditor(CheckBoxTree checkBoxTree, TreeCellRenderer treeCellRenderer, TreeCellEditor treeCellEditor) {
        this.fTree = checkBoxTree;
        this.fEditor = treeCellEditor;
        this.fRenderer = new CheckBoxTreeCellRenderer(treeCellRenderer);
        this.setup();
    }

    private void setup() {
        this.fRenderer.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                if (!CheckBoxTreeCellEditor.this.fRenderer.isProgrammaticSelection()) {
                    CheckBoxTreeCellEditor.this.stopCellEditing();
                }
            }
        });
    }

    public void setShowDefaultIcons(boolean bl) {
        this.fRenderer.setShowDefaultIcons(bl);
    }

    public void setEditable(boolean bl) {
        this.fRenderer.setEnabled(bl);
    }

    @Override
    public void addCellEditorListener(CellEditorListener cellEditorListener) {
        this.fEditor.addCellEditorListener(cellEditorListener);
    }

    @Override
    public void removeCellEditorListener(CellEditorListener cellEditorListener) {
        this.fEditor.removeCellEditorListener(cellEditorListener);
    }

    @Override
    public void cancelCellEditing() {
        this.fEditor.cancelCellEditing();
    }

    @Override
    public boolean shouldSelectCell(EventObject eventObject) {
        return this.fEditor.shouldSelectCell(eventObject);
    }

    @Override
    public boolean stopCellEditing() {
        this.fValue.setSelectionState(this.fRenderer.isSelected() ? SelectionState.SELECTED : SelectionState.NOT_SELECTED);
        this.fRenderer.updateClientProperty(this.fValue.getSelectionState());
        if (this.fTree.isParentsReflectChildren()) {
            this.fTree.updateRelatives(this.fValue);
        }
        return true;
    }

    @Override
    public Object getCellEditorValue() {
        return this.fValue;
    }

    @Override
    public boolean isCellEditable(EventObject eventObject) {
        return this.fEditor.isCellEditable(eventObject);
    }

    @Override
    public Component getTreeCellEditorComponent(JTree jTree, Object object, boolean bl, boolean bl2, boolean bl3, int n) {
        Component component;
        if (object instanceof Selectable) {
            this.fValue = (Selectable)object;
            component = this.fRenderer.getTreeCellRendererComponent(jTree, object, bl, bl2, bl3, n, true);
        } else {
            component = this.fEditor.getTreeCellEditorComponent(jTree, object, bl, bl2, bl3, n);
        }
        return component;
    }
}

