/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mwswing.text;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.Shape;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.JTextComponent;
import javax.swing.text.LayeredHighlighter;
import javax.swing.text.Position;
import javax.swing.text.StyleConstants;
import javax.swing.text.View;

public class VerticalLinePainter
extends LayeredHighlighter.LayerPainter {
    private Color fColor;

    public VerticalLinePainter() {
        this(null);
    }

    public VerticalLinePainter(Color color) {
        this.fColor = color;
    }

    @Override
    public void paint(Graphics graphics, int n, int n2, Shape shape, JTextComponent jTextComponent) {
    }

    @Override
    public Shape paintLayer(Graphics graphics, int n, int n2, Shape shape, JTextComponent jTextComponent, View view) {
        Object object;
        Rectangle rectangle = null;
        if (n == view.getStartOffset() && n2 == view.getEndOffset()) {
            rectangle = shape instanceof Rectangle ? (Rectangle)shape : shape.getBounds();
        } else {
            try {
                object = view.modelToView(n, Position.Bias.Forward, n2, Position.Bias.Backward, shape);
                rectangle = object instanceof Rectangle ? (Rectangle)object : object.getBounds();
            }
            catch (BadLocationException badLocationException) {
                return null;
            }
        }
        object = view.getElement();
        AttributeSet attributeSet = object.getAttributes();
        Color color = null;
        if (this.fColor != null) {
            color = this.fColor;
        } else {
            color = StyleConstants.getForeground(attributeSet);
            if (color == null) {
                color = jTextComponent.getForeground();
            }
        }
        graphics.setColor(color);
        graphics.drawLine(rectangle.x, rectangle.y, rectangle.x, rectangle.y + rectangle.height - 1);
        return rectangle;
    }
}

