/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.matlabserver.jcp.dataHandlers;

import com.mathworks.matlabserver.jcp.dataHandlers.cellHandlers.CellHandler;
import com.mathworks.matlabserver.jcp.dataHandlers.cellHandlers.MasterCellHandler;
import com.mathworks.peermodel.pageddata.DataModelHandler2;
import com.mathworks.peermodel.pageddata.ServerPagedData;
import java.awt.Component;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.reflect.InvocationTargetException;
import java.util.Map;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.TableColumnModelEvent;
import javax.swing.event.TableColumnModelListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;

public class TableDataModelHandler
implements DataModelHandler2,
TableModelListener,
TableColumnModelListener,
PropertyChangeListener {
    private static ScheduledExecutorService threadPool = Executors.newScheduledThreadPool(1, new ThreadFactory(){

        @Override
        public Thread newThread(Runnable r) {
            Thread thread = new Thread(r, "table data handler");
            thread.setDaemon(true);
            return thread;
        }
    });
    protected final JTable table;
    protected TableModel dataModel;
    protected ServerPagedData serverPagedData;
    private AtomicBoolean dirty = new AtomicBoolean(false);
    private CellHandler<Object, Object> handler = new MasterCellHandler();
    private ScheduledFuture<?> future;

    public TableDataModelHandler(JTable table) {
        this.table = table;
        this.dataModel = table.getModel();
        this.addListeners();
    }

    protected void addListeners() {
        this.table.getColumnModel().addColumnModelListener(this);
        this.table.addPropertyChangeListener("model", this);
        this.table.addPropertyChangeListener("columnModel", this);
        this.addTableModelListeners(this.dataModel);
    }

    protected void destroyListeners() {
        this.table.getColumnModel().removeColumnModelListener(this);
        this.table.removePropertyChangeListener("model", this);
        this.table.removePropertyChangeListener("columnModel", this);
        this.removeTableModelListeners(this.dataModel);
    }

    protected void addTableModelListeners(TableModel dataModel) {
        if (dataModel != null) {
            dataModel.addTableModelListener(this);
        }
    }

    protected void removeTableModelListeners(TableModel dataModel) {
        if (dataModel != null) {
            dataModel.removeTableModelListener(this);
        }
    }

    public void update(ServerPagedData serverPagedData) {
        this.serverPagedData = serverPagedData;
    }

    public void destroy() {
        this.destroyListeners();
        this.dataModel = null;
    }

    public DataModelHandler2.PartialData getPartialData(final int startRow, final int startCol, final int endRow, final int endCol) {
        final DataModelHandler2.PartialData data = new DataModelHandler2.PartialData();
        try {
            if (SwingUtilities.isEventDispatchThread()) {
                this.doGetPartialData(startRow, startCol, endRow, endCol, data);
            } else {
                SwingUtilities.invokeAndWait(new Runnable(){

                    @Override
                    public void run() {
                        TableDataModelHandler.this.doGetPartialData(startRow, startCol, endRow, endCol, data);
                    }
                });
            }
        }
        catch (InterruptedException | InvocationTargetException e) {
            e.printStackTrace();
        }
        return data;
    }

    private void doGetPartialData(int startRow, int startCol, int endRow, int endCol, DataModelHandler2.PartialData data) {
        data.rowCount = this.getRowCount();
        data.columnCount = this.getColumnCount();
        int newEndRow = endRow;
        int newEndCol = endCol;
        if (newEndRow < 0 || newEndRow > data.rowCount) {
            newEndRow = data.rowCount;
        }
        if (newEndCol < 0 || newEndCol > data.columnCount) {
            newEndCol = data.columnCount;
        }
        data.startRow = startRow;
        data.startCol = startCol;
        data.endRow = newEndRow;
        data.endCol = newEndCol;
        if (startRow < 0 || startCol < 0) {
            data.partialData = null;
        } else {
            data.partialData = new Object[newEndRow - startRow][newEndCol - startCol];
            int i = startRow;
            int row = 0;
            while (i < newEndRow) {
                int j = startCol;
                int col = 0;
                while (j < newEndCol) {
                    ((Object[])data.partialData[row])[col] = this.doGetValueAt(i, j);
                    ++j;
                    ++col;
                }
                ++i;
                ++row;
            }
        }
    }

    public int getRowCount() {
        final int[] results = new int[]{0};
        try {
            if (SwingUtilities.isEventDispatchThread()) {
                if (this.dataModel != null) {
                    results[0] = this.dataModel.getRowCount();
                }
            } else {
                SwingUtilities.invokeAndWait(new Runnable(){

                    @Override
                    public void run() {
                        if (TableDataModelHandler.this.dataModel != null) {
                            results[0] = TableDataModelHandler.this.dataModel.getRowCount();
                        }
                    }
                });
            }
        }
        catch (InterruptedException | InvocationTargetException e) {
            e.printStackTrace();
        }
        return results[0];
    }

    public int getColumnCount() {
        final int[] results = new int[1];
        try {
            if (SwingUtilities.isEventDispatchThread()) {
                results[0] = this.table.getColumnCount();
            } else {
                SwingUtilities.invokeAndWait(new Runnable(){

                    @Override
                    public void run() {
                        results[0] = TableDataModelHandler.this.table.getColumnCount();
                    }
                });
            }
        }
        catch (InterruptedException | InvocationTargetException e) {
            e.printStackTrace();
        }
        return results[0];
    }

    public boolean is2D() {
        return true;
    }

    public Object getValueAt(final int row, final int col) {
        final Object[] results = new Object[1];
        try {
            if (SwingUtilities.isEventDispatchThread()) {
                results[0] = this.doGetValueAt(row, col);
            } else {
                SwingUtilities.invokeAndWait(new Runnable(){

                    @Override
                    public void run() {
                        results[0] = TableDataModelHandler.this.doGetValueAt(row, col);
                    }
                });
            }
        }
        catch (InterruptedException | InvocationTargetException e) {
            e.printStackTrace();
        }
        return results[0];
    }

    private Object doGetValueAt(int row, int col) {
        TableColumn column;
        if (row >= 0 && row < this.table.getModel().getRowCount() && col >= 0 && col < this.table.getColumnModel().getColumnCount() && (column = this.table.getColumnModel().getColumn(col)).getModelIndex() < this.table.getModel().getColumnCount()) {
            Object value = this.table.getModel().getValueAt(row, column.getModelIndex());
            TableCellRenderer cellRenderer = this.table.getCellRenderer(row, col);
            Component component = cellRenderer.getTableCellRendererComponent(this.table, value, false, false, row, col);
            return this.handler.getCellValue(this.table, cellRenderer, component, value);
        }
        return null;
    }

    public void setValueAt(final Object value, final int row, final int col) {
        try {
            if (SwingUtilities.isEventDispatchThread()) {
                this.doSetValueAt(value, row, col);
            } else {
                SwingUtilities.invokeAndWait(new Runnable(){

                    @Override
                    public void run() {
                        TableDataModelHandler.this.doSetValueAt(value, row, col);
                    }
                });
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void doSetValueAt(Object value, int row, int col) {
        TableCellEditor editor = this.table.getCellEditor(row, col);
        if (this.table.editCellAt(row, col)) {
            this.table.setCellEditor(editor);
            this.table.setEditingRow(row);
            this.table.setEditingColumn(col);
            Component component = this.table.getEditorComponent();
            this.handler.setCellValue(this.table, editor, component, value);
        }
    }

    public Object getValueAt(int row) {
        throw new UnsupportedOperationException("Not supported with 2D data models");
    }

    public void setValueAt(Object value, int row) {
        throw new UnsupportedOperationException("Not supported with 2D data models");
    }

    protected synchronized void markDirty() {
        this.dirty.set(true);
        if (this.future != null) {
            this.future.cancel(false);
        }
        this.future = threadPool.schedule(new Runnable(){

            @Override
            public void run() {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        if (TableDataModelHandler.this.serverPagedData != null && TableDataModelHandler.this.dirty.compareAndSet(true, false)) {
                            TableDataModelHandler.this.serverPagedData.update();
                        }
                    }
                });
            }
        }, 200L, TimeUnit.MILLISECONDS);
    }

    @Override
    public void tableChanged(TableModelEvent e) {
        this.markDirty();
    }

    @Override
    public void columnAdded(TableColumnModelEvent e) {
        this.markDirty();
    }

    @Override
    public void columnRemoved(TableColumnModelEvent e) {
        this.markDirty();
    }

    @Override
    public void columnMoved(TableColumnModelEvent e) {
        this.markDirty();
    }

    @Override
    public void columnMarginChanged(ChangeEvent e) {
    }

    @Override
    public void columnSelectionChanged(ListSelectionEvent e) {
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (evt.getPropertyName().equals("model")) {
            this.removeTableModelListeners(this.dataModel);
            this.dataModel = (TableModel)evt.getNewValue();
            this.addTableModelListeners(this.dataModel);
        } else if (evt.getPropertyName().equals("columnModel")) {
            ((TableColumnModel)evt.getOldValue()).removeColumnModelListener(this);
            ((TableColumnModel)evt.getNewValue()).addColumnModelListener(this);
        }
        this.markDirty();
    }

    public void dispatchCellEvent(final int row, final int col, final Map<String, Object> data) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                TableColumn column = TableDataModelHandler.this.table.getColumnModel().getColumn(col);
                Object value = TableDataModelHandler.this.table.getModel().getValueAt(row, column.getModelIndex());
                TableCellRenderer cellRenderer = TableDataModelHandler.this.table.getCellRenderer(row, col);
                Component component = cellRenderer.getTableCellRendererComponent(TableDataModelHandler.this.table, value, false, false, row, col);
                TableDataModelHandler.this.handler.dispatchCellEvent(TableDataModelHandler.this.table, cellRenderer, component, data);
            }
        });
    }
}

