/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.matlabserver.jcp.handlers.componentHandlers;

import com.mathworks.hg.util.AllFileFilter;
import com.mathworks.matlabserver.fileservices.util.FilenameConverter;
import com.mathworks.matlabserver.internalservices.serviceregistry.RegistryService;
import com.mathworks.matlabserver.internalservices.serviceregistry.ServiceRegistryFactory;
import com.mathworks.matlabserver.jcp.handlers.Handler;
import com.mathworks.matlabserver.jcp.handlers.componentHandlers.AbstractComponentHandler;
import com.mathworks.matlabserver.worker.desktopservices.UserManager;
import com.mathworks.mwswing.FilePatternFilter;
import com.mathworks.mwswing.MJFileChooser;
import com.mathworks.peermodel.PeerNode;
import com.mathworks.peermodel.events.Event;
import com.mathworks.peermodel.events.Observer;
import java.awt.Component;
import java.awt.Toolkit;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.SwingUtilities;
import javax.swing.filechooser.FileFilter;

public class JFileChooserHandler
extends AbstractComponentHandler {
    protected JFileChooser chooser;
    private static final String[] TYPES = new String[]{"open", "save", "open"};
    private Observer observer = new Observer(){

        public void handle(final Event event) {
            SwingUtilities.invokeLater(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    if (event.getType().equals("cancel") || event.getData().get("name") == null) {
                        Toolkit.getDefaultToolkit().getSystemEventQueue().postEvent(new WindowEvent((JDialog)JFileChooserHandler.this.component, 201));
                    } else {
                        try {
                            File file = new File((String)event.getData().get("location"), (String)event.getData().get("name"));
                            String path = file.getAbsolutePath();
                            if (JFileChooserHandler.this.filenameConverter != null && JFileChooserHandler.this.userManager != null && JFileChooserHandler.this.userManager.getUserToken() != null) {
                                path = JFileChooserHandler.this.filenameConverter.convertFilenameFromWorkerToServer(JFileChooserHandler.this.userManager.getUserToken(), path);
                            }
                            file = new File(path);
                            for (FileFilter filter : JFileChooserHandler.this.chooser.getChoosableFileFilters()) {
                                if (!filter.accept(file)) continue;
                                JFileChooserHandler.this.chooser.setFileFilter(filter);
                                break;
                            }
                            JFileChooserHandler.this.chooser.ensureFileIsVisible(file);
                            JFileChooserHandler.this.chooser.setSelectedFile(file);
                            JFileChooserHandler.this.chooser.approveSelection();
                        }
                        finally {
                            if (JFileChooserHandler.this.component.isVisible() && JFileChooserHandler.this.component.isValid()) {
                                Toolkit.getDefaultToolkit().getSystemEventQueue().postEvent(new WindowEvent((JDialog)JFileChooserHandler.this.component, 201));
                            }
                        }
                    }
                }
            });
        }
    };
    private UserManager userManager;
    private FilenameConverter filenameConverter;

    @Override
    public String getType() {
        return "FileChooser";
    }

    @Override
    public void handle(Handler parentHandler, Component component, PeerNode parent) {
        RegistryService registry = ServiceRegistryFactory.getServiceRegistry();
        this.userManager = (UserManager)registry.getService(UserManager.class);
        this.filenameConverter = (FilenameConverter)registry.getService(FilenameConverter.class);
        this.chooser = (JFileChooser)((JDialog)component).getContentPane().getComponent(0);
        if (this.chooser instanceof MJFileChooser) {
            ((MJFileChooser)this.chooser).setApproveListener(null);
            ((MJFileChooser)this.chooser).setShowOverwriteDialog(false);
        }
        super.handle(parentHandler, component, parent);
    }

    @Override
    protected void addPeerNodeListeners() {
        super.addPeerNodeListeners();
        this.peerNode.addEventListener("peerEvent", this.observer);
    }

    @Override
    protected void removePeerNodeListeners() {
        super.removePeerNodeListeners();
        this.peerNode.removeEventListener("peerEvent", this.observer);
    }

    @Override
    protected Map<String, Object> doGetProperties(Component component) {
        String currentDirectory;
        ConcurrentHashMap<String, Object> props = new ConcurrentHashMap<String, Object>();
        try {
            currentDirectory = this.chooser.getCurrentDirectory().getCanonicalPath();
        }
        catch (IOException e) {
            currentDirectory = this.chooser.getCurrentDirectory().getAbsolutePath();
        }
        if (this.filenameConverter != null && this.userManager != null && this.userManager.getUserToken() != null) {
            currentDirectory = this.filenameConverter.convertFilenameFromServerToWorker(this.userManager.getUserToken(), currentDirectory);
        }
        props.put("currentDirectory", currentDirectory);
        props.put("title", this.chooser.getDialogTitle() != null ? this.chooser.getDialogTitle() : "");
        props.put("chooserType", TYPES[this.chooser.getDialogType()]);
        props.put("selectionMode", this.chooser.getFileSelectionMode());
        props.put("filters", this.getFilters());
        return props;
    }

    private Object[] getFilters() {
        FileFilter[] fileFilters = this.chooser.getChoosableFileFilters();
        ArrayList<HashMap<String, Object>> filters = new ArrayList<HashMap<String, Object>>();
        for (FileFilter fileFilter : fileFilters) {
            HashMap<String, Object> filter = new HashMap<String, Object>();
            this.setFilterProperties(filter, fileFilter);
            if (this.chooser.getFileFilter() == fileFilter) {
                filter.put("selected", true);
            }
            filters.add(filter);
        }
        return filters.toArray();
    }

    private void setFilterProperties(Map<String, Object> filter, FileFilter fileFilter) {
        filter.put("label", fileFilter.getDescription());
        if (fileFilter instanceof AllFileFilter) {
            filter.put("patterns", new String[]{"*"});
        } else if (fileFilter.getClass().getName().contains("PatternBasedFilter")) {
            try {
                Field origField = fileFilter.getClass().getDeclaredField("iOrigFilter");
                origField.setAccessible(true);
                this.setFilterProperties(filter, (FileFilter)origField.get(fileFilter));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else if (fileFilter instanceof FilePatternFilter) {
            filter.put("patterns", ((FilePatternFilter)fileFilter).getPatterns());
        }
    }
}

