/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.matlabserver.jcp.handlers.pixelHandlers.image;

import com.mathworks.matlabserver.jcp.handlers.pixelHandlers.image.ImageStreamClient;
import com.mathworks.matlabserver.jcp.handlers.pixelHandlers.image.StreamBufferedImage;
import com.mathworks.messageservice.Message;
import com.mathworks.messageservice.MessageService;
import com.mathworks.messageservice.MessageServiceFactory;
import com.mathworks.messageservice.Subscriber;
import com.mathworks.peermodel.synchronizer.utils.ImageDifferencer;
import java.awt.image.BufferedImage;
import java.util.Collection;
import java.util.Map;

public class ImageStreamClientImpl
implements ImageStreamClient,
Subscriber {
    private final Object lock = new Object();
    private final String channel;
    private MessageService messageService;
    private BufferedImage image;

    public ImageStreamClientImpl(String channel) {
        this(channel, MessageServiceFactory.getMessageService());
    }

    public ImageStreamClientImpl(String channel, MessageService messageService) {
        this.channel = channel;
        this.messageService = messageService;
    }

    @Override
    public void start() {
        this.messageService.subscribe(this.channel + "/*", (Subscriber)this);
        this.messageService.publish(this.channel + "/getFullUpdate", (Object)"");
    }

    @Override
    public void stop() {
        this.messageService.unsubscribe(this.channel + "/*", (Subscriber)this);
    }

    @Override
    public BufferedImage getImage() {
        return this.image;
    }

    @Override
    public String getChannel() {
        return this.channel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public void handle(Message message) {
        if (message.getChannel().endsWith("fullUpdate")) {
            Object object = this.lock;
            // MONITORENTER : object
            this.image = ((StreamBufferedImage)message.getData()).getImage();
            // MONITOREXIT : object
            this.messageService.publish(this.channel + "/ready", (Object)"");
            return;
        }
        if (!message.getChannel().endsWith("diff")) {
            if (!message.getChannel().endsWith("ready")) return;
            this.messageService.publish(this.channel + "/ready", (Object)"");
            return;
        }
        BufferedImage newImage = null;
        Object object = this.lock;
        // MONITORENTER : object
        if (this.image != null) {
            Collection diffs = (Collection)message.getData();
            for (Map diff : diffs) {
                diff.put("image", ((StreamBufferedImage)diff.get("image")).getImage());
            }
            this.image = newImage = ImageDifferencer.applyImageDifferences((BufferedImage)this.image, (Collection)diffs);
        }
        // MONITOREXIT : object
        if (newImage != null) {
            this.messageService.publish(this.channel + "/ready", (Object)"");
            return;
        }
        this.messageService.publish(this.channel + "/error", (Object)"");
        throw new IllegalStateException("No image available to apply diff to");
    }
}

