/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.matlabserver.jcp.handlers.tableHandlers;

import com.mathworks.matlabserver.jcp.handlers.tableHandlers.TreeModelHandler;
import com.mathworks.matlabserver.jcp.utils.ImageUtils;
import java.awt.Component;
import java.beans.PropertyDescriptor;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.JTree;
import javax.swing.tree.DefaultTreeCellRenderer;
import org.apache.commons.beanutils.PropertyUtils;

public class ReflectionNodeConverter
extends TreeModelHandler.NodeConverter {
    private final List<String> blacklistProperties;
    private JTree tree = null;

    public ReflectionNodeConverter() {
        this(new String[0]);
    }

    public ReflectionNodeConverter(JTree tree, String[] blackListProperties) {
        this(blackListProperties);
        this.tree = tree;
    }

    public ReflectionNodeConverter(String[] blacklistProperties) {
        this.blacklistProperties = Arrays.asList(blacklistProperties);
    }

    public ReflectionNodeConverter(List<String> blacklistProperties) {
        this.blacklistProperties = blacklistProperties;
    }

    @Override
    public void convertNode(Object node, Map<String, Object> properties) {
        PropertyDescriptor[] descriptors;
        for (PropertyDescriptor descriptor : descriptors = PropertyUtils.getPropertyDescriptors((Object)node)) {
            Class<?> propType = descriptor.getPropertyType();
            if (descriptor.getReadMethod() == null || propType == null || this.blacklistProperties.contains(descriptor.getName())) continue;
            try {
                if (!this.isSupportedPropertyType(propType)) continue;
                descriptor.getReadMethod().setAccessible(true);
                Object value = descriptor.getReadMethod().invoke(node, new Object[0]);
                if (value == null) continue;
                this.handleProperty(descriptor.getName(), propType, node, value, properties);
            }
            catch (Exception e) {
                System.out.println("Error while converting property: " + descriptor.getName());
                e.printStackTrace();
            }
        }
    }

    protected void handleProperty(String key, Class propType, Object node, Object value, Map<String, Object> properties) {
        if (propType.equals(Icon.class)) {
            Icon icon = (Icon)value;
            properties.put(key, ImageUtils.getImageFromIcon(icon, null));
        } else if (this.tree != null && key.equalsIgnoreCase("icon") && value instanceof String) {
            Component comp = this.tree.getCellRenderer().getTreeCellRendererComponent(this.tree, node, true, true, true, 0, true);
            if (comp instanceof DefaultTreeCellRenderer) {
                properties.put(key, ImageUtils.getImageFromIcon(((DefaultTreeCellRenderer)comp).getLeafIcon(), null));
            } else {
                properties.put(key, value);
            }
        } else {
            properties.put(key, value);
        }
    }

    protected boolean isSupportedPropertyType(Class propType) {
        return propType.equals(String.class) || propType.equals(Boolean.TYPE) || propType.equals(Integer.TYPE) || propType.equals(Float.TYPE) || propType.equals(Double.TYPE) || propType.equals(String[].class) || propType.equals(boolean[].class) || propType.equals(int[].class) || propType.equals(float[].class) || propType.equals(double[].class) || propType.equals(Boolean.class) || propType.equals(Integer.class) || propType.equals(Float.class) || propType.equals(Double.class) || propType.equals(Boolean[].class) || propType.equals(Integer[].class) || propType.equals(Float[].class) || propType.equals(Double[].class) || propType.equals(Icon.class);
    }
}

