/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.matlabserver.jcp.utils;

import com.mathworks.peermodel.PeerNode;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.lang.reflect.Field;
import java.util.Date;
import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.imageio.ImageIO;
import javax.swing.SwingUtilities;
import sun.misc.BASE64Encoder;

public class MouseHandler {
    private static final Logger logger = Logger.getLogger(MouseHandler.class.getSimpleName());
    private static final String[] CURSOR_MAP = new String[14];
    private Component component;
    private boolean dragging = false;
    private boolean movedAfterDown = false;
    private int mouseButton = 0;
    private Point lastMousePoint = null;
    private MouseEvent lastEvent = null;

    public MouseHandler(Component component) {
        this.component = component;
    }

    public void mouseDown(Point point, int modifiers, int button) {
        this.mouseButton = button;
        if (!this.dragging) {
            this.dragging = true;
            this.mousePressed(point, modifiers, this.mouseButton, 1);
            this.movedAfterDown = false;
            this.lastMousePoint = point;
        } else {
            this.mousePressed(point, modifiers, this.mouseButton, 1);
        }
    }

    public void mouseUp(Point point, int modifiers) {
        if (this.dragging) {
            if (Math.abs(point.x - this.lastMousePoint.x) > 2 || Math.abs(point.y - this.lastMousePoint.y) > 2) {
                this.move(point, modifiers);
            } else {
                point = this.lastMousePoint;
            }
            if (!this.movedAfterDown) {
                this.mouseReleased(point, modifiers, this.mouseButton, 1);
            } else {
                this.mouseReleased(point, modifiers, this.mouseButton, 0);
            }
            this.dragging = false;
        }
    }

    public void move(Point point, int modifiers) {
        this.lastMousePoint = point;
        Component target = this.getChildComponentAt(point);
        Point targetPoint = SwingUtilities.convertPoint(this.component, point, target);
        if (this.dragging) {
            target.dispatchEvent(new MouseEvent(target, 506, new Date().getTime(), modifiers | this.getButtonModifier(this.mouseButton), targetPoint.x, targetPoint.y, 0, false, this.mouseButton));
            this.movedAfterDown = true;
        } else {
            target.dispatchEvent(new MouseEvent(target, 503, new Date().getTime(), modifiers | this.getButtonModifier(this.mouseButton), targetPoint.x, targetPoint.y, 0, false, this.mouseButton));
        }
    }

    public void click(Point point) {
        this.click(point, 0, 1);
    }

    public void click(Point point, int modifiers, int button) {
        this.click(point, modifiers, button, 1);
    }

    public void doubleClick(Point point, int modifiers, int button) {
        this.mouseButton = button;
        this.click(point, modifiers, this.mouseButton, 1);
        this.click(point, modifiers, this.mouseButton, 2);
    }

    private void click(Point point, int modifiers, int button, int count) {
        if (this.dragging) {
            this.mouseUp(point, modifiers);
        }
        if (this.movedAfterDown || this.lastEvent == null || this.lastEvent.getID() != 502 || new Date().getTime() - this.lastEvent.getWhen() > 500L) {
            this.movedAfterDown = false;
            this.mousePressed(point, modifiers, button, count);
            this.mouseReleased(point, modifiers, button, count);
        }
        this.mouseClicked(point, modifiers, button, count);
    }

    private void mousePressed(Point point, int modifiers, int button, int count) {
        Component target = this.getChildComponentAt(point);
        Point targetPoint = SwingUtilities.convertPoint(this.component, point, target);
        this.lastEvent = new MouseEvent(target, 501, new Date().getTime(), modifiers | this.getButtonModifier(button), targetPoint.x, targetPoint.y, count, (button & 3) == 3, button);
        target.dispatchEvent(this.lastEvent);
    }

    private void mouseReleased(Point point, int modifiers, int button, int count) {
        Component target = this.getChildComponentAt(point);
        Point targetPoint = SwingUtilities.convertPoint(this.component, point, target);
        this.lastEvent = new MouseEvent(target, 502, new Date().getTime(), modifiers | this.getButtonModifier(button), targetPoint.x, targetPoint.y, count, (button & 3) == 3, button);
        target.dispatchEvent(this.lastEvent);
    }

    private void mouseClicked(Point point, int modifiers, int button, int count) {
        Component target = this.getChildComponentAt(point);
        Point targetPoint = SwingUtilities.convertPoint(this.component, point, target);
        this.lastEvent = new MouseEvent(target, 500, new Date().getTime(), modifiers | this.getButtonModifier(button), targetPoint.x, targetPoint.y, count, (button & 3) == 3, button);
        target.dispatchEvent(this.lastEvent);
    }

    private Component getChildComponentAt(Point point) {
        Component target = null;
        return target == null ? this.component : target;
    }

    private int getButtonModifier(int button) {
        switch (button) {
            case 1: {
                return 1040;
            }
            case 2: {
                return 2056;
            }
            case 3: {
                return 4100;
            }
        }
        return 0;
    }

    public void updateCursor(PeerNode peerNode, Object requestId) {
        try {
            Cursor cursor = this.component.getCursor();
            HashMap<String, Object> data = new HashMap<String, Object>();
            if (cursor.getType() == -1) {
                Field image;
                try {
                    image = cursor.getClass().getSuperclass().getDeclaredField("image");
                }
                catch (Exception ignore) {
                    image = cursor.getClass().getSuperclass().getSuperclass().getDeclaredField("image");
                }
                image.setAccessible(true);
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                ImageIO.write((RenderedImage)((BufferedImage)image.get(cursor)), "png", baos);
                byte[] bytesOut = baos.toByteArray();
                BASE64Encoder base64Encoder = new BASE64Encoder();
                String cursorImage = base64Encoder.encode(bytesOut);
                cursorImage = cursorImage.replaceAll("\\s", "");
                data.put("customCursor", cursorImage);
            } else if (cursor.getType() > 0 && cursor.getType() < CURSOR_MAP.length) {
                data.put("cursor", CURSOR_MAP[cursor.getType()]);
            } else {
                data.put("cursor", cursor.getName());
            }
            data.put("type", "onchangecursor");
            data.put("responseId", requestId);
            peerNode.dispatchEvent("peerEvent", peerNode, data);
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "Error while dispatching custom cursor peer event: ", e);
        }
    }

    static {
        MouseHandler.CURSOR_MAP[0] = "default";
        MouseHandler.CURSOR_MAP[1] = "crosshair";
        MouseHandler.CURSOR_MAP[2] = "text";
        MouseHandler.CURSOR_MAP[3] = "wait";
        MouseHandler.CURSOR_MAP[4] = "sw-resize";
        MouseHandler.CURSOR_MAP[5] = "se-resize";
        MouseHandler.CURSOR_MAP[6] = "nw-resize";
        MouseHandler.CURSOR_MAP[7] = "ne-resize";
        MouseHandler.CURSOR_MAP[8] = "n-resize";
        MouseHandler.CURSOR_MAP[9] = "s-resize";
        MouseHandler.CURSOR_MAP[10] = "w-resize";
        MouseHandler.CURSOR_MAP[11] = "e-resize";
        MouseHandler.CURSOR_MAP[12] = "pointer";
        MouseHandler.CURSOR_MAP[13] = "move";
    }
}

