/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.matlabserver.jcp.utils;

import com.mathworks.matlabserver.jcp.utils.RepaintListener;
import java.awt.Component;
import java.awt.Rectangle;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JComponent;
import javax.swing.RepaintManager;
import javax.swing.SwingUtilities;

public class ObservableRepaintManager
extends RepaintManager {
    private static Logger logger = Logger.getLogger(ObservableRepaintManager.class.getName());
    private static ObservableRepaintManager instance = null;
    private static final Map<JComponent, Set<RepaintListener>> componentList = new HashMap<JComponent, Set<RepaintListener>>();
    private final Field dirtyComponentsField;

    public ObservableRepaintManager() {
        try {
            this.dirtyComponentsField = RepaintManager.class.getDeclaredField("dirtyComponents");
            this.dirtyComponentsField.setAccessible(true);
        }
        catch (NoSuchFieldException e) {
            throw new IllegalStateException("This should never happen unless the JVM changes");
        }
    }

    public static synchronized ObservableRepaintManager getInstance() {
        if (instance == null) {
            instance = new ObservableRepaintManager();
        }
        return instance;
    }

    public synchronized void addRepaintListener(JComponent component, RepaintListener listener) {
        if (!componentList.containsKey(component)) {
            componentList.put(component, new HashSet());
        }
        componentList.get(component).add(listener);
    }

    public synchronized void removeRepaintListener(JComponent component, RepaintListener listener) {
        if (componentList.containsKey(component)) {
            componentList.get(component).remove(listener);
            if (componentList.get(component).isEmpty()) {
                componentList.remove(component);
            }
        }
    }

    @Override
    public void paintDirtyRegions() {
        final ArrayList<RepaintEvent> listeners = new ArrayList<RepaintEvent>();
        try {
            Map dirtyComponents = (Map)this.dirtyComponentsField.get(this);
            for (Map.Entry dirty : dirtyComponents.entrySet()) {
                for (Map.Entry<JComponent, Set<RepaintListener>> entry : componentList.entrySet()) {
                    if (!SwingUtilities.isDescendingFrom(entry.getKey(), (Component)dirty.getKey()) || ((Rectangle)dirty.getValue()).width <= 0 || ((Rectangle)dirty.getValue()).height <= 0) continue;
                    for (RepaintListener listener : entry.getValue()) {
                        listeners.add(new RepaintEvent(listener, entry.getKey()));
                    }
                }
            }
        }
        catch (Exception e) {
            logger.log(Level.WARNING, "Unable to get dirty components: ", e);
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                for (RepaintEvent event : listeners) {
                    event.listener.componentRepainted(event.component);
                }
            }
        });
        super.paintDirtyRegions();
    }

    private class RepaintEvent {
        public final RepaintListener listener;
        public final JComponent component;

        public RepaintEvent(RepaintListener listener, JComponent component) {
            this.listener = listener;
            this.component = component;
        }
    }
}

