/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.matlabserver.jcp.utils;

import com.mathworks.matlabserver.common.util.CalledFromMATLAB;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.Window;
import java.awt.event.MouseEvent;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JViewport;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;

public class SwingInspector {
    @CalledFromMATLAB
    public static void start() {
        for (Window window : Window.getWindows()) {
            SwingInspector.printComponentRecursive(window, 0);
        }
        System.out.println();
    }

    private static void printComponentRecursive(Component component, int depth) {
        SwingInspector.printComponent(component, depth);
        if (component instanceof JScrollPane) {
            SwingInspector.printComponentRecursive(((JScrollPane)component).getViewport(), depth + 1);
        } else if (component instanceof Frame) {
            SwingInspector.printFrame((Frame)component, depth);
        } else if (component instanceof Dialog) {
            SwingInspector.printDialog((Dialog)component, depth);
        } else if (component instanceof Window) {
            SwingInspector.printWindow((Window)component, depth);
        } else if (component instanceof JTable) {
            SwingInspector.printJTable((JTable)component, depth);
        } else if (component instanceof JMenuItem) {
            SwingInspector.printJMenuItem((JMenuItem)component, depth);
        } else if (component instanceof JPanel) {
            SwingInspector.printJPanel((JPanel)component, depth);
        } else if (component instanceof JViewport) {
            SwingInspector.printComponent(((JViewport)component).getView(), depth + 1);
        } else if (component instanceof Container) {
            SwingInspector.printContainer((Container)component, depth);
        }
    }

    private static void printComponent(Component component, int depth) {
        if (component == null) {
            return;
        }
        if (component.getGraphics() != null) {
            component.getGraphics().drawRect(0, 0, component.getWidth() - 1, component.getHeight() - 1);
        }
        if (component instanceof JComponent && ((JComponent)component).getBorder() != null) {
            SwingInspector.printSpaces(depth + 2);
            System.out.print("Border: ");
            SwingInspector.printObjectClass(((JComponent)component).getBorder(), "\n");
        }
        SwingInspector.printSpaces(depth);
        if (component.getName() != null) {
            System.out.print(component.getName() + ": ");
        }
        SwingInspector.printObjectClass(component, ", visible: " + component.isVisible() + "\n");
    }

    private static void printJMenuItem(JMenuItem menuItem, int depth) {
        SwingInspector.printSpaces(depth + 2);
        System.out.println("Label: " + menuItem.getText());
    }

    private static void printFrame(Frame frame, int depth) {
        SwingInspector.printSpaces(depth + 2);
        System.out.println("Title: " + frame.getTitle() + ", modalExclusion: " + (Object)((Object)frame.getModalExclusionType()));
        SwingInspector.printSpaces(depth + 2);
        System.out.println("Parent window: " + frame.getParent());
        SwingInspector.printContainer(frame, depth);
    }

    private static void printDialog(Dialog dialog, int depth) {
        SwingInspector.printSpaces(depth + 2);
        System.out.println("Title: " + dialog.getTitle() + ", modalExclusion: " + (Object)((Object)dialog.getModalExclusionType()) + ", modality: " + (Object)((Object)dialog.getModalityType()));
        SwingInspector.printSpaces(depth + 2);
        System.out.print("Parent window: " + dialog.getParent());
        SwingInspector.printContainer(dialog, depth);
    }

    private static void printWindow(Window window, int depth) {
        SwingInspector.printSpaces(depth + 2);
        System.out.println("ModalExclusion: " + (Object)((Object)window.getModalExclusionType()));
        SwingInspector.printSpaces(depth + 2);
        System.out.print("Parent window: " + window.getParent());
        SwingInspector.printContainer(window, depth);
    }

    private static void printJPanel(JPanel panel, int depth) {
        SwingInspector.printContainer(panel, depth);
    }

    private static void printJTable(JTable table, int depth) {
        MouseEvent mouseEvent = new MouseEvent(table, 500, System.currentTimeMillis(), 0, 0, 0, 2, false, 1);
        for (int i = 0; i < table.getColumnCount(); ++i) {
            SwingInspector.printSpaces(depth + 2);
            System.out.print("Column: ");
            if (table.getRowCount() > 0) {
                SwingInspector.printObjectClass(table.getDefaultRenderer(table.getColumnClass(i)), " / ");
                SwingInspector.printObjectClass(table.getDefaultEditor(table.getColumnClass(i)), ", ");
            }
            System.out.print(table.getColumnModel().getColumn(i).getModelIndex() + ":");
            System.out.print(table.getColumnModel().getColumn(i).getIdentifier() + ": ");
            SwingInspector.printObjectClass(table.getColumnModel().getColumn(i).getCellRenderer(), " / ");
            TableCellEditor editor = table.getColumnModel().getColumn(i).getCellEditor();
            if (editor != null) {
                System.out.print(editor.isCellEditable(mouseEvent) + "-");
            }
            SwingInspector.printObjectClass(editor, "\n");
        }
        for (int row = 0; row < table.getRowCount(); ++row) {
            SwingInspector.printSpaces(depth + 2);
            System.out.println("Row " + row);
            for (int col = 0; col < table.getColumnCount(); ++col) {
                SwingInspector.printSpaces(depth + 3);
                System.out.print("Cell " + col + ": ");
                TableCellRenderer renderer = table.getCellRenderer(row, col);
                SwingInspector.printObjectClass(renderer, ", ");
                TableCellEditor editor = table.getCellEditor(row, col);
                if (editor != null) {
                    System.out.print(editor.isCellEditable(mouseEvent) + " - ");
                }
                SwingInspector.printObjectClass(editor, "\n");
                Object value = table.getModel().getValueAt(row, col);
                Component cell = renderer.getTableCellRendererComponent(table, value, true, true, row, col);
                SwingInspector.printComponent(cell, depth + 4);
                if (editor == null || !editor.isCellEditable(mouseEvent)) continue;
                cell = editor.getTableCellEditorComponent(table, value, true, row, col);
                SwingInspector.printComponent(cell, depth + 4);
            }
        }
    }

    private static void printContainer(Container component, int depth) {
        for (int i = 0; i < component.getComponentCount(); ++i) {
            SwingInspector.printComponentRecursive(component.getComponent(i), depth + 1);
        }
    }

    private static void printSpaces(int depth) {
        for (int i = 0; i < depth; ++i) {
            System.out.print("  ");
        }
    }

    private static void printObjectClass(Object obj, String trailing) {
        if (obj != null) {
            String className = obj.getClass().getSimpleName();
            if (className.length() == 0) {
                className = "anon";
                if (obj.getClass().getEnclosingClass() != null) {
                    className = className + "|" + obj.getClass().getEnclosingClass().getSimpleName();
                }
                if (obj.getClass().getInterfaces().length > 0) {
                    className = className + "|" + obj.getClass().getInterfaces()[0].getSimpleName();
                }
            }
            System.out.print(className + " <: " + obj.getClass().getSuperclass().getSimpleName());
        } else {
            System.out.print("null");
        }
        System.out.print(trailing);
    }
}

