/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.instutil.wizard;

import com.mathworks.instutil.wizard.Printer;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.print.PageFormat;
import java.awt.print.Paper;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import javax.swing.RepaintManager;

public abstract class AbstractPrinter
implements Printer {
    private boolean printed;

    @Override
    public void print(Component component) {
        PrinterJob printerJob = PrinterJob.getPrinterJob();
        if (printerJob.printDialog()) {
            try {
                PageFormat pageFormat = new PageFormat();
                Paper paper = new Paper();
                double d = pageFormat.getImageableX();
                double d2 = pageFormat.getImageableY();
                double d3 = pageFormat.getImageableWidth();
                double d4 = pageFormat.getImageableHeight();
                paper.setImageableArea(d, d2 - 75.0, d3, d4 + 130.0);
                pageFormat.setPaper(paper);
                pageFormat.setOrientation(1);
                printerJob.setPrintable(new ComponentPrintableAdapter(component), pageFormat);
                printerJob.print();
                this.printed = true;
            }
            catch (PrinterException printerException) {
                this.handlePrinterException(printerException);
            }
        }
    }

    protected abstract void handlePrinterException(PrinterException var1);

    @Override
    public boolean isPrinted() {
        return this.printed;
    }

    private static final class ComponentPrintableAdapter
    implements Printable {
        private final Component comp;
        private boolean currentDoubleBufferingState;

        ComponentPrintableAdapter(Component component) {
            this.comp = component;
        }

        @Override
        public int print(Graphics graphics, PageFormat pageFormat, int n) throws PrinterException {
            int n2;
            Graphics2D graphics2D = (Graphics2D)graphics;
            int n3 = this.comp.getSize().height;
            double d = pageFormat.getImageableHeight();
            int n4 = Double.valueOf(d).intValue();
            int n5 = n3 / n4;
            if (n3 % n4 > 0) {
                ++n5;
            }
            if (n >= n5) {
                n2 = 1;
            } else {
                Dimension dimension = this.comp.getSize();
                this.comp.setSize((int)pageFormat.getImageableWidth(), n3);
                double d2 = pageFormat.getImageableX();
                double d3 = pageFormat.getImageableY();
                graphics2D.translate(d2, d3);
                graphics2D.translate(0.0, (double)(-n) * (double)n4);
                this.disableDoubleBufferingForFasterPrinting();
                this.comp.paint(graphics2D);
                this.comp.setPreferredSize(dimension);
                this.restoreDoubleBuffering();
                n2 = 0;
            }
            return n2;
        }

        private RepaintManager getCurrentRepaintManager() {
            return RepaintManager.currentManager(this.comp);
        }

        private void disableDoubleBufferingForFasterPrinting() {
            RepaintManager repaintManager = this.getCurrentRepaintManager();
            this.currentDoubleBufferingState = repaintManager.isDoubleBufferingEnabled();
            repaintManager.setDoubleBufferingEnabled(false);
        }

        private void restoreDoubleBuffering() {
            RepaintManager repaintManager = this.getCurrentRepaintManager();
            repaintManager.setDoubleBufferingEnabled(this.currentDoubleBufferingState);
        }
    }
}

