/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.peermodel.synchronizer.utils;

import com.mathworks.peermodel.PeerNode;
import com.mathworks.peermodel.PeerSynchronizer;
import com.mathworks.peermodel.events.Event;
import com.mathworks.peermodel.impl.EventImpl;
import com.mathworks.peermodel.synchronizer.utils.PropertyEventImpl;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import javax.swing.SwingUtilities;

public class EventCoalescer {
    private static final List<String> IMMEDIATE_EVENTS = new ArrayList<String>();
    private final PeerSynchronizer peerSynchronizer;
    private final ExecutorService es = Executors.newSingleThreadExecutor(new ThreadFactory(){

        @Override
        public Thread newThread(Runnable r) {
            Thread thread = new Thread(r);
            thread.setName("event coalescer");
            thread.setDaemon(true);
            return thread;
        }
    });
    private static final int MIN_DELAY = 50;
    private static final int MAX_DELAY = 1000;
    private static final int MAX_QUEUE_SIZE = 1000;
    private ScheduledFuture<?> futureFlush;
    private final ScheduledExecutorService scheduler = Executors.newScheduledThreadPool(1, new ThreadFactory(){

        @Override
        public Thread newThread(Runnable r) {
            Thread thread = new Thread(r);
            thread.setName("event coalescer");
            thread.setDaemon(true);
            return thread;
        }
    });
    private final Map<String, Method> publishMethods = new HashMap<String, Method>();
    private List<Event> queuedOperation = new ArrayList<Event>();
    private CoalescerListener listener = null;
    private long lastUpdated = -1L;

    public EventCoalescer(PeerSynchronizer peerSynchronizer) {
        this.peerSynchronizer = peerSynchronizer;
    }

    public synchronized List<Event> flushNow() {
        this.lastUpdated = System.currentTimeMillis();
        if (this.queuedOperation.size() == 0) {
            return new ArrayList<Event>(0);
        }
        ArrayList<Event> copy = new ArrayList<Event>(this.queuedOperation);
        this.queuedOperation.clear();
        this.publishOperations(copy);
        if (this.listener != null) {
            this.listener.eventsPublished(copy);
        }
        return copy;
    }

    public synchronized void add(Event event) {
        if (this.futureFlush != null) {
            this.futureFlush.cancel(false);
        }
        if (this.queuedOperation.isEmpty()) {
            this.lastUpdated = System.currentTimeMillis();
        }
        this.coalesceEvent(event);
        if (this.queuedOperation.size() > 1000 || IMMEDIATE_EVENTS.contains(event.getType())) {
            this.flushNow();
        } else if (this.lastUpdated < 0L || System.currentTimeMillis() - this.lastUpdated < 1000L) {
            this.futureFlush = this.scheduler.schedule(new Runnable(){

                @Override
                public void run() {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            EventCoalescer.this.flushNow();
                        }
                    });
                }
            }, 50L, TimeUnit.MILLISECONDS);
        } else {
            this.flushNow();
        }
    }

    private void coalesceEvent(Event event) {
        String eventType = event.getType();
        if (eventType.equals("childAdded")) {
            this.queuedOperation = this.coalesceChildAdded(this.queuedOperation, event);
        } else if (eventType.equals("subTreeDestroyed")) {
            this.queuedOperation = this.coalesceSubTreeDestroyed(this.queuedOperation, event);
        } else if (eventType.equals("propertySet")) {
            this.queuedOperation = this.coalescePropertySet(this.queuedOperation, event);
        } else if (eventType.equals("propertyUnset")) {
            this.queuedOperation = this.coalescePropertyUnset(this.queuedOperation, event);
        } else {
            this.queuedOperation.add(event);
        }
    }

    List<Event> coalesceChildAdded(List<Event> queuedOperation, Event event) {
        PeerNode child = (PeerNode)event.getData().get("child");
        List<Event> subTreeAdded = this.getQueuedOfTypeAndDescendant(queuedOperation, "subTreeAdded", child);
        if (subTreeAdded.size() == 0) {
            queuedOperation.add((Event)new EventImpl("subTreeAdded", event.getTarget(), event.getData()));
        }
        return queuedOperation;
    }

    List<Event> coalesceSubTreeDestroyed(List<Event> queuedOperation, Event event) {
        PeerNode target = event.getTarget();
        List<Event> subTreeAdded = this.getQueuedOfTypeAndDescendantOrChild(queuedOperation, "subTreeAdded", target);
        if (subTreeAdded.size() == 0) {
            PeerNode child = (PeerNode)event.getData().get("child");
            boolean isSameNode = false;
            ArrayList<Event> list = new ArrayList<Event>();
            for (Event e : queuedOperation) {
                PeerNode c = (PeerNode)e.getData().get("child");
                String type = e.getType();
                boolean bl = isSameNode = isSameNode || e.getType().equals("subTreeAdded") && c == child;
                if (!(type.equals("subTreeAdded") && (child == c || child.hasDescendant(c.getId())) || type.equals("subTreeDestroyed") && child == e.getTarget() || (type.equals("propertiesSet") || type.equals("propertiesUnset")) && child == e.getTarget())) {
                    list.add(e);
                    continue;
                }
                if (!type.equals("subTreeAdded") || child != c) continue;
                this.updateChildOperationIndices(queuedOperation, e.getTarget(), (Integer)event.getData().get("index"));
            }
            queuedOperation = list;
            if (!isSameNode) {
                queuedOperation.add((Event)new EventImpl("subTreeDestroyed", target, event.getData()));
            }
        }
        return queuedOperation;
    }

    List<Event> coalescePropertySet(List<Event> queuedOperation, Event event) {
        PeerNode target = event.getTarget();
        List<Event> subTreeAdded = this.getQueuedOfTypeAndDescendantOrChild(queuedOperation, "subTreeAdded", target);
        if (subTreeAdded.size() == 0) {
            PropertyEventImpl propertiesSetEvent;
            Map<Object, Object> props;
            List<Event> propertiesSet = this.getSubListWithEventTypeAndTarget(queuedOperation, "propertiesSet", target);
            if (propertiesSet.size() == 0) {
                props = new HashMap();
                props.put("newValues", new HashMap());
                if (event.getData().containsKey("versionVector")) {
                    props.put("versionVector", event.getData().get("versionVector"));
                }
                propertiesSetEvent = new PropertyEventImpl("propertiesSet", target, props);
                queuedOperation.add(propertiesSetEvent);
            } else {
                propertiesSetEvent = (PropertyEventImpl)propertiesSet.get(0);
                props = propertiesSetEvent.getData();
            }
            Map properties = (Map)props.get("newValues");
            properties.put((String)event.getData().get("key"), event.getData().get("newValue"));
            if (event.getData().containsKey("versionVector")) {
                if (!props.containsKey("versionVector")) {
                    props.put("versionVector", new HashMap());
                }
                ((Map)props.get("versionVector")).putAll((Map)event.getData().get("versionVector"));
            }
        }
        ArrayList<Event> list = new ArrayList<Event>();
        for (Event e : queuedOperation) {
            if (e.getType().equals("propertiesUnset") && e.getTarget() == event.getTarget()) {
                Map oldValues = (Map)e.getData().get("oldValues");
                oldValues.remove((String)event.getData().get("key"));
                if (oldValues.size() <= 0) continue;
                list.add(e);
                continue;
            }
            list.add(e);
        }
        return list;
    }

    List<Event> coalescePropertyUnset(List<Event> queuedOperation, Event event) {
        PeerNode target = event.getTarget();
        List<Event> subTreeAdded = this.getQueuedOfTypeAndDescendantOrChild(queuedOperation, "subTreeAdded", target);
        if (subTreeAdded.size() == 0) {
            PropertyEventImpl propertiesUnsetEvent;
            Map<Object, Object> props;
            List<Event> propertiesUnset = this.getSubListWithEventTypeAndTarget(queuedOperation, "propertiesUnset", target);
            if (propertiesUnset.size() == 0) {
                props = new HashMap();
                props.put("oldValues", new HashMap());
                propertiesUnsetEvent = new PropertyEventImpl("propertiesUnset", target, props);
                queuedOperation.add(propertiesUnsetEvent);
            } else {
                propertiesUnsetEvent = (PropertyEventImpl)propertiesUnset.get(0);
                props = propertiesUnsetEvent.getData();
            }
            Map oldValues = (Map)props.get("oldValues");
            oldValues.put((String)event.getData().get("key"), event.getData().get("oldValue"));
        }
        ArrayList<Event> list = new ArrayList<Event>();
        for (Event e : queuedOperation) {
            if (e.getType().equals("propertiesSet") && e.getTarget() == event.getTarget()) {
                Map values = (Map)e.getData().get("newValues");
                values.remove(event.getData().get("key"));
                if (values.size() <= 0) continue;
                list.add(e);
                continue;
            }
            list.add(e);
        }
        return list;
    }

    private List<Event> updateChildOperationIndices(List<Event> list, PeerNode parent, int index) {
        for (int i = 0; i < list.size(); ++i) {
            Event event = list.get(i);
            if (!event.getData().containsKey("index")) continue;
            int eventIndex = (Integer)event.getData().get("index");
            int childIndex = event.getTarget().getChildIndex((PeerNode)event.getData().get("child"));
            if (event.getTarget() != parent || childIndex < index) continue;
            list.set(i, this.changeEventData(event, "index", eventIndex - 1));
        }
        return list;
    }

    private Event changeEventData(Event oldEvent, String key, Object newValue) {
        HashMap<String, Object> data = new HashMap<String, Object>(oldEvent.getData());
        data.put(key, newValue);
        return new EventImpl(oldEvent.getType(), oldEvent.getTarget(), data);
    }

    public void publishOperations(List<Event> operations) {
        for (Event event : operations) {
            Method publishMethod = this.getMethod(event);
            try {
                publishMethod.invoke((Object)this.peerSynchronizer, event);
            }
            catch (Exception e) {}
        }
    }

    private Method getMethod(Event event) {
        String type = event.getType();
        String methodName = "publish" + type.substring(0, 1).toUpperCase() + type.substring(1) + "Message";
        if (!this.publishMethods.containsKey(methodName)) {
            try {
                Method m = this.peerSynchronizer.getClass().getMethod(methodName, Event.class);
                this.publishMethods.put(methodName, m);
            }
            catch (NoSuchMethodException e) {
                // empty catch block
            }
        }
        return this.publishMethods.get(methodName);
    }

    private List<Event> getSubListWithEventTypeAndTarget(List<Event> queuedOperation, String eventType, PeerNode target) {
        ArrayList<Event> list = new ArrayList<Event>();
        for (Event event : queuedOperation) {
            if (!event.getType().equals(eventType) || event.getTarget() != target) continue;
            list.add(event);
        }
        return list;
    }

    private List<Event> getQueuedOfTypeAndDescendant(List<Event> queuedOperation, String eventType, PeerNode target) {
        ArrayList<Event> list = new ArrayList<Event>();
        for (Event event : queuedOperation) {
            PeerNode child = (PeerNode)event.getData().get("child");
            if (!event.getType().equals(eventType) || !child.hasDescendant(target.getId())) continue;
            list.add(event);
        }
        return list;
    }

    private List<Event> getQueuedOfTypeAndDescendantOrChild(List<Event> queuedOperation, String eventType, PeerNode target) {
        ArrayList<Event> list = new ArrayList<Event>();
        for (Event event : queuedOperation) {
            if (!event.getData().containsKey("child")) continue;
            PeerNode child = (PeerNode)event.getData().get("child");
            if (!event.getType().equals(eventType) || !child.hasDescendant(target.getId()) && child != target) continue;
            list.add(event);
        }
        return list;
    }

    public void cleanUp() {
        this.es.shutdownNow();
        this.scheduler.shutdownNow();
    }

    public void listenForPublish(CoalescerListener listener) {
        this.listener = listener;
    }

    static {
        IMMEDIATE_EVENTS.add("rootSet");
        IMMEDIATE_EVENTS.add("rootDestroyed");
        IMMEDIATE_EVENTS.add("childMoved");
        IMMEDIATE_EVENTS.add("childDetached");
        IMMEDIATE_EVENTS.add("childReattached");
        IMMEDIATE_EVENTS.add("peerEvent");
    }

    static interface CoalescerListener {
        public void eventsPublished(List<Event> var1);
    }
}

