/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.peermodel.synchronizer.utils;

import com.mathworks.peermodel.synchronizer.utils.ImageDifferenceStrategy;
import com.mathworks.peermodel.synchronizer.utils.strategies.ImageDifferenceStrategy0;
import com.mathworks.peermodel.synchronizer.utils.strategies.ImageDifferenceStrategy1;
import com.mathworks.peermodel.synchronizer.utils.strategies.ImageDifferenceStrategy1c;
import com.mathworks.peermodel.synchronizer.utils.strategies.ImageDifferenceStrategy2;
import java.awt.Graphics;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;

public class ImageDifferencer {
    private static ImageDifferenceStrategy strategy = new ImageDifferenceStrategy1c();

    public static void setStrategy(String strategy) {
        if (strategy.equals("0")) {
            ImageDifferencer.setStrategyClass(ImageDifferenceStrategy0.class);
        } else if (strategy.equals("1")) {
            ImageDifferencer.setStrategyClass(ImageDifferenceStrategy1.class);
        } else if (strategy.equals("2")) {
            ImageDifferencer.setStrategyClass(ImageDifferenceStrategy2.class);
        } else if (strategy.equals("1c")) {
            ImageDifferencer.setStrategyClass(ImageDifferenceStrategy1c.class);
        } else {
            throw new IllegalArgumentException("Invalid strategy name " + strategy);
        }
    }

    public static void setParameters(Map<String, Object> parameters) {
        strategy.setParameters(parameters);
    }

    private static void setStrategyClass(Class strategyClass) {
        if (strategy != null && strategy.getClass().equals(strategyClass)) {
            return;
        }
        try {
            strategy = (ImageDifferenceStrategy)strategyClass.newInstance();
        }
        catch (InstantiationException e) {
            throw new IllegalStateException("Unable to instantiate strategy class");
        }
        catch (IllegalAccessException e) {
            throw new IllegalStateException("Unable to access strategy class");
        }
    }

    public static Collection<Map<String, Object>> computeImageDifferences(BufferedImage oldImage, BufferedImage newImage) {
        if (oldImage.getType() != newImage.getType()) {
            throw new IllegalArgumentException("old image type " + oldImage.getType() + " != " + "new image type " + newImage.getType());
        }
        ArrayList<Map<String, Object>> diffs = new ArrayList<Map<String, Object>>();
        strategy.diffImages(oldImage, newImage, diffs);
        return diffs;
    }

    public static BufferedImage applyImageDifferences(BufferedImage oldImage, Collection<Map<String, Object>> differences) {
        BufferedImage newImage = new BufferedImage(oldImage.getWidth(), oldImage.getHeight(), oldImage.getType());
        Graphics g = newImage.getGraphics();
        g.drawImage(oldImage, 0, 0, null);
        for (Map<String, Object> diff : differences) {
            g.drawImage((BufferedImage)diff.get("image"), (Integer)diff.get("x"), (Integer)diff.get("y"), null);
        }
        return newImage;
    }
}

